---
title: Apache Mesos - Working Groups
layout: documentation
---

# Working Groups
* **External Volumes**
	* members:
		* Adam B
* **Global resources**
	* members:
		* Adam B
		* Jie Yu
		* Joerg Schad
		* Klaus Ma
	* resources:
		* [MESOS-2728](https://issues.apache.org/jira/browse/MESOS-2728)
* **GPU support**
	* communication:
		* irc: mesos-gpus
		* slack: [#gpus](https://mesos.slack.com/messages/gpus/)
		* mailing list subject prefix: GPU
	* members:
		* Benjamin Mahler
		* Felix Abecassis
		* Ian Downes
		* Jonathan Calmels
		* Kevin Klues
		* Rob Todd
		* Vikrama Ditya
	* resources:
		* [MESOS-4424](https://issues.apache.org/jira/browse/MESOS-4424)
* **HTTP API**
	* communication:
		* irc: mesos-http-api
		* slack: [#http-api](https://mesos.slack.com/messages/http-api/)
		* mailing list subject prefix: HTTP API
	* members:
		* Anand Mazumdar
		* Benjamin Mahler
		* Isabel Jimenez
		* Vinod Kone
	* resources:
		* [Executor Design Doc](https://docs.google.com/document/d/1dFmTrSZXCo5zj8H8SkJ4HT-V0z2YYnEZVV8Fd_-AupM/edit?usp=sharing)
		* [Master discovery](https://docs.google.com/document/d/1i2pWJaIjnFYhuR-000NG-AC1rFKKrRh3Wn47Y2G6lRE/edit?usp=sharing)
		* [MESOS-2288](https://issues.apache.org/jira/browse/MESOS-2288)
		* [MESOS-3302](https://issues.apache.org/jira/browse/MESOS-3302)
		* [Scheduler HTTP API Design doc](https://docs.google.com/document/d/1pnIY_HckimKNvpqhKRhbc9eSItWNFT-priXh_urR-T0/edit?usp=sharing)
		* [Scheduler HTTP API User doc](https://github.com/apache/mesos/blob/master/docs/scheduler_http_api.md)
		* [Versioning HTTP API](https://docs.google.com/document/d/1-iQjo6778H_fU_1Zi_Yk6szg8qj-wqYgVgnx7u3h6OU/edit?usp=sharing)
* **Nested Container**
	* communication:
		* [Google group](https://groups.google.com/forum/#!forum/mesos-containerizer-dev-wg)
	* members:
		* James Peach
		* Jie Yu
		* Kapil Arya
		* Zhitao Li
	* resources:
		* [MESOS-3333](https://issues.apache.org/jira/browse/MESOS-3333)
* **Networking**
	* members:
		* Jie Yu
		* Kapil Arya
		* Niklas Nielsen
	* communication:
	    * slack [#networking](https://mesos.slack.com/messages/networking/)
	* resources:
		* [IP Address Manager Enable Per-Container IP in Mesos](https://docs.google.com/document/d/17mXtAmdAXcNBwp_JfrxmZcQrs7EO6ancSbejrqjLQ0g/edit)
		* [MESOS-2044](https://issues.apache.org/jira/browse/MESOS-2044)
* **Oversubscription**
	* communication:
		* irc: mesos-oversubscription
	* members:
		* Bartłomiej Płotka
		* Jie Yu
		* Joris Van Remoortere
		* Niklas Nielsen
		* Vinod Kone
	* resources:
		* [Mesos Oversubscription Design](https://docs.google.com/document/d/1pUnElxHy1uWfHY_FOvvRC73QaOGgdXE0OXN-gbxdXA0/edit)
		* [MESOS-2044](https://issues.apache.org/jira/browse/MESOS-2044)
* **Performance Isolation**
	* communication:
		* [hangout](https://hangouts.google.com/hangouts/_/intel.com/mesos-isolation)
	* members:
		* Benjamin Mahler
		* Connor Doyle
		* Ian Downes
		* Jie Yu
		* Kevin Klues
		* Niklas Nielsen,
	* resources:
		* [meeting notes](https://docs.google.com/document/d/11mlGPZSABItP47J6VX-zB0fAK6Qr1mCIOI7nhlATMqk/edit)
		* [MESOS-4138](https://issues.apache.org/jira/browse/MESOS-4138)
		* [Mesos: exclusive resources](https://docs.google.com/document/d/1Aby-U3-MPKE51s4aYd41L4Co2S97eM6LPtyzjyR_ecI/edit)
* **Resource Allocation**
	* communication:
		* slack: [#allocator](https://mesos.slack.com/messages/allocator/)
		* [slack archive](http://mesos.slackarchive.io/allocator/)
	* members:
		* Alex Rukletsov
		* Benjamin Hindman
		* Benjamin Mahler
		* Guangya Liu
		* Jie Yu
		* Joris Van Remoortere
		* Joseph Wu
		* Klaus Ma
		* Vinod Kone
	* resources:
		* [Optimistically Offering Unallocated Reserved Resources](https://docs.google.com/document/d/1RGrkDNnfyjpOQVxk_kUFJCalNMqnFlzaMRww7j7HSKU/edit?usp=sharing)
* **Simulation**
	* communication:
		* irc: mesos-simulation
	* members:
		* Dan Mercer
		* Maged Michael
		* Marco Massenzio
		* Neil Conway
	* resources:
		* [Deterministic Simulation Tools for Mesos Testing and Debugging](https://docs.google.com/document/d/1x4FVpm4DP95w1as78xIPeCR4ke8gZgA3Cu_G624Bung/edit)
		* [meeting notes](https://docs.google.com/document/d/1sSDI_5g2yILSXdrBWtS9AkKf27nQbxPPi9ddAaI8TzU/edit)
* **Strategy**
	* members:
		* Adam B
		* Ben Hindman
		* Ben Mahler
		* Dan Mercer
		* Niklas Nielsen
		* Vinod Kone
	* resources:
		* [meeting notes](https://docs.google.com/document/d/11LLDKQBZObduNUG7_bayBIU6VMKq2E8CvmaI0tt1U4M/edit)
* **Website**
	* communication:
		* mailing list subject prefix: WEBSITE
	* members:
		* Abhishek Dasgupta
		* Freddy Ayuso-Henson
		* Haosdent
		* Jay JN Guo,
		* Jeff Schroeder
		* Neil Conway,
		* Radoslaw Gruchalski
		* Ryuichi Okumura
		* Timothy Anderegg
		* Tomek Janiszewski
		* Vinod Kone
		* Zhong TIAN
		* Zhou Z Xing
