---
layout: post
title: 2014 Mesos Community Survey Results
permalink: /blog/mesos-community-survey-2014-results/
published: true
post_author:
  display_name: Dave Lester
  twitter: davelester
tags: Community, Survey
---

Below are results of a community survey I led in May to get the pulse of the Apache Mesos community and improve our understanding of how others are using the software. We received a total of 55 responses.

While I think the responses below speak for themselves, I wanted to highlight a few things:

* A majority of responses came from adopters who have been using Mesos for more than 2 months.
* Mesos had a [Net Promoter Score](http://www.netpromoter.com/why-net-promoter/know/) of 41.5.
* Documentation was the #1 community request for improving Mesos, followed by integrated Docker support. Unedited responses have been published as a [GitHub gist](https://gist.github.com/davelester/b40e3b5d0347540abf36).
* 36% of adopters are running Mesos in a cluster of 6-20 machines.
* Almost half of Mesos adopters are running in private data centers. A majority of adopters running in the public cloud use AWS.
* Hadoop, Marathon, and Chronos were the most-popular frameworks that are running in production.

This is the first time we've run a community survey like this; feedback is welcome on how we may improve it when we run it again.

### How long have you been using Mesos?
![How long have you been using Mesos](/assets/img/blog/communitysurvey_2014_howlong.png)

### How many machines are you running in your Mesos cluster?
![How many machines are you running in your Mesos cluster](/assets/img/blog/communitysurvey_2014_howmanymachines.png)

### Frameworks: Are you using [Aurora](http://aurora.incubator.apache.org) on Mesos?
![Are you using Aurora on Mesos](/assets/img/blog/communitysurvey_2014_framework_aurora.png)

### Frameworks: Are you using [Cassandra](https://github.com/mesosphere/cassandra-mesos) on Mesos?
![Are you using Cassandra on Mesos](/assets/img/blog/communitysurvey_2014_framework_cassandra.png)

### Frameworks: Are you using [Chronos](https://github.com/airbnb/chronos) on Mesos?
![Are you using Chronos on Mesos](/assets/img/blog/communitysurvey_2014_framework_chronos.png)

### Frameworks: Are you using [Hadoop](https://github.com/mesos/hadoop) on Mesos?
![Are you using Hadoop on Mesos](/assets/img/blog/communitysurvey_2014_framework_hadoop.png)

### Frameworks: Are you using [Jenkins](https://github.com/jenkinsci/mesos-plugin) on Mesos?
![Are you using Jenkins on Mesos](/assets/img/blog/communitysurvey_2014_framework_jenkins.png)

### Frameworks: Are you using [JobServer](http://www.grandlogic.com/content/html_docs/products.shtml#jobserverprod) on Mesos?
![Are you using JobServer on Mesos](/assets/img/blog/communitysurvey_2014_framework_jobserver.png)

### Frameworks: Are you using [Marathon](https://github.com/mesosphere/marathon) on Mesos?
![Are you using Marathon on Mesos](/assets/img/blog/communitysurvey_2014_framework_marathon.png)

### Frameworks: Are you using [Spark](http://spark.apache.org/) on Mesos?
![Are you using Spark on Mesos](/assets/img/blog/communitysurvey_2014_framework_spark.png)

### Frameworks: Are you using [Storm](https://github.com/mesosphere/storm-mesos) on Mesos?
![Are you using Storm on Mesos](/assets/img/blog/communitysurvey_2014_framework_storm.png)

### Frameworks: Are you using a custom framework on Mesos?
![Are you using a custom framework on Mesos](/assets/img/blog/communitysurvey_2014_framework_custom.png)

### Where do you run Mesos?
![Where do you run Mesos](/assets/img/blog/communitysurvey_2014_wheredoyourun.png)

### How likely are you to recommend Mesos to your friends and colleagues?
![How likely are you to recommend Mesos to your friends and colleagues?](/assets/img/blog/communitysurvey_2014_nps.png)

### Are you interested in contributing to Mesos in any of the following ways?
![Are you interested in contributing to Mesos in any of the following way](/assets/img/blog/communitysurvey_2014_contributions.png)

### Is your company listed on our [#PoweredByMesos](http://mesos.apache.org/documentation/latest/powered-by-mesos/) page? If not, can we list you?
![Is your company listed on our #PoweredByMesos page?](/assets/img/blog/communitysurvey_2014_poweredby.png)

(34 responses for "No, but please refrain from adding us at this time", 8 responses for "No, please add us", and 15 responses for "Yes, we're on the list!")

### Number of daily responses
![Number of daily response](/assets/img/blog/communitysurvey_2014_responses.png)

### What features do you think are missing from Mesos?
The unedited responses to this question have been published as a [GitHub gist](https://gist.github.com/davelester/b40e3b5d0347540abf36).