---
title: Apache Mesos | Community
breadcrumb: Community
layout: community_section
---

<h1>About the Community</h1>

<p>Apache Mesos is an open source community that's organized by its members, including you! Whether you're running or writing a framework, or hacking the core, there are opportunities for you to get in touch and ask questions, get involved locally, and contribute back. If you're interested in who is using Mesos, check out our growing <a href="/documentation/latest/powered-by-mesos/">Powered By Mesos</a> list.</p>

<div class="row-fluid">
  <div class="col-md-6">
    <h2>Get Involved</h2>
    <h3 name="meetup">Local User Groups</h3>
    <p><a href="user-groups/">Mesos User Groups</a> organize local Mesos events in different cities. Join one in your city, or learn how to start your own.</p>

    <h3>Contribute</h3>
    <h3 name="reportbugs">Report or track a bug</h3>
    <p>New bugs can be reported on our <a href="http://issues.apache.org/jira/browse/MESOS">issue tracker</a>. In order to create a new issue, you'll need to signup for an account. See the guidelines <a href="/documentation/latest/reporting-a-bug/">here</a>.</p>

    <h3 name="contribute">Contribute a core patch</h3>
    <p>Follow our <a href="/documentation/latest/submitting-a-patch">contribution guidelines</a> when submitting a patch. We love patches. :)</p>

    <h3 name="workinggroups">Working Groups</h3>

    <p>
    As the community has scaled, we work on larger and more involved features and components in separate interest or <i>working</i> groups.
    We keep track of these working groups <a href="https://cwiki.apache.org/confluence/display/MESOS/Apache+Mesos+Working+Groups">here</a>.
    In this list, you will be able to get in touch with the stakeholders, contributors and committers interested in certain features for Mesos and join in on the design meetings.
    </p>

  </div>
  <div class="col-md-6">
    <h2>Get In Touch</h2>
    <h3 name="mailinglists">Mailing Lists</h3>
    <p><b>Users</b>: <a href="mailto:user-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:user-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="https://lists.apache.org/list.html?user@mesos.apache.org">Archives</a><br />
    <b>Developers</b>: <a href="mailto:dev-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:dev-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="https://lists.apache.org/list.html?dev@mesos.apache.org">Archives</a><br />
    <b>JIRA Updates</b>: <a href="mailto:issues-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:issues-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="https://lists.apache.org/list.html?issues@mesos.apache.org">Archives</a><br />
    <b>Reviews</b>: <a href="mailto:reviews-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:reviews-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="https://lists.apache.org/list.html?reviews@mesos.apache.org">Archives</a><br />
    <b>Jenkins Builds</b>: <a href="mailto:builds-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:builds-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="https://lists.apache.org/list.html?builds@mesos.apache.org">Archives</a><br />
    <b>Commits</b>: <a href="mailto:commits-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:commits-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="https://lists.apache.org/list.html?commits@mesos.apache.org">Archives</a><br />
    <b>Modules</b>: <a href="mailto:modules-subscribe@mesos.apache.org?subject=Subscribe&body=Subscribe">Subscribe</a> | <a href="mailto:modules-unsubscribe@mesos.apache.org?subject=Unsubscribe&body=Unsubscribe">Unsubscribe</a> | <a href="http://www.mail-archive.com/modules@mesos.apache.org/">Archives</a><br /></p>

    <h3 name="slack">Slack</h3>
    <p>Developers and users chat at <a href="https://mesos.slack.com">mesos.slack.com</a>.</p>

    <p>To request an invite for slack please click <a href="https://mesos-slackin.herokuapp.com">here</a>.</p>

    <p>All slack communication is publicly archived <a href="http://mesos.slackarchive.io">here</a>.</p>

    <h3 name="ircchannel">IRC </h3>
    <p> If you want to connect to our slack team through an IRC client please click <a href="https://my.slack.com/gateways">here</a> after signing up.</p>

    <p>The slack channel is currently also mirrored at #mesos channel on irc.freenode.net.</p>

    <p>If you are new to IRC, you can use a <a href="http://webchat.freenode.net/?channels=#mesos">web-based client</a>.</p>

    <h3 name="twitter">Follow us on Twitter</h3>
    <a class="twitter-timeline" href="https://twitter.com/ApacheMesos" data-widget-id="426586952293289985">Tweets by @ApacheMesos</a>
    <script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>

  </div>
  <div class="col-md-12">
    <h3 name="calendar">Events Calendar</h3>
    <iframe src="https://calendar.google.com/calendar/embed?src=2hecvndc0mnaqlir34cqnfvtak%40group.calendar.google.com" style="border: 0" width="100%" height="600" frameborder="0" scrolling="no"></iframe>
  </div>
</div>
