---
name: Bug report
about: Create a report to help us improve Station
title: '[BUG] '
labels: 'bug'
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behavior:
1. Run command `stn ...`
2. Configure MCP server '...'
3. Execute agent '...'
4. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Actual behavior**
What actually happened instead.

**Screenshots/Logs**
If applicable, add screenshots or paste relevant log output:

```
Paste log output here
```

**Environment (please complete the following information):**
 - OS: [e.g. Ubuntu 22.04, macOS 14.0, Windows 11]
 - Go version: [e.g. 1.21.5]
 - Station version: [e.g. v0.1.0 or commit hash]
 - Installation method: [e.g. go install, binary download, one-liner script]

**Station Configuration**
- Mode: [Local/Remote]
- Database: [SQLite path]
- Any relevant config from ~/.config/station/config.yaml

**MCP Server Details** (if applicable)
- MCP server involved: [e.g. filesystem, aws-knowledge]
- Configuration method: [GitHub discovery, manual]
- Environment variables used: [list without values]

**Agent Configuration** (if applicable)
- Agent name/ID:
- Tools assigned:
- Environment:
- Max steps:

**Additional context**
Add any other context about the problem here. This could include:
- Was this working before?
- What changed recently?
- Have you tried any workarounds?
- Related issues or discussions