# Pull Request

## Description

Brief description of what this PR does and why it's needed.

## Type of Change

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Documentation update
- [ ] Performance improvement
- [ ] Code refactoring (no functional changes)
- [ ] Test improvements

## Related Issues

Closes #(issue number)
Relates to #(issue number)

## Changes Made

### Added
- List new features or functionality

### Changed
- List changes to existing functionality

### Fixed
- List bug fixes

### Removed
- List removed features or functionality

## Testing

- [ ] Tests pass locally (`make test`)
- [ ] Tests added for new functionality
- [ ] Integration tests added if applicable
- [ ] Manual testing completed

### Test Coverage
- Current coverage: X%
- Coverage change: +/-X%

### Manual Testing Steps
1. Step 1
2. Step 2
3. Step 3

## AI Assistance (if applicable)

- [ ] This PR was created with AI assistance (Claude, GPT, Copilot, etc.)
- AI tools used: [e.g., Claude 3.5 Sonnet, GitHub Copilot]
- Human review and validation completed: [Describe your review process]

## Documentation

- [ ] README updated (if needed)
- [ ] Code comments added for complex logic
- [ ] CONTRIBUTING.md updated (if needed)
- [ ] Other documentation updated: [specify]

## Configuration Changes

- [ ] No configuration changes
- [ ] New environment variables added: [list]
- [ ] Database schema changes: [describe]
- [ ] Config file format changes: [describe]

## Deployment Considerations

- [ ] No deployment impact
- [ ] Database migration required
- [ ] Environment variable updates needed
- [ ] Breaking changes for existing users: [explain migration path]

## Performance Impact

- [ ] No performance impact
- [ ] Performance improvement: [quantify if possible]
- [ ] Potential performance impact: [explain and justify]

## Security Considerations

- [ ] No security impact
- [ ] Security improvement
- [ ] New security considerations: [explain]
- [ ] Potential security impact: [explain mitigation]

## Checklist

- [ ] My code follows the project's style guidelines
- [ ] I have performed a self-review of my own code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published

## Screenshots (if applicable)

Add screenshots to help explain your changes.

## Additional Notes

Any additional information, context, or notes for reviewers.