// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: agent_runs.sql

package queries

import (
	"context"
	"database/sql"
)

const createAgentRun = `-- name: CreateAgentRun :one
INSERT INTO agent_runs (agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
RETURNING id, agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, started_at, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error
`

type CreateAgentRunParams struct {
	AgentID         int64           `json:"agent_id"`
	UserID          int64           `json:"user_id"`
	Task            string          `json:"task"`
	FinalResponse   string          `json:"final_response"`
	StepsTaken      int64           `json:"steps_taken"`
	ToolCalls       sql.NullString  `json:"tool_calls"`
	ExecutionSteps  sql.NullString  `json:"execution_steps"`
	Status          string          `json:"status"`
	CompletedAt     sql.NullTime    `json:"completed_at"`
	InputTokens     sql.NullInt64   `json:"input_tokens"`
	OutputTokens    sql.NullInt64   `json:"output_tokens"`
	TotalTokens     sql.NullInt64   `json:"total_tokens"`
	DurationSeconds sql.NullFloat64 `json:"duration_seconds"`
	ModelName       sql.NullString  `json:"model_name"`
	ToolsUsed       sql.NullInt64   `json:"tools_used"`
	DebugLogs       sql.NullString  `json:"debug_logs"`
	Error           sql.NullString  `json:"error"`
}

func (q *Queries) CreateAgentRun(ctx context.Context, arg CreateAgentRunParams) (AgentRun, error) {
	row := q.db.QueryRowContext(ctx, createAgentRun,
		arg.AgentID,
		arg.UserID,
		arg.Task,
		arg.FinalResponse,
		arg.StepsTaken,
		arg.ToolCalls,
		arg.ExecutionSteps,
		arg.Status,
		arg.CompletedAt,
		arg.InputTokens,
		arg.OutputTokens,
		arg.TotalTokens,
		arg.DurationSeconds,
		arg.ModelName,
		arg.ToolsUsed,
		arg.DebugLogs,
		arg.Error,
	)
	var i AgentRun
	err := row.Scan(
		&i.ID,
		&i.AgentID,
		&i.UserID,
		&i.Task,
		&i.FinalResponse,
		&i.StepsTaken,
		&i.ToolCalls,
		&i.ExecutionSteps,
		&i.Status,
		&i.StartedAt,
		&i.CompletedAt,
		&i.InputTokens,
		&i.OutputTokens,
		&i.TotalTokens,
		&i.DurationSeconds,
		&i.ModelName,
		&i.ToolsUsed,
		&i.DebugLogs,
		&i.Error,
	)
	return i, err
}

const createAgentRunBasic = `-- name: CreateAgentRunBasic :one
INSERT INTO agent_runs (agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, completed_at)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
RETURNING id, agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, started_at, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error
`

type CreateAgentRunBasicParams struct {
	AgentID        int64          `json:"agent_id"`
	UserID         int64          `json:"user_id"`
	Task           string         `json:"task"`
	FinalResponse  string         `json:"final_response"`
	StepsTaken     int64          `json:"steps_taken"`
	ToolCalls      sql.NullString `json:"tool_calls"`
	ExecutionSteps sql.NullString `json:"execution_steps"`
	Status         string         `json:"status"`
	CompletedAt    sql.NullTime   `json:"completed_at"`
}

func (q *Queries) CreateAgentRunBasic(ctx context.Context, arg CreateAgentRunBasicParams) (AgentRun, error) {
	row := q.db.QueryRowContext(ctx, createAgentRunBasic,
		arg.AgentID,
		arg.UserID,
		arg.Task,
		arg.FinalResponse,
		arg.StepsTaken,
		arg.ToolCalls,
		arg.ExecutionSteps,
		arg.Status,
		arg.CompletedAt,
	)
	var i AgentRun
	err := row.Scan(
		&i.ID,
		&i.AgentID,
		&i.UserID,
		&i.Task,
		&i.FinalResponse,
		&i.StepsTaken,
		&i.ToolCalls,
		&i.ExecutionSteps,
		&i.Status,
		&i.StartedAt,
		&i.CompletedAt,
		&i.InputTokens,
		&i.OutputTokens,
		&i.TotalTokens,
		&i.DurationSeconds,
		&i.ModelName,
		&i.ToolsUsed,
		&i.DebugLogs,
		&i.Error,
	)
	return i, err
}

const getAgentRun = `-- name: GetAgentRun :one
SELECT id, agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, started_at, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error FROM agent_runs WHERE id = ?
`

func (q *Queries) GetAgentRun(ctx context.Context, id int64) (AgentRun, error) {
	row := q.db.QueryRowContext(ctx, getAgentRun, id)
	var i AgentRun
	err := row.Scan(
		&i.ID,
		&i.AgentID,
		&i.UserID,
		&i.Task,
		&i.FinalResponse,
		&i.StepsTaken,
		&i.ToolCalls,
		&i.ExecutionSteps,
		&i.Status,
		&i.StartedAt,
		&i.CompletedAt,
		&i.InputTokens,
		&i.OutputTokens,
		&i.TotalTokens,
		&i.DurationSeconds,
		&i.ModelName,
		&i.ToolsUsed,
		&i.DebugLogs,
		&i.Error,
	)
	return i, err
}

const getAgentRunWithDetails = `-- name: GetAgentRunWithDetails :one
SELECT ar.id, ar.agent_id, ar.user_id, ar.task, ar.final_response, ar.steps_taken,
       ar.tool_calls, ar.execution_steps, ar.status, ar.started_at, ar.completed_at,
       ar.input_tokens, ar.output_tokens, ar.total_tokens, ar.duration_seconds, ar.model_name, ar.tools_used, ar.debug_logs, ar.error,
       a.name as agent_name, u.username
FROM agent_runs ar
JOIN agents a ON ar.agent_id = a.id
JOIN users u ON ar.user_id = u.id
WHERE ar.id = ?
`

type GetAgentRunWithDetailsRow struct {
	ID              int64           `json:"id"`
	AgentID         int64           `json:"agent_id"`
	UserID          int64           `json:"user_id"`
	Task            string          `json:"task"`
	FinalResponse   string          `json:"final_response"`
	StepsTaken      int64           `json:"steps_taken"`
	ToolCalls       sql.NullString  `json:"tool_calls"`
	ExecutionSteps  sql.NullString  `json:"execution_steps"`
	Status          string          `json:"status"`
	StartedAt       sql.NullTime    `json:"started_at"`
	CompletedAt     sql.NullTime    `json:"completed_at"`
	InputTokens     sql.NullInt64   `json:"input_tokens"`
	OutputTokens    sql.NullInt64   `json:"output_tokens"`
	TotalTokens     sql.NullInt64   `json:"total_tokens"`
	DurationSeconds sql.NullFloat64 `json:"duration_seconds"`
	ModelName       sql.NullString  `json:"model_name"`
	ToolsUsed       sql.NullInt64   `json:"tools_used"`
	DebugLogs       sql.NullString  `json:"debug_logs"`
	Error           sql.NullString  `json:"error"`
	AgentName       string          `json:"agent_name"`
	Username        string          `json:"username"`
}

func (q *Queries) GetAgentRunWithDetails(ctx context.Context, id int64) (GetAgentRunWithDetailsRow, error) {
	row := q.db.QueryRowContext(ctx, getAgentRunWithDetails, id)
	var i GetAgentRunWithDetailsRow
	err := row.Scan(
		&i.ID,
		&i.AgentID,
		&i.UserID,
		&i.Task,
		&i.FinalResponse,
		&i.StepsTaken,
		&i.ToolCalls,
		&i.ExecutionSteps,
		&i.Status,
		&i.StartedAt,
		&i.CompletedAt,
		&i.InputTokens,
		&i.OutputTokens,
		&i.TotalTokens,
		&i.DurationSeconds,
		&i.ModelName,
		&i.ToolsUsed,
		&i.DebugLogs,
		&i.Error,
		&i.AgentName,
		&i.Username,
	)
	return i, err
}

const listAgentRuns = `-- name: ListAgentRuns :many
SELECT id, agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, started_at, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error FROM agent_runs ORDER BY started_at DESC
`

func (q *Queries) ListAgentRuns(ctx context.Context) ([]AgentRun, error) {
	rows, err := q.db.QueryContext(ctx, listAgentRuns)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []AgentRun
	for rows.Next() {
		var i AgentRun
		if err := rows.Scan(
			&i.ID,
			&i.AgentID,
			&i.UserID,
			&i.Task,
			&i.FinalResponse,
			&i.StepsTaken,
			&i.ToolCalls,
			&i.ExecutionSteps,
			&i.Status,
			&i.StartedAt,
			&i.CompletedAt,
			&i.InputTokens,
			&i.OutputTokens,
			&i.TotalTokens,
			&i.DurationSeconds,
			&i.ModelName,
			&i.ToolsUsed,
			&i.DebugLogs,
			&i.Error,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listAgentRunsByAgent = `-- name: ListAgentRunsByAgent :many
SELECT id, agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, started_at, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error FROM agent_runs WHERE agent_id = ? ORDER BY started_at DESC
`

func (q *Queries) ListAgentRunsByAgent(ctx context.Context, agentID int64) ([]AgentRun, error) {
	rows, err := q.db.QueryContext(ctx, listAgentRunsByAgent, agentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []AgentRun
	for rows.Next() {
		var i AgentRun
		if err := rows.Scan(
			&i.ID,
			&i.AgentID,
			&i.UserID,
			&i.Task,
			&i.FinalResponse,
			&i.StepsTaken,
			&i.ToolCalls,
			&i.ExecutionSteps,
			&i.Status,
			&i.StartedAt,
			&i.CompletedAt,
			&i.InputTokens,
			&i.OutputTokens,
			&i.TotalTokens,
			&i.DurationSeconds,
			&i.ModelName,
			&i.ToolsUsed,
			&i.DebugLogs,
			&i.Error,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listAgentRunsByUser = `-- name: ListAgentRunsByUser :many
SELECT id, agent_id, user_id, task, final_response, steps_taken, tool_calls, execution_steps, status, started_at, completed_at, input_tokens, output_tokens, total_tokens, duration_seconds, model_name, tools_used, debug_logs, error FROM agent_runs WHERE user_id = ? ORDER BY started_at DESC
`

func (q *Queries) ListAgentRunsByUser(ctx context.Context, userID int64) ([]AgentRun, error) {
	rows, err := q.db.QueryContext(ctx, listAgentRunsByUser, userID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []AgentRun
	for rows.Next() {
		var i AgentRun
		if err := rows.Scan(
			&i.ID,
			&i.AgentID,
			&i.UserID,
			&i.Task,
			&i.FinalResponse,
			&i.StepsTaken,
			&i.ToolCalls,
			&i.ExecutionSteps,
			&i.Status,
			&i.StartedAt,
			&i.CompletedAt,
			&i.InputTokens,
			&i.OutputTokens,
			&i.TotalTokens,
			&i.DurationSeconds,
			&i.ModelName,
			&i.ToolsUsed,
			&i.DebugLogs,
			&i.Error,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listRecentAgentRuns = `-- name: ListRecentAgentRuns :many
SELECT ar.id, ar.agent_id, ar.user_id, ar.task, ar.final_response, ar.steps_taken, ar.tool_calls, ar.execution_steps, ar.status, ar.started_at, ar.completed_at, ar.input_tokens, ar.output_tokens, ar.total_tokens, ar.duration_seconds, ar.model_name, ar.tools_used, ar.debug_logs, ar.error, a.name as agent_name, u.username
FROM agent_runs ar
JOIN agents a ON ar.agent_id = a.id
JOIN users u ON ar.user_id = u.id
ORDER BY ar.started_at DESC
LIMIT ?
`

type ListRecentAgentRunsRow struct {
	ID              int64           `json:"id"`
	AgentID         int64           `json:"agent_id"`
	UserID          int64           `json:"user_id"`
	Task            string          `json:"task"`
	FinalResponse   string          `json:"final_response"`
	StepsTaken      int64           `json:"steps_taken"`
	ToolCalls       sql.NullString  `json:"tool_calls"`
	ExecutionSteps  sql.NullString  `json:"execution_steps"`
	Status          string          `json:"status"`
	StartedAt       sql.NullTime    `json:"started_at"`
	CompletedAt     sql.NullTime    `json:"completed_at"`
	InputTokens     sql.NullInt64   `json:"input_tokens"`
	OutputTokens    sql.NullInt64   `json:"output_tokens"`
	TotalTokens     sql.NullInt64   `json:"total_tokens"`
	DurationSeconds sql.NullFloat64 `json:"duration_seconds"`
	ModelName       sql.NullString  `json:"model_name"`
	ToolsUsed       sql.NullInt64   `json:"tools_used"`
	DebugLogs       sql.NullString  `json:"debug_logs"`
	Error           sql.NullString  `json:"error"`
	AgentName       string          `json:"agent_name"`
	Username        string          `json:"username"`
}

func (q *Queries) ListRecentAgentRuns(ctx context.Context, limit int64) ([]ListRecentAgentRunsRow, error) {
	rows, err := q.db.QueryContext(ctx, listRecentAgentRuns, limit)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListRecentAgentRunsRow
	for rows.Next() {
		var i ListRecentAgentRunsRow
		if err := rows.Scan(
			&i.ID,
			&i.AgentID,
			&i.UserID,
			&i.Task,
			&i.FinalResponse,
			&i.StepsTaken,
			&i.ToolCalls,
			&i.ExecutionSteps,
			&i.Status,
			&i.StartedAt,
			&i.CompletedAt,
			&i.InputTokens,
			&i.OutputTokens,
			&i.TotalTokens,
			&i.DurationSeconds,
			&i.ModelName,
			&i.ToolsUsed,
			&i.DebugLogs,
			&i.Error,
			&i.AgentName,
			&i.Username,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateAgentRunCompletion = `-- name: UpdateAgentRunCompletion :exec
UPDATE agent_runs
SET final_response = ?, steps_taken = ?, tool_calls = ?, execution_steps = ?, status = ?, completed_at = ?, input_tokens = ?, output_tokens = ?, total_tokens = ?, duration_seconds = ?, model_name = ?, tools_used = ?, error = ?
WHERE id = ?
`

type UpdateAgentRunCompletionParams struct {
	FinalResponse   string          `json:"final_response"`
	StepsTaken      int64           `json:"steps_taken"`
	ToolCalls       sql.NullString  `json:"tool_calls"`
	ExecutionSteps  sql.NullString  `json:"execution_steps"`
	Status          string          `json:"status"`
	CompletedAt     sql.NullTime    `json:"completed_at"`
	InputTokens     sql.NullInt64   `json:"input_tokens"`
	OutputTokens    sql.NullInt64   `json:"output_tokens"`
	TotalTokens     sql.NullInt64   `json:"total_tokens"`
	DurationSeconds sql.NullFloat64 `json:"duration_seconds"`
	ModelName       sql.NullString  `json:"model_name"`
	ToolsUsed       sql.NullInt64   `json:"tools_used"`
	Error           sql.NullString  `json:"error"`
	ID              int64           `json:"id"`
}

func (q *Queries) UpdateAgentRunCompletion(ctx context.Context, arg UpdateAgentRunCompletionParams) error {
	_, err := q.db.ExecContext(ctx, updateAgentRunCompletion,
		arg.FinalResponse,
		arg.StepsTaken,
		arg.ToolCalls,
		arg.ExecutionSteps,
		arg.Status,
		arg.CompletedAt,
		arg.InputTokens,
		arg.OutputTokens,
		arg.TotalTokens,
		arg.DurationSeconds,
		arg.ModelName,
		arg.ToolsUsed,
		arg.Error,
		arg.ID,
	)
	return err
}

const updateAgentRunDebugLogs = `-- name: UpdateAgentRunDebugLogs :exec
UPDATE agent_runs SET debug_logs = ? WHERE id = ?
`

type UpdateAgentRunDebugLogsParams struct {
	DebugLogs sql.NullString `json:"debug_logs"`
	ID        int64          `json:"id"`
}

func (q *Queries) UpdateAgentRunDebugLogs(ctx context.Context, arg UpdateAgentRunDebugLogsParams) error {
	_, err := q.db.ExecContext(ctx, updateAgentRunDebugLogs, arg.DebugLogs, arg.ID)
	return err
}

const updateAgentRunStatus = `-- name: UpdateAgentRunStatus :exec
UPDATE agent_runs SET status = ? WHERE id = ?
`

type UpdateAgentRunStatusParams struct {
	Status string `json:"status"`
	ID     int64  `json:"id"`
}

func (q *Queries) UpdateAgentRunStatus(ctx context.Context, arg UpdateAgentRunStatusParams) error {
	_, err := q.db.ExecContext(ctx, updateAgentRunStatus, arg.Status, arg.ID)
	return err
}
