// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: agent_tools.sql

package queries

import (
	"context"
	"database/sql"
)

const addAgentTool = `-- name: AddAgentTool :one
INSERT INTO agent_tools (agent_id, tool_id)
VALUES (?, ?)
RETURNING id, agent_id, tool_id, created_at
`

type AddAgentToolParams struct {
	AgentID int64 `json:"agent_id"`
	ToolID  int64 `json:"tool_id"`
}

func (q *Queries) AddAgentTool(ctx context.Context, arg AddAgentToolParams) (AgentTool, error) {
	row := q.db.QueryRowContext(ctx, addAgentTool, arg.AgentID, arg.ToolID)
	var i AgentTool
	err := row.Scan(
		&i.ID,
		&i.AgentID,
		&i.ToolID,
		&i.CreatedAt,
	)
	return i, err
}

const clearAgentTools = `-- name: ClearAgentTools :exec
DELETE FROM agent_tools WHERE agent_id = ?
`

func (q *Queries) ClearAgentTools(ctx context.Context, agentID int64) error {
	_, err := q.db.ExecContext(ctx, clearAgentTools, agentID)
	return err
}

const listAgentTools = `-- name: ListAgentTools :many
SELECT at.id, at.agent_id, at.tool_id, at.created_at, 
       t.name as tool_name, t.description as tool_description, t.input_schema as tool_schema, 
       s.name as server_name, s.environment_id, e.name as environment_name
FROM agent_tools at
JOIN mcp_tools t ON at.tool_id = t.id 
JOIN mcp_servers s ON t.mcp_server_id = s.id
JOIN agents a ON at.agent_id = a.id
JOIN environments e ON s.environment_id = e.id
WHERE at.agent_id = ? AND s.environment_id = a.environment_id
ORDER BY s.name, t.name
`

type ListAgentToolsRow struct {
	ID              int64          `json:"id"`
	AgentID         int64          `json:"agent_id"`
	ToolID          int64          `json:"tool_id"`
	CreatedAt       sql.NullTime   `json:"created_at"`
	ToolName        string         `json:"tool_name"`
	ToolDescription sql.NullString `json:"tool_description"`
	ToolSchema      sql.NullString `json:"tool_schema"`
	ServerName      string         `json:"server_name"`
	EnvironmentID   int64          `json:"environment_id"`
	EnvironmentName string         `json:"environment_name"`
}

// Ensure tools belong to the agent's environment
func (q *Queries) ListAgentTools(ctx context.Context, agentID int64) ([]ListAgentToolsRow, error) {
	rows, err := q.db.QueryContext(ctx, listAgentTools, agentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListAgentToolsRow
	for rows.Next() {
		var i ListAgentToolsRow
		if err := rows.Scan(
			&i.ID,
			&i.AgentID,
			&i.ToolID,
			&i.CreatedAt,
			&i.ToolName,
			&i.ToolDescription,
			&i.ToolSchema,
			&i.ServerName,
			&i.EnvironmentID,
			&i.EnvironmentName,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listAvailableToolsForAgent = `-- name: ListAvailableToolsForAgent :many
SELECT t.id, t.name as tool_name, t.description as tool_description, t.input_schema as tool_schema,
       s.name as server_name
FROM mcp_tools t
JOIN mcp_servers s ON t.mcp_server_id = s.id
JOIN agents a ON s.environment_id = a.environment_id
WHERE a.id = ? 
AND t.id NOT IN (
    SELECT tool_id FROM agent_tools WHERE agent_id = ?
)
ORDER BY s.name, t.name
`

type ListAvailableToolsForAgentParams struct {
	ID      int64 `json:"id"`
	AgentID int64 `json:"agent_id"`
}

type ListAvailableToolsForAgentRow struct {
	ID              int64          `json:"id"`
	ToolName        string         `json:"tool_name"`
	ToolDescription sql.NullString `json:"tool_description"`
	ToolSchema      sql.NullString `json:"tool_schema"`
	ServerName      string         `json:"server_name"`
}

// List all tools available in the agent's environment that aren't already assigned
func (q *Queries) ListAvailableToolsForAgent(ctx context.Context, arg ListAvailableToolsForAgentParams) ([]ListAvailableToolsForAgentRow, error) {
	rows, err := q.db.QueryContext(ctx, listAvailableToolsForAgent, arg.ID, arg.AgentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListAvailableToolsForAgentRow
	for rows.Next() {
		var i ListAvailableToolsForAgentRow
		if err := rows.Scan(
			&i.ID,
			&i.ToolName,
			&i.ToolDescription,
			&i.ToolSchema,
			&i.ServerName,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const removeAgentTool = `-- name: RemoveAgentTool :exec
DELETE FROM agent_tools WHERE agent_id = ? AND tool_id = ?
`

type RemoveAgentToolParams struct {
	AgentID int64 `json:"agent_id"`
	ToolID  int64 `json:"tool_id"`
}

func (q *Queries) RemoveAgentTool(ctx context.Context, arg RemoveAgentToolParams) error {
	_, err := q.db.ExecContext(ctx, removeAgentTool, arg.AgentID, arg.ToolID)
	return err
}
