// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: agents.sql

package queries

import (
	"context"
	"database/sql"
)

const createAgent = `-- name: CreateAgent :one
INSERT INTO agents (name, description, prompt, max_steps, environment_id, created_by, input_schema, cron_schedule, is_scheduled, schedule_enabled, output_schema, output_schema_preset, app, app_subtype)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
RETURNING id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at
`

type CreateAgentParams struct {
	Name               string         `json:"name"`
	Description        string         `json:"description"`
	Prompt             string         `json:"prompt"`
	MaxSteps           int64          `json:"max_steps"`
	EnvironmentID      int64          `json:"environment_id"`
	CreatedBy          int64          `json:"created_by"`
	InputSchema        sql.NullString `json:"input_schema"`
	CronSchedule       sql.NullString `json:"cron_schedule"`
	IsScheduled        sql.NullBool   `json:"is_scheduled"`
	ScheduleEnabled    sql.NullBool   `json:"schedule_enabled"`
	OutputSchema       sql.NullString `json:"output_schema"`
	OutputSchemaPreset sql.NullString `json:"output_schema_preset"`
	App                sql.NullString `json:"app"`
	AppSubtype         sql.NullString `json:"app_subtype"`
}

func (q *Queries) CreateAgent(ctx context.Context, arg CreateAgentParams) (Agent, error) {
	row := q.db.QueryRowContext(ctx, createAgent,
		arg.Name,
		arg.Description,
		arg.Prompt,
		arg.MaxSteps,
		arg.EnvironmentID,
		arg.CreatedBy,
		arg.InputSchema,
		arg.CronSchedule,
		arg.IsScheduled,
		arg.ScheduleEnabled,
		arg.OutputSchema,
		arg.OutputSchemaPreset,
		arg.App,
		arg.AppSubtype,
	)
	var i Agent
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.Prompt,
		&i.MaxSteps,
		&i.EnvironmentID,
		&i.CreatedBy,
		&i.ModelID,
		&i.InputSchema,
		&i.OutputSchema,
		&i.OutputSchemaPreset,
		&i.App,
		&i.AppSubtype,
		&i.CronSchedule,
		&i.IsScheduled,
		&i.LastScheduledRun,
		&i.NextScheduledRun,
		&i.ScheduleEnabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteAgent = `-- name: DeleteAgent :exec
DELETE FROM agents WHERE id = ?
`

func (q *Queries) DeleteAgent(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteAgent, id)
	return err
}

const getAgent = `-- name: GetAgent :one
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE id = ?
`

func (q *Queries) GetAgent(ctx context.Context, id int64) (Agent, error) {
	row := q.db.QueryRowContext(ctx, getAgent, id)
	var i Agent
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.Prompt,
		&i.MaxSteps,
		&i.EnvironmentID,
		&i.CreatedBy,
		&i.ModelID,
		&i.InputSchema,
		&i.OutputSchema,
		&i.OutputSchemaPreset,
		&i.App,
		&i.AppSubtype,
		&i.CronSchedule,
		&i.IsScheduled,
		&i.LastScheduledRun,
		&i.NextScheduledRun,
		&i.ScheduleEnabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getAgentByName = `-- name: GetAgentByName :one
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE name = ?
`

func (q *Queries) GetAgentByName(ctx context.Context, name string) (Agent, error) {
	row := q.db.QueryRowContext(ctx, getAgentByName, name)
	var i Agent
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.Prompt,
		&i.MaxSteps,
		&i.EnvironmentID,
		&i.CreatedBy,
		&i.ModelID,
		&i.InputSchema,
		&i.OutputSchema,
		&i.OutputSchemaPreset,
		&i.App,
		&i.AppSubtype,
		&i.CronSchedule,
		&i.IsScheduled,
		&i.LastScheduledRun,
		&i.NextScheduledRun,
		&i.ScheduleEnabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getAgentByNameAndEnvironment = `-- name: GetAgentByNameAndEnvironment :one
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE name = ? AND environment_id = ?
`

type GetAgentByNameAndEnvironmentParams struct {
	Name          string `json:"name"`
	EnvironmentID int64  `json:"environment_id"`
}

func (q *Queries) GetAgentByNameAndEnvironment(ctx context.Context, arg GetAgentByNameAndEnvironmentParams) (Agent, error) {
	row := q.db.QueryRowContext(ctx, getAgentByNameAndEnvironment, arg.Name, arg.EnvironmentID)
	var i Agent
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.Prompt,
		&i.MaxSteps,
		&i.EnvironmentID,
		&i.CreatedBy,
		&i.ModelID,
		&i.InputSchema,
		&i.OutputSchema,
		&i.OutputSchemaPreset,
		&i.App,
		&i.AppSubtype,
		&i.CronSchedule,
		&i.IsScheduled,
		&i.LastScheduledRun,
		&i.NextScheduledRun,
		&i.ScheduleEnabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getAgentBySchedule = `-- name: GetAgentBySchedule :one
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE id = ? AND is_scheduled = TRUE AND schedule_enabled = TRUE
`

func (q *Queries) GetAgentBySchedule(ctx context.Context, id int64) (Agent, error) {
	row := q.db.QueryRowContext(ctx, getAgentBySchedule, id)
	var i Agent
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.Prompt,
		&i.MaxSteps,
		&i.EnvironmentID,
		&i.CreatedBy,
		&i.ModelID,
		&i.InputSchema,
		&i.OutputSchema,
		&i.OutputSchemaPreset,
		&i.App,
		&i.AppSubtype,
		&i.CronSchedule,
		&i.IsScheduled,
		&i.LastScheduledRun,
		&i.NextScheduledRun,
		&i.ScheduleEnabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getAgentWithTools = `-- name: GetAgentWithTools :many
SELECT 
    a.id as agent_id,
    a.name as agent_name,
    a.description as agent_description,
    a.prompt as agent_prompt,
    a.max_steps as agent_max_steps,
    a.environment_id as agent_environment_id,
    a.created_by as agent_created_by,
    a.is_scheduled as agent_is_scheduled,
    a.schedule_enabled as agent_schedule_enabled,
    a.input_schema as agent_input_schema,
    a.output_schema as agent_output_schema,
    a.output_schema_preset as agent_output_schema_preset,
    a.created_at as agent_created_at,
    a.updated_at as agent_updated_at,
    ms.id as mcp_server_id,
    ms.name as mcp_server_name,
    mt.id as tool_id,
    mt.name as tool_name,
    mt.description as tool_description,
    mt.input_schema as tool_input_schema
FROM agents a
LEFT JOIN agent_tools at ON a.id = at.agent_id
LEFT JOIN mcp_tools mt ON at.tool_id = mt.id
LEFT JOIN mcp_servers ms ON mt.mcp_server_id = ms.id
WHERE a.id = ?
ORDER BY ms.name, mt.name
`

type GetAgentWithToolsRow struct {
	AgentID                 int64          `json:"agent_id"`
	AgentName               string         `json:"agent_name"`
	AgentDescription        string         `json:"agent_description"`
	AgentPrompt             string         `json:"agent_prompt"`
	AgentMaxSteps           int64          `json:"agent_max_steps"`
	AgentEnvironmentID      int64          `json:"agent_environment_id"`
	AgentCreatedBy          int64          `json:"agent_created_by"`
	AgentIsScheduled        sql.NullBool   `json:"agent_is_scheduled"`
	AgentScheduleEnabled    sql.NullBool   `json:"agent_schedule_enabled"`
	AgentInputSchema        sql.NullString `json:"agent_input_schema"`
	AgentOutputSchema       sql.NullString `json:"agent_output_schema"`
	AgentOutputSchemaPreset sql.NullString `json:"agent_output_schema_preset"`
	AgentCreatedAt          sql.NullTime   `json:"agent_created_at"`
	AgentUpdatedAt          sql.NullTime   `json:"agent_updated_at"`
	McpServerID             sql.NullInt64  `json:"mcp_server_id"`
	McpServerName           sql.NullString `json:"mcp_server_name"`
	ToolID                  sql.NullInt64  `json:"tool_id"`
	ToolName                sql.NullString `json:"tool_name"`
	ToolDescription         sql.NullString `json:"tool_description"`
	ToolInputSchema         sql.NullString `json:"tool_input_schema"`
}

func (q *Queries) GetAgentWithTools(ctx context.Context, id int64) ([]GetAgentWithToolsRow, error) {
	rows, err := q.db.QueryContext(ctx, getAgentWithTools, id)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetAgentWithToolsRow
	for rows.Next() {
		var i GetAgentWithToolsRow
		if err := rows.Scan(
			&i.AgentID,
			&i.AgentName,
			&i.AgentDescription,
			&i.AgentPrompt,
			&i.AgentMaxSteps,
			&i.AgentEnvironmentID,
			&i.AgentCreatedBy,
			&i.AgentIsScheduled,
			&i.AgentScheduleEnabled,
			&i.AgentInputSchema,
			&i.AgentOutputSchema,
			&i.AgentOutputSchemaPreset,
			&i.AgentCreatedAt,
			&i.AgentUpdatedAt,
			&i.McpServerID,
			&i.McpServerName,
			&i.ToolID,
			&i.ToolName,
			&i.ToolDescription,
			&i.ToolInputSchema,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listAgents = `-- name: ListAgents :many
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents ORDER BY name
`

func (q *Queries) ListAgents(ctx context.Context) ([]Agent, error) {
	rows, err := q.db.QueryContext(ctx, listAgents)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Agent
	for rows.Next() {
		var i Agent
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Description,
			&i.Prompt,
			&i.MaxSteps,
			&i.EnvironmentID,
			&i.CreatedBy,
			&i.ModelID,
			&i.InputSchema,
			&i.OutputSchema,
			&i.OutputSchemaPreset,
			&i.App,
			&i.AppSubtype,
			&i.CronSchedule,
			&i.IsScheduled,
			&i.LastScheduledRun,
			&i.NextScheduledRun,
			&i.ScheduleEnabled,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listAgentsByEnvironment = `-- name: ListAgentsByEnvironment :many
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE environment_id = ? ORDER BY name
`

func (q *Queries) ListAgentsByEnvironment(ctx context.Context, environmentID int64) ([]Agent, error) {
	rows, err := q.db.QueryContext(ctx, listAgentsByEnvironment, environmentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Agent
	for rows.Next() {
		var i Agent
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Description,
			&i.Prompt,
			&i.MaxSteps,
			&i.EnvironmentID,
			&i.CreatedBy,
			&i.ModelID,
			&i.InputSchema,
			&i.OutputSchema,
			&i.OutputSchemaPreset,
			&i.App,
			&i.AppSubtype,
			&i.CronSchedule,
			&i.IsScheduled,
			&i.LastScheduledRun,
			&i.NextScheduledRun,
			&i.ScheduleEnabled,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listAgentsByUser = `-- name: ListAgentsByUser :many
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE created_by = ? ORDER BY name
`

func (q *Queries) ListAgentsByUser(ctx context.Context, createdBy int64) ([]Agent, error) {
	rows, err := q.db.QueryContext(ctx, listAgentsByUser, createdBy)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Agent
	for rows.Next() {
		var i Agent
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Description,
			&i.Prompt,
			&i.MaxSteps,
			&i.EnvironmentID,
			&i.CreatedBy,
			&i.ModelID,
			&i.InputSchema,
			&i.OutputSchema,
			&i.OutputSchemaPreset,
			&i.App,
			&i.AppSubtype,
			&i.CronSchedule,
			&i.IsScheduled,
			&i.LastScheduledRun,
			&i.NextScheduledRun,
			&i.ScheduleEnabled,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listScheduledAgents = `-- name: ListScheduledAgents :many
SELECT id, name, description, prompt, max_steps, environment_id, created_by, model_id, input_schema, output_schema, output_schema_preset, app, app_subtype, cron_schedule, is_scheduled, last_scheduled_run, next_scheduled_run, schedule_enabled, created_at, updated_at FROM agents WHERE is_scheduled = TRUE AND schedule_enabled = TRUE ORDER BY next_scheduled_run
`

func (q *Queries) ListScheduledAgents(ctx context.Context) ([]Agent, error) {
	rows, err := q.db.QueryContext(ctx, listScheduledAgents)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Agent
	for rows.Next() {
		var i Agent
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Description,
			&i.Prompt,
			&i.MaxSteps,
			&i.EnvironmentID,
			&i.CreatedBy,
			&i.ModelID,
			&i.InputSchema,
			&i.OutputSchema,
			&i.OutputSchemaPreset,
			&i.App,
			&i.AppSubtype,
			&i.CronSchedule,
			&i.IsScheduled,
			&i.LastScheduledRun,
			&i.NextScheduledRun,
			&i.ScheduleEnabled,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateAgent = `-- name: UpdateAgent :exec
UPDATE agents SET name = ?, description = ?, prompt = ?, max_steps = ?, input_schema = ?, cron_schedule = ?, is_scheduled = ?, schedule_enabled = ?, output_schema = ?, output_schema_preset = ?, app = ?, app_subtype = ? WHERE id = ?
`

type UpdateAgentParams struct {
	Name               string         `json:"name"`
	Description        string         `json:"description"`
	Prompt             string         `json:"prompt"`
	MaxSteps           int64          `json:"max_steps"`
	InputSchema        sql.NullString `json:"input_schema"`
	CronSchedule       sql.NullString `json:"cron_schedule"`
	IsScheduled        sql.NullBool   `json:"is_scheduled"`
	ScheduleEnabled    sql.NullBool   `json:"schedule_enabled"`
	OutputSchema       sql.NullString `json:"output_schema"`
	OutputSchemaPreset sql.NullString `json:"output_schema_preset"`
	App                sql.NullString `json:"app"`
	AppSubtype         sql.NullString `json:"app_subtype"`
	ID                 int64          `json:"id"`
}

func (q *Queries) UpdateAgent(ctx context.Context, arg UpdateAgentParams) error {
	_, err := q.db.ExecContext(ctx, updateAgent,
		arg.Name,
		arg.Description,
		arg.Prompt,
		arg.MaxSteps,
		arg.InputSchema,
		arg.CronSchedule,
		arg.IsScheduled,
		arg.ScheduleEnabled,
		arg.OutputSchema,
		arg.OutputSchemaPreset,
		arg.App,
		arg.AppSubtype,
		arg.ID,
	)
	return err
}

const updateAgentPrompt = `-- name: UpdateAgentPrompt :exec
UPDATE agents SET prompt = ? WHERE id = ?
`

type UpdateAgentPromptParams struct {
	Prompt string `json:"prompt"`
	ID     int64  `json:"id"`
}

func (q *Queries) UpdateAgentPrompt(ctx context.Context, arg UpdateAgentPromptParams) error {
	_, err := q.db.ExecContext(ctx, updateAgentPrompt, arg.Prompt, arg.ID)
	return err
}

const updateAgentScheduleTime = `-- name: UpdateAgentScheduleTime :exec
UPDATE agents SET last_scheduled_run = ?, next_scheduled_run = ? WHERE id = ?
`

type UpdateAgentScheduleTimeParams struct {
	LastScheduledRun sql.NullTime `json:"last_scheduled_run"`
	NextScheduledRun sql.NullTime `json:"next_scheduled_run"`
	ID               int64        `json:"id"`
}

func (q *Queries) UpdateAgentScheduleTime(ctx context.Context, arg UpdateAgentScheduleTimeParams) error {
	_, err := q.db.ExecContext(ctx, updateAgentScheduleTime, arg.LastScheduledRun, arg.NextScheduledRun, arg.ID)
	return err
}
