// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: environments.sql

package queries

import (
	"context"
	"database/sql"
)

const createEnvironment = `-- name: CreateEnvironment :one
INSERT INTO environments (name, description, created_by)
VALUES (?, ?, ?)
RETURNING id, name, description, created_by, created_at, updated_at
`

type CreateEnvironmentParams struct {
	Name        string         `json:"name"`
	Description sql.NullString `json:"description"`
	CreatedBy   int64          `json:"created_by"`
}

func (q *Queries) CreateEnvironment(ctx context.Context, arg CreateEnvironmentParams) (Environment, error) {
	row := q.db.QueryRowContext(ctx, createEnvironment, arg.Name, arg.Description, arg.CreatedBy)
	var i Environment
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteEnvironment = `-- name: DeleteEnvironment :exec
DELETE FROM environments WHERE id = ?
`

func (q *Queries) DeleteEnvironment(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteEnvironment, id)
	return err
}

const getEnvironment = `-- name: GetEnvironment :one
SELECT id, name, description, created_by, created_at, updated_at FROM environments WHERE id = ?
`

func (q *Queries) GetEnvironment(ctx context.Context, id int64) (Environment, error) {
	row := q.db.QueryRowContext(ctx, getEnvironment, id)
	var i Environment
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getEnvironmentByName = `-- name: GetEnvironmentByName :one
SELECT id, name, description, created_by, created_at, updated_at FROM environments WHERE name = ?
`

func (q *Queries) GetEnvironmentByName(ctx context.Context, name string) (Environment, error) {
	row := q.db.QueryRowContext(ctx, getEnvironmentByName, name)
	var i Environment
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Description,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const listEnvironments = `-- name: ListEnvironments :many
SELECT id, name, description, created_by, created_at, updated_at FROM environments ORDER BY name
`

func (q *Queries) ListEnvironments(ctx context.Context) ([]Environment, error) {
	rows, err := q.db.QueryContext(ctx, listEnvironments)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Environment
	for rows.Next() {
		var i Environment
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Description,
			&i.CreatedBy,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateEnvironment = `-- name: UpdateEnvironment :exec
UPDATE environments SET name = ?, description = ? WHERE id = ?
`

type UpdateEnvironmentParams struct {
	Name        string         `json:"name"`
	Description sql.NullString `json:"description"`
	ID          int64          `json:"id"`
}

func (q *Queries) UpdateEnvironment(ctx context.Context, arg UpdateEnvironmentParams) error {
	_, err := q.db.ExecContext(ctx, updateEnvironment, arg.Name, arg.Description, arg.ID)
	return err
}
