// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: file_mcp_configs.sql

package queries

import (
	"context"
	"database/sql"
)

const checkFileMCPConfigChanges = `-- name: CheckFileMCPConfigChanges :one
SELECT COUNT(*)
FROM file_mcp_configs
WHERE environment_id = ? AND config_name = ?
  AND template_hash = ? AND variables_hash = ? AND template_vars_hash = ?
`

type CheckFileMCPConfigChangesParams struct {
	EnvironmentID    int64          `json:"environment_id"`
	ConfigName       string         `json:"config_name"`
	TemplateHash     sql.NullString `json:"template_hash"`
	VariablesHash    sql.NullString `json:"variables_hash"`
	TemplateVarsHash sql.NullString `json:"template_vars_hash"`
}

func (q *Queries) CheckFileMCPConfigChanges(ctx context.Context, arg CheckFileMCPConfigChangesParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, checkFileMCPConfigChanges,
		arg.EnvironmentID,
		arg.ConfigName,
		arg.TemplateHash,
		arg.VariablesHash,
		arg.TemplateVarsHash,
	)
	var count int64
	err := row.Scan(&count)
	return count, err
}

const createFileMCPConfig = `-- name: CreateFileMCPConfig :one

INSERT INTO file_mcp_configs (
    environment_id, config_name, template_path, variables_path,
    template_specific_vars_path, template_hash, variables_hash,
    template_vars_hash, metadata
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
RETURNING id, environment_id, config_name, template_path, variables_path, template_specific_vars_path, last_loaded_at, template_hash, variables_hash, template_vars_hash, metadata, created_at, updated_at
`

type CreateFileMCPConfigParams struct {
	EnvironmentID            int64          `json:"environment_id"`
	ConfigName               string         `json:"config_name"`
	TemplatePath             string         `json:"template_path"`
	VariablesPath            sql.NullString `json:"variables_path"`
	TemplateSpecificVarsPath sql.NullString `json:"template_specific_vars_path"`
	TemplateHash             sql.NullString `json:"template_hash"`
	VariablesHash            sql.NullString `json:"variables_hash"`
	TemplateVarsHash         sql.NullString `json:"template_vars_hash"`
	Metadata                 sql.NullString `json:"metadata"`
}

// File-based MCP configuration queries
func (q *Queries) CreateFileMCPConfig(ctx context.Context, arg CreateFileMCPConfigParams) (FileMcpConfig, error) {
	row := q.db.QueryRowContext(ctx, createFileMCPConfig,
		arg.EnvironmentID,
		arg.ConfigName,
		arg.TemplatePath,
		arg.VariablesPath,
		arg.TemplateSpecificVarsPath,
		arg.TemplateHash,
		arg.VariablesHash,
		arg.TemplateVarsHash,
		arg.Metadata,
	)
	var i FileMcpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.TemplatePath,
		&i.VariablesPath,
		&i.TemplateSpecificVarsPath,
		&i.LastLoadedAt,
		&i.TemplateHash,
		&i.VariablesHash,
		&i.TemplateVarsHash,
		&i.Metadata,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteFileMCPConfig = `-- name: DeleteFileMCPConfig :exec
DELETE FROM file_mcp_configs WHERE id = ?
`

func (q *Queries) DeleteFileMCPConfig(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteFileMCPConfig, id)
	return err
}

const deleteFileMCPConfigByEnvironmentAndName = `-- name: DeleteFileMCPConfigByEnvironmentAndName :exec
DELETE FROM file_mcp_configs WHERE environment_id = ? AND config_name = ?
`

type DeleteFileMCPConfigByEnvironmentAndNameParams struct {
	EnvironmentID int64  `json:"environment_id"`
	ConfigName    string `json:"config_name"`
}

func (q *Queries) DeleteFileMCPConfigByEnvironmentAndName(ctx context.Context, arg DeleteFileMCPConfigByEnvironmentAndNameParams) error {
	_, err := q.db.ExecContext(ctx, deleteFileMCPConfigByEnvironmentAndName, arg.EnvironmentID, arg.ConfigName)
	return err
}

const getFileMCPConfig = `-- name: GetFileMCPConfig :one
SELECT id, environment_id, config_name, template_path, variables_path, template_specific_vars_path, last_loaded_at, template_hash, variables_hash, template_vars_hash, metadata, created_at, updated_at FROM file_mcp_configs WHERE id = ?
`

func (q *Queries) GetFileMCPConfig(ctx context.Context, id int64) (FileMcpConfig, error) {
	row := q.db.QueryRowContext(ctx, getFileMCPConfig, id)
	var i FileMcpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.TemplatePath,
		&i.VariablesPath,
		&i.TemplateSpecificVarsPath,
		&i.LastLoadedAt,
		&i.TemplateHash,
		&i.VariablesHash,
		&i.TemplateVarsHash,
		&i.Metadata,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getFileMCPConfigByEnvironmentAndName = `-- name: GetFileMCPConfigByEnvironmentAndName :one
SELECT id, environment_id, config_name, template_path, variables_path, template_specific_vars_path, last_loaded_at, template_hash, variables_hash, template_vars_hash, metadata, created_at, updated_at FROM file_mcp_configs WHERE environment_id = ? AND config_name = ?
`

type GetFileMCPConfigByEnvironmentAndNameParams struct {
	EnvironmentID int64  `json:"environment_id"`
	ConfigName    string `json:"config_name"`
}

func (q *Queries) GetFileMCPConfigByEnvironmentAndName(ctx context.Context, arg GetFileMCPConfigByEnvironmentAndNameParams) (FileMcpConfig, error) {
	row := q.db.QueryRowContext(ctx, getFileMCPConfigByEnvironmentAndName, arg.EnvironmentID, arg.ConfigName)
	var i FileMcpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.TemplatePath,
		&i.VariablesPath,
		&i.TemplateSpecificVarsPath,
		&i.LastLoadedAt,
		&i.TemplateHash,
		&i.VariablesHash,
		&i.TemplateVarsHash,
		&i.Metadata,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getFileMCPConfigsForChangeDetection = `-- name: GetFileMCPConfigsForChangeDetection :many
SELECT id, environment_id, config_name, template_path, variables_path,
       template_hash, variables_hash, template_vars_hash, last_loaded_at
FROM file_mcp_configs
WHERE environment_id = ?
`

type GetFileMCPConfigsForChangeDetectionRow struct {
	ID               int64          `json:"id"`
	EnvironmentID    int64          `json:"environment_id"`
	ConfigName       string         `json:"config_name"`
	TemplatePath     string         `json:"template_path"`
	VariablesPath    sql.NullString `json:"variables_path"`
	TemplateHash     sql.NullString `json:"template_hash"`
	VariablesHash    sql.NullString `json:"variables_hash"`
	TemplateVarsHash sql.NullString `json:"template_vars_hash"`
	LastLoadedAt     sql.NullTime   `json:"last_loaded_at"`
}

func (q *Queries) GetFileMCPConfigsForChangeDetection(ctx context.Context, environmentID int64) ([]GetFileMCPConfigsForChangeDetectionRow, error) {
	rows, err := q.db.QueryContext(ctx, getFileMCPConfigsForChangeDetection, environmentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetFileMCPConfigsForChangeDetectionRow
	for rows.Next() {
		var i GetFileMCPConfigsForChangeDetectionRow
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.TemplatePath,
			&i.VariablesPath,
			&i.TemplateHash,
			&i.VariablesHash,
			&i.TemplateVarsHash,
			&i.LastLoadedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listFileMCPConfigsByEnvironment = `-- name: ListFileMCPConfigsByEnvironment :many
SELECT id, environment_id, config_name, template_path, variables_path, template_specific_vars_path, last_loaded_at, template_hash, variables_hash, template_vars_hash, metadata, created_at, updated_at FROM file_mcp_configs WHERE environment_id = ? ORDER BY config_name
`

func (q *Queries) ListFileMCPConfigsByEnvironment(ctx context.Context, environmentID int64) ([]FileMcpConfig, error) {
	rows, err := q.db.QueryContext(ctx, listFileMCPConfigsByEnvironment, environmentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []FileMcpConfig
	for rows.Next() {
		var i FileMcpConfig
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.TemplatePath,
			&i.VariablesPath,
			&i.TemplateSpecificVarsPath,
			&i.LastLoadedAt,
			&i.TemplateHash,
			&i.VariablesHash,
			&i.TemplateVarsHash,
			&i.Metadata,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateFileMCPConfigHashes = `-- name: UpdateFileMCPConfigHashes :exec
UPDATE file_mcp_configs
SET template_hash = ?, variables_hash = ?, template_vars_hash = ?, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
`

type UpdateFileMCPConfigHashesParams struct {
	TemplateHash     sql.NullString `json:"template_hash"`
	VariablesHash    sql.NullString `json:"variables_hash"`
	TemplateVarsHash sql.NullString `json:"template_vars_hash"`
	ID               int64          `json:"id"`
}

func (q *Queries) UpdateFileMCPConfigHashes(ctx context.Context, arg UpdateFileMCPConfigHashesParams) error {
	_, err := q.db.ExecContext(ctx, updateFileMCPConfigHashes,
		arg.TemplateHash,
		arg.VariablesHash,
		arg.TemplateVarsHash,
		arg.ID,
	)
	return err
}

const updateFileMCPConfigLastLoadedAt = `-- name: UpdateFileMCPConfigLastLoadedAt :exec
UPDATE file_mcp_configs
SET last_loaded_at = CURRENT_TIMESTAMP, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
`

func (q *Queries) UpdateFileMCPConfigLastLoadedAt(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, updateFileMCPConfigLastLoadedAt, id)
	return err
}

const updateFileMCPConfigMetadata = `-- name: UpdateFileMCPConfigMetadata :exec
UPDATE file_mcp_configs
SET metadata = ?, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
`

type UpdateFileMCPConfigMetadataParams struct {
	Metadata sql.NullString `json:"metadata"`
	ID       int64          `json:"id"`
}

func (q *Queries) UpdateFileMCPConfigMetadata(ctx context.Context, arg UpdateFileMCPConfigMetadataParams) error {
	_, err := q.db.ExecContext(ctx, updateFileMCPConfigMetadata, arg.Metadata, arg.ID)
	return err
}
