// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: mcp_configs.sql

package queries

import (
	"context"
	"database/sql"
)

const createMCPConfig = `-- name: CreateMCPConfig :one
INSERT INTO mcp_configs (environment_id, config_name, version, config_json, encryption_key_id)
VALUES (?, ?, ?, ?, ?)
RETURNING id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at
`

type CreateMCPConfigParams struct {
	EnvironmentID   int64          `json:"environment_id"`
	ConfigName      string         `json:"config_name"`
	Version         int64          `json:"version"`
	ConfigJson      string         `json:"config_json"`
	EncryptionKeyID sql.NullString `json:"encryption_key_id"`
}

func (q *Queries) CreateMCPConfig(ctx context.Context, arg CreateMCPConfigParams) (McpConfig, error) {
	row := q.db.QueryRowContext(ctx, createMCPConfig,
		arg.EnvironmentID,
		arg.ConfigName,
		arg.Version,
		arg.ConfigJson,
		arg.EncryptionKeyID,
	)
	var i McpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.Version,
		&i.ConfigJson,
		&i.EncryptionKeyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteMCPConfig = `-- name: DeleteMCPConfig :exec
DELETE FROM mcp_configs WHERE id = ?
`

func (q *Queries) DeleteMCPConfig(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteMCPConfig, id)
	return err
}

const getAllLatestMCPConfigs = `-- name: GetAllLatestMCPConfigs :many
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs c1
WHERE version = (
    SELECT MAX(version) 
    FROM mcp_configs c2 
    WHERE c2.environment_id = c1.environment_id 
    AND c2.config_name = c1.config_name
)
ORDER BY environment_id, config_name, version DESC
`

func (q *Queries) GetAllLatestMCPConfigs(ctx context.Context) ([]McpConfig, error) {
	rows, err := q.db.QueryContext(ctx, getAllLatestMCPConfigs)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpConfig
	for rows.Next() {
		var i McpConfig
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.Version,
			&i.ConfigJson,
			&i.EncryptionKeyID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getLatestMCPConfig = `-- name: GetLatestMCPConfig :one
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
WHERE environment_id = ? 
ORDER BY version DESC 
LIMIT 1
`

func (q *Queries) GetLatestMCPConfig(ctx context.Context, environmentID int64) (McpConfig, error) {
	row := q.db.QueryRowContext(ctx, getLatestMCPConfig, environmentID)
	var i McpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.Version,
		&i.ConfigJson,
		&i.EncryptionKeyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getLatestMCPConfigByName = `-- name: GetLatestMCPConfigByName :one
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
WHERE environment_id = ? AND config_name = ? 
ORDER BY version DESC 
LIMIT 1
`

type GetLatestMCPConfigByNameParams struct {
	EnvironmentID int64  `json:"environment_id"`
	ConfigName    string `json:"config_name"`
}

func (q *Queries) GetLatestMCPConfigByName(ctx context.Context, arg GetLatestMCPConfigByNameParams) (McpConfig, error) {
	row := q.db.QueryRowContext(ctx, getLatestMCPConfigByName, arg.EnvironmentID, arg.ConfigName)
	var i McpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.Version,
		&i.ConfigJson,
		&i.EncryptionKeyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getLatestMCPConfigs = `-- name: GetLatestMCPConfigs :many
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs c1
WHERE c1.environment_id = ? 
AND version = (
    SELECT MAX(version) 
    FROM mcp_configs c2 
    WHERE c2.environment_id = c1.environment_id 
    AND c2.config_name = c1.config_name
)
ORDER BY config_name, version DESC
`

func (q *Queries) GetLatestMCPConfigs(ctx context.Context, environmentID int64) ([]McpConfig, error) {
	rows, err := q.db.QueryContext(ctx, getLatestMCPConfigs, environmentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpConfig
	for rows.Next() {
		var i McpConfig
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.Version,
			&i.ConfigJson,
			&i.EncryptionKeyID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getMCPConfig = `-- name: GetMCPConfig :one
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs WHERE id = ?
`

func (q *Queries) GetMCPConfig(ctx context.Context, id int64) (McpConfig, error) {
	row := q.db.QueryRowContext(ctx, getMCPConfig, id)
	var i McpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.Version,
		&i.ConfigJson,
		&i.EncryptionKeyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getMCPConfigByVersion = `-- name: GetMCPConfigByVersion :one
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
WHERE environment_id = ? AND version = ?
`

type GetMCPConfigByVersionParams struct {
	EnvironmentID int64 `json:"environment_id"`
	Version       int64 `json:"version"`
}

func (q *Queries) GetMCPConfigByVersion(ctx context.Context, arg GetMCPConfigByVersionParams) (McpConfig, error) {
	row := q.db.QueryRowContext(ctx, getMCPConfigByVersion, arg.EnvironmentID, arg.Version)
	var i McpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.Version,
		&i.ConfigJson,
		&i.EncryptionKeyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getMCPConfigByVersionAndName = `-- name: GetMCPConfigByVersionAndName :one
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
WHERE environment_id = ? AND config_name = ? AND version = ?
`

type GetMCPConfigByVersionAndNameParams struct {
	EnvironmentID int64  `json:"environment_id"`
	ConfigName    string `json:"config_name"`
	Version       int64  `json:"version"`
}

func (q *Queries) GetMCPConfigByVersionAndName(ctx context.Context, arg GetMCPConfigByVersionAndNameParams) (McpConfig, error) {
	row := q.db.QueryRowContext(ctx, getMCPConfigByVersionAndName, arg.EnvironmentID, arg.ConfigName, arg.Version)
	var i McpConfig
	err := row.Scan(
		&i.ID,
		&i.EnvironmentID,
		&i.ConfigName,
		&i.Version,
		&i.ConfigJson,
		&i.EncryptionKeyID,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getMCPConfigsForRotation = `-- name: GetMCPConfigsForRotation :many
SELECT id, config_json FROM mcp_configs WHERE encryption_key_id = ?
`

type GetMCPConfigsForRotationRow struct {
	ID         int64  `json:"id"`
	ConfigJson string `json:"config_json"`
}

func (q *Queries) GetMCPConfigsForRotation(ctx context.Context, encryptionKeyID sql.NullString) ([]GetMCPConfigsForRotationRow, error) {
	rows, err := q.db.QueryContext(ctx, getMCPConfigsForRotation, encryptionKeyID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetMCPConfigsForRotationRow
	for rows.Next() {
		var i GetMCPConfigsForRotationRow
		if err := rows.Scan(&i.ID, &i.ConfigJson); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getNextMCPConfigVersion = `-- name: GetNextMCPConfigVersion :one
SELECT COALESCE(MAX(version), 0) + 1 as next_version
FROM mcp_configs 
WHERE environment_id = ?
`

func (q *Queries) GetNextMCPConfigVersion(ctx context.Context, environmentID int64) (int64, error) {
	row := q.db.QueryRowContext(ctx, getNextMCPConfigVersion, environmentID)
	var next_version int64
	err := row.Scan(&next_version)
	return next_version, err
}

const getNextMCPConfigVersionByName = `-- name: GetNextMCPConfigVersionByName :one
SELECT COALESCE(MAX(version), 0) + 1 as next_version FROM mcp_configs WHERE environment_id = ? AND config_name = ?
`

type GetNextMCPConfigVersionByNameParams struct {
	EnvironmentID int64  `json:"environment_id"`
	ConfigName    string `json:"config_name"`
}

func (q *Queries) GetNextMCPConfigVersionByName(ctx context.Context, arg GetNextMCPConfigVersionByNameParams) (int64, error) {
	row := q.db.QueryRowContext(ctx, getNextMCPConfigVersionByName, arg.EnvironmentID, arg.ConfigName)
	var next_version int64
	err := row.Scan(&next_version)
	return next_version, err
}

const listAllMCPConfigs = `-- name: ListAllMCPConfigs :many
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
ORDER BY environment_id, config_name, version DESC
`

func (q *Queries) ListAllMCPConfigs(ctx context.Context) ([]McpConfig, error) {
	rows, err := q.db.QueryContext(ctx, listAllMCPConfigs)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpConfig
	for rows.Next() {
		var i McpConfig
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.Version,
			&i.ConfigJson,
			&i.EncryptionKeyID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listMCPConfigsByConfigName = `-- name: ListMCPConfigsByConfigName :many
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
WHERE environment_id = ? AND config_name = ? 
ORDER BY version DESC
`

type ListMCPConfigsByConfigNameParams struct {
	EnvironmentID int64  `json:"environment_id"`
	ConfigName    string `json:"config_name"`
}

func (q *Queries) ListMCPConfigsByConfigName(ctx context.Context, arg ListMCPConfigsByConfigNameParams) ([]McpConfig, error) {
	rows, err := q.db.QueryContext(ctx, listMCPConfigsByConfigName, arg.EnvironmentID, arg.ConfigName)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpConfig
	for rows.Next() {
		var i McpConfig
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.Version,
			&i.ConfigJson,
			&i.EncryptionKeyID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listMCPConfigsByEnvironment = `-- name: ListMCPConfigsByEnvironment :many
SELECT id, environment_id, config_name, version, config_json, encryption_key_id, created_at, updated_at FROM mcp_configs 
WHERE environment_id = ? 
ORDER BY version DESC
`

func (q *Queries) ListMCPConfigsByEnvironment(ctx context.Context, environmentID int64) ([]McpConfig, error) {
	rows, err := q.db.QueryContext(ctx, listMCPConfigsByEnvironment, environmentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpConfig
	for rows.Next() {
		var i McpConfig
		if err := rows.Scan(
			&i.ID,
			&i.EnvironmentID,
			&i.ConfigName,
			&i.Version,
			&i.ConfigJson,
			&i.EncryptionKeyID,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateMCPConfigEncryption = `-- name: UpdateMCPConfigEncryption :exec
UPDATE mcp_configs SET config_json = ?, encryption_key_id = ? WHERE id = ?
`

type UpdateMCPConfigEncryptionParams struct {
	ConfigJson      string         `json:"config_json"`
	EncryptionKeyID sql.NullString `json:"encryption_key_id"`
	ID              int64          `json:"id"`
}

func (q *Queries) UpdateMCPConfigEncryption(ctx context.Context, arg UpdateMCPConfigEncryptionParams) error {
	_, err := q.db.ExecContext(ctx, updateMCPConfigEncryption, arg.ConfigJson, arg.EncryptionKeyID, arg.ID)
	return err
}
