// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: mcp_servers.sql

package queries

import (
	"context"
	"database/sql"
)

const createMCPServer = `-- name: CreateMCPServer :one
INSERT INTO mcp_servers (name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
RETURNING id, name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id, created_at
`

type CreateMCPServerParams struct {
	Name           string         `json:"name"`
	Command        string         `json:"command"`
	Args           sql.NullString `json:"args"`
	Env            sql.NullString `json:"env"`
	WorkingDir     sql.NullString `json:"working_dir"`
	TimeoutSeconds sql.NullInt64  `json:"timeout_seconds"`
	AutoRestart    sql.NullBool   `json:"auto_restart"`
	EnvironmentID  int64          `json:"environment_id"`
	FileConfigID   sql.NullInt64  `json:"file_config_id"`
}

func (q *Queries) CreateMCPServer(ctx context.Context, arg CreateMCPServerParams) (McpServer, error) {
	row := q.db.QueryRowContext(ctx, createMCPServer,
		arg.Name,
		arg.Command,
		arg.Args,
		arg.Env,
		arg.WorkingDir,
		arg.TimeoutSeconds,
		arg.AutoRestart,
		arg.EnvironmentID,
		arg.FileConfigID,
	)
	var i McpServer
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Command,
		&i.Args,
		&i.Env,
		&i.WorkingDir,
		&i.TimeoutSeconds,
		&i.AutoRestart,
		&i.EnvironmentID,
		&i.FileConfigID,
		&i.CreatedAt,
	)
	return i, err
}

const deleteMCPServer = `-- name: DeleteMCPServer :exec
DELETE FROM mcp_servers WHERE id = ?
`

func (q *Queries) DeleteMCPServer(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteMCPServer, id)
	return err
}

const deleteMCPServersByEnvironment = `-- name: DeleteMCPServersByEnvironment :exec
DELETE FROM mcp_servers WHERE environment_id = ?
`

func (q *Queries) DeleteMCPServersByEnvironment(ctx context.Context, environmentID int64) error {
	_, err := q.db.ExecContext(ctx, deleteMCPServersByEnvironment, environmentID)
	return err
}

const deleteMCPServersByFileConfig = `-- name: DeleteMCPServersByFileConfig :exec
DELETE FROM mcp_servers WHERE file_config_id = ?
`

func (q *Queries) DeleteMCPServersByFileConfig(ctx context.Context, fileConfigID sql.NullInt64) error {
	_, err := q.db.ExecContext(ctx, deleteMCPServersByFileConfig, fileConfigID)
	return err
}

const getMCPServer = `-- name: GetMCPServer :one
SELECT id, name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id, created_at FROM mcp_servers WHERE id = ?
`

func (q *Queries) GetMCPServer(ctx context.Context, id int64) (McpServer, error) {
	row := q.db.QueryRowContext(ctx, getMCPServer, id)
	var i McpServer
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Command,
		&i.Args,
		&i.Env,
		&i.WorkingDir,
		&i.TimeoutSeconds,
		&i.AutoRestart,
		&i.EnvironmentID,
		&i.FileConfigID,
		&i.CreatedAt,
	)
	return i, err
}

const getMCPServerByNameAndEnvironment = `-- name: GetMCPServerByNameAndEnvironment :one
SELECT id, name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id, created_at FROM mcp_servers WHERE name = ? AND environment_id = ?
`

type GetMCPServerByNameAndEnvironmentParams struct {
	Name          string `json:"name"`
	EnvironmentID int64  `json:"environment_id"`
}

func (q *Queries) GetMCPServerByNameAndEnvironment(ctx context.Context, arg GetMCPServerByNameAndEnvironmentParams) (McpServer, error) {
	row := q.db.QueryRowContext(ctx, getMCPServerByNameAndEnvironment, arg.Name, arg.EnvironmentID)
	var i McpServer
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Command,
		&i.Args,
		&i.Env,
		&i.WorkingDir,
		&i.TimeoutSeconds,
		&i.AutoRestart,
		&i.EnvironmentID,
		&i.FileConfigID,
		&i.CreatedAt,
	)
	return i, err
}

const listAllMCPServers = `-- name: ListAllMCPServers :many
SELECT id, name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id, created_at FROM mcp_servers ORDER BY name
`

func (q *Queries) ListAllMCPServers(ctx context.Context) ([]McpServer, error) {
	rows, err := q.db.QueryContext(ctx, listAllMCPServers)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpServer
	for rows.Next() {
		var i McpServer
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Command,
			&i.Args,
			&i.Env,
			&i.WorkingDir,
			&i.TimeoutSeconds,
			&i.AutoRestart,
			&i.EnvironmentID,
			&i.FileConfigID,
			&i.CreatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listMCPServersByEnvironment = `-- name: ListMCPServersByEnvironment :many
SELECT id, name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id, created_at FROM mcp_servers WHERE environment_id = ? ORDER BY name
`

func (q *Queries) ListMCPServersByEnvironment(ctx context.Context, environmentID int64) ([]McpServer, error) {
	rows, err := q.db.QueryContext(ctx, listMCPServersByEnvironment, environmentID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []McpServer
	for rows.Next() {
		var i McpServer
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Command,
			&i.Args,
			&i.Env,
			&i.WorkingDir,
			&i.TimeoutSeconds,
			&i.AutoRestart,
			&i.EnvironmentID,
			&i.FileConfigID,
			&i.CreatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateMCPServer = `-- name: UpdateMCPServer :one
UPDATE mcp_servers 
SET name = ?, command = ?, args = ?, env = ?, working_dir = ?, timeout_seconds = ?, auto_restart = ?, file_config_id = ?
WHERE id = ?
RETURNING id, name, command, args, env, working_dir, timeout_seconds, auto_restart, environment_id, file_config_id, created_at
`

type UpdateMCPServerParams struct {
	Name           string         `json:"name"`
	Command        string         `json:"command"`
	Args           sql.NullString `json:"args"`
	Env            sql.NullString `json:"env"`
	WorkingDir     sql.NullString `json:"working_dir"`
	TimeoutSeconds sql.NullInt64  `json:"timeout_seconds"`
	AutoRestart    sql.NullBool   `json:"auto_restart"`
	FileConfigID   sql.NullInt64  `json:"file_config_id"`
	ID             int64          `json:"id"`
}

func (q *Queries) UpdateMCPServer(ctx context.Context, arg UpdateMCPServerParams) (McpServer, error) {
	row := q.db.QueryRowContext(ctx, updateMCPServer,
		arg.Name,
		arg.Command,
		arg.Args,
		arg.Env,
		arg.WorkingDir,
		arg.TimeoutSeconds,
		arg.AutoRestart,
		arg.FileConfigID,
		arg.ID,
	)
	var i McpServer
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Command,
		&i.Args,
		&i.Env,
		&i.WorkingDir,
		&i.TimeoutSeconds,
		&i.AutoRestart,
		&i.EnvironmentID,
		&i.FileConfigID,
		&i.CreatedAt,
	)
	return i, err
}
