// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: model_providers.sql

package queries

import (
	"context"
	"database/sql"
)

const createModelProvider = `-- name: CreateModelProvider :one
INSERT INTO model_providers (
    name, display_name, base_url, api_key, headers, enabled, is_default
) VALUES (
    ?, ?, ?, ?, ?, ?, ?
) RETURNING id, name, display_name, base_url, api_key, headers, enabled, is_default, created_at, updated_at
`

type CreateModelProviderParams struct {
	Name        string         `json:"name"`
	DisplayName string         `json:"display_name"`
	BaseUrl     string         `json:"base_url"`
	ApiKey      sql.NullString `json:"api_key"`
	Headers     sql.NullString `json:"headers"`
	Enabled     sql.NullBool   `json:"enabled"`
	IsDefault   sql.NullBool   `json:"is_default"`
}

func (q *Queries) CreateModelProvider(ctx context.Context, arg CreateModelProviderParams) (ModelProvider, error) {
	row := q.db.QueryRowContext(ctx, createModelProvider,
		arg.Name,
		arg.DisplayName,
		arg.BaseUrl,
		arg.ApiKey,
		arg.Headers,
		arg.Enabled,
		arg.IsDefault,
	)
	var i ModelProvider
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.BaseUrl,
		&i.ApiKey,
		&i.Headers,
		&i.Enabled,
		&i.IsDefault,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteModelProvider = `-- name: DeleteModelProvider :exec
DELETE FROM model_providers WHERE id = ?
`

func (q *Queries) DeleteModelProvider(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteModelProvider, id)
	return err
}

const getDefaultModelProvider = `-- name: GetDefaultModelProvider :one
SELECT id, name, display_name, base_url, api_key, headers, enabled, is_default, created_at, updated_at FROM model_providers WHERE is_default = true AND enabled = true LIMIT 1
`

func (q *Queries) GetDefaultModelProvider(ctx context.Context) (ModelProvider, error) {
	row := q.db.QueryRowContext(ctx, getDefaultModelProvider)
	var i ModelProvider
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.BaseUrl,
		&i.ApiKey,
		&i.Headers,
		&i.Enabled,
		&i.IsDefault,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getModelProvider = `-- name: GetModelProvider :one
SELECT id, name, display_name, base_url, api_key, headers, enabled, is_default, created_at, updated_at FROM model_providers WHERE id = ?
`

func (q *Queries) GetModelProvider(ctx context.Context, id int64) (ModelProvider, error) {
	row := q.db.QueryRowContext(ctx, getModelProvider, id)
	var i ModelProvider
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.BaseUrl,
		&i.ApiKey,
		&i.Headers,
		&i.Enabled,
		&i.IsDefault,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getModelProviderByName = `-- name: GetModelProviderByName :one
SELECT id, name, display_name, base_url, api_key, headers, enabled, is_default, created_at, updated_at FROM model_providers WHERE name = ?
`

func (q *Queries) GetModelProviderByName(ctx context.Context, name string) (ModelProvider, error) {
	row := q.db.QueryRowContext(ctx, getModelProviderByName, name)
	var i ModelProvider
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.BaseUrl,
		&i.ApiKey,
		&i.Headers,
		&i.Enabled,
		&i.IsDefault,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const listEnabledModelProviders = `-- name: ListEnabledModelProviders :many
SELECT id, name, display_name, base_url, api_key, headers, enabled, is_default, created_at, updated_at FROM model_providers WHERE enabled = true ORDER BY name
`

func (q *Queries) ListEnabledModelProviders(ctx context.Context) ([]ModelProvider, error) {
	rows, err := q.db.QueryContext(ctx, listEnabledModelProviders)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ModelProvider
	for rows.Next() {
		var i ModelProvider
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.DisplayName,
			&i.BaseUrl,
			&i.ApiKey,
			&i.Headers,
			&i.Enabled,
			&i.IsDefault,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listModelProviders = `-- name: ListModelProviders :many
SELECT id, name, display_name, base_url, api_key, headers, enabled, is_default, created_at, updated_at FROM model_providers ORDER BY name
`

func (q *Queries) ListModelProviders(ctx context.Context) ([]ModelProvider, error) {
	rows, err := q.db.QueryContext(ctx, listModelProviders)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ModelProvider
	for rows.Next() {
		var i ModelProvider
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.DisplayName,
			&i.BaseUrl,
			&i.ApiKey,
			&i.Headers,
			&i.Enabled,
			&i.IsDefault,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const setDefaultModelProvider = `-- name: SetDefaultModelProvider :exec
UPDATE model_providers SET is_default = CASE WHEN id = ? THEN true ELSE false END
`

func (q *Queries) SetDefaultModelProvider(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, setDefaultModelProvider, id)
	return err
}

const updateModelProvider = `-- name: UpdateModelProvider :exec
UPDATE model_providers 
SET display_name = ?, base_url = ?, api_key = ?, headers = ?, enabled = ?, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
`

type UpdateModelProviderParams struct {
	DisplayName string         `json:"display_name"`
	BaseUrl     string         `json:"base_url"`
	ApiKey      sql.NullString `json:"api_key"`
	Headers     sql.NullString `json:"headers"`
	Enabled     sql.NullBool   `json:"enabled"`
	ID          int64          `json:"id"`
}

func (q *Queries) UpdateModelProvider(ctx context.Context, arg UpdateModelProviderParams) error {
	_, err := q.db.ExecContext(ctx, updateModelProvider,
		arg.DisplayName,
		arg.BaseUrl,
		arg.ApiKey,
		arg.Headers,
		arg.Enabled,
		arg.ID,
	)
	return err
}
