// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0

package queries

import (
	"database/sql"
)

type Agent struct {
	ID                 int64          `json:"id"`
	Name               string         `json:"name"`
	Description        string         `json:"description"`
	Prompt             string         `json:"prompt"`
	MaxSteps           int64          `json:"max_steps"`
	EnvironmentID      int64          `json:"environment_id"`
	CreatedBy          int64          `json:"created_by"`
	ModelID            sql.NullInt64  `json:"model_id"`
	InputSchema        sql.NullString `json:"input_schema"`
	OutputSchema       sql.NullString `json:"output_schema"`
	OutputSchemaPreset sql.NullString `json:"output_schema_preset"`
	App                sql.NullString `json:"app"`
	AppSubtype         sql.NullString `json:"app_subtype"`
	CronSchedule       sql.NullString `json:"cron_schedule"`
	IsScheduled        sql.NullBool   `json:"is_scheduled"`
	LastScheduledRun   sql.NullTime   `json:"last_scheduled_run"`
	NextScheduledRun   sql.NullTime   `json:"next_scheduled_run"`
	ScheduleEnabled    sql.NullBool   `json:"schedule_enabled"`
	CreatedAt          sql.NullTime   `json:"created_at"`
	UpdatedAt          sql.NullTime   `json:"updated_at"`
}

type AgentRun struct {
	ID              int64           `json:"id"`
	AgentID         int64           `json:"agent_id"`
	UserID          int64           `json:"user_id"`
	Task            string          `json:"task"`
	FinalResponse   string          `json:"final_response"`
	StepsTaken      int64           `json:"steps_taken"`
	ToolCalls       sql.NullString  `json:"tool_calls"`
	ExecutionSteps  sql.NullString  `json:"execution_steps"`
	Status          string          `json:"status"`
	StartedAt       sql.NullTime    `json:"started_at"`
	CompletedAt     sql.NullTime    `json:"completed_at"`
	InputTokens     sql.NullInt64   `json:"input_tokens"`
	OutputTokens    sql.NullInt64   `json:"output_tokens"`
	TotalTokens     sql.NullInt64   `json:"total_tokens"`
	DurationSeconds sql.NullFloat64 `json:"duration_seconds"`
	ModelName       sql.NullString  `json:"model_name"`
	ToolsUsed       sql.NullInt64   `json:"tools_used"`
	DebugLogs       sql.NullString  `json:"debug_logs"`
	Error           sql.NullString  `json:"error"`
}

type AgentTool struct {
	ID        int64        `json:"id"`
	AgentID   int64        `json:"agent_id"`
	ToolID    int64        `json:"tool_id"`
	CreatedAt sql.NullTime `json:"created_at"`
}

type Environment struct {
	ID          int64          `json:"id"`
	Name        string         `json:"name"`
	Description sql.NullString `json:"description"`
	CreatedBy   int64          `json:"created_by"`
	CreatedAt   sql.NullTime   `json:"created_at"`
	UpdatedAt   sql.NullTime   `json:"updated_at"`
}

type FileMcpConfig struct {
	ID                       int64          `json:"id"`
	EnvironmentID            int64          `json:"environment_id"`
	ConfigName               string         `json:"config_name"`
	TemplatePath             string         `json:"template_path"`
	VariablesPath            sql.NullString `json:"variables_path"`
	TemplateSpecificVarsPath sql.NullString `json:"template_specific_vars_path"`
	LastLoadedAt             sql.NullTime   `json:"last_loaded_at"`
	TemplateHash             sql.NullString `json:"template_hash"`
	VariablesHash            sql.NullString `json:"variables_hash"`
	TemplateVarsHash         sql.NullString `json:"template_vars_hash"`
	Metadata                 sql.NullString `json:"metadata"`
	CreatedAt                sql.NullTime   `json:"created_at"`
	UpdatedAt                sql.NullTime   `json:"updated_at"`
}

type McpConfig struct {
	ID              int64          `json:"id"`
	EnvironmentID   int64          `json:"environment_id"`
	ConfigName      string         `json:"config_name"`
	Version         int64          `json:"version"`
	ConfigJson      string         `json:"config_json"`
	EncryptionKeyID sql.NullString `json:"encryption_key_id"`
	CreatedAt       sql.NullTime   `json:"created_at"`
	UpdatedAt       sql.NullTime   `json:"updated_at"`
}

type McpServer struct {
	ID             int64          `json:"id"`
	Name           string         `json:"name"`
	Command        string         `json:"command"`
	Args           sql.NullString `json:"args"`
	Env            sql.NullString `json:"env"`
	WorkingDir     sql.NullString `json:"working_dir"`
	TimeoutSeconds sql.NullInt64  `json:"timeout_seconds"`
	AutoRestart    sql.NullBool   `json:"auto_restart"`
	EnvironmentID  int64          `json:"environment_id"`
	FileConfigID   sql.NullInt64  `json:"file_config_id"`
	CreatedAt      sql.NullTime   `json:"created_at"`
}

type McpTool struct {
	ID           int64          `json:"id"`
	McpServerID  int64          `json:"mcp_server_id"`
	Name         string         `json:"name"`
	Description  sql.NullString `json:"description"`
	InputSchema  sql.NullString `json:"input_schema"`
	FileConfigID sql.NullInt64  `json:"file_config_id"`
	CreatedAt    sql.NullTime   `json:"created_at"`
	UpdatedAt    sql.NullTime   `json:"updated_at"`
}

type Model struct {
	ID            int64           `json:"id"`
	ProviderID    int64           `json:"provider_id"`
	ModelID       string          `json:"model_id"`
	Name          string          `json:"name"`
	ContextSize   int64           `json:"context_size"`
	MaxTokens     int64           `json:"max_tokens"`
	SupportsTools sql.NullBool    `json:"supports_tools"`
	InputCost     sql.NullFloat64 `json:"input_cost"`
	OutputCost    sql.NullFloat64 `json:"output_cost"`
	Enabled       sql.NullBool    `json:"enabled"`
	CreatedAt     sql.NullTime    `json:"created_at"`
	UpdatedAt     sql.NullTime    `json:"updated_at"`
}

type ModelProvider struct {
	ID          int64          `json:"id"`
	Name        string         `json:"name"`
	DisplayName string         `json:"display_name"`
	BaseUrl     string         `json:"base_url"`
	ApiKey      sql.NullString `json:"api_key"`
	Headers     sql.NullString `json:"headers"`
	Enabled     sql.NullBool   `json:"enabled"`
	IsDefault   sql.NullBool   `json:"is_default"`
	CreatedAt   sql.NullTime   `json:"created_at"`
	UpdatedAt   sql.NullTime   `json:"updated_at"`
}

type Setting struct {
	ID          int64          `json:"id"`
	Key         string         `json:"key"`
	Value       string         `json:"value"`
	Description sql.NullString `json:"description"`
	CreatedAt   sql.NullTime   `json:"created_at"`
	UpdatedAt   sql.NullTime   `json:"updated_at"`
}

type Theme struct {
	ID          int64          `json:"id"`
	Name        string         `json:"name"`
	DisplayName string         `json:"display_name"`
	Description sql.NullString `json:"description"`
	IsBuiltIn   sql.NullBool   `json:"is_built_in"`
	IsDefault   sql.NullBool   `json:"is_default"`
	CreatedBy   sql.NullInt64  `json:"created_by"`
	CreatedAt   sql.NullTime   `json:"created_at"`
	UpdatedAt   sql.NullTime   `json:"updated_at"`
}

type ThemeColor struct {
	ID          int64          `json:"id"`
	ThemeID     int64          `json:"theme_id"`
	ColorKey    string         `json:"color_key"`
	ColorValue  string         `json:"color_value"`
	Description sql.NullString `json:"description"`
}

type User struct {
	ID        int64          `json:"id"`
	Username  string         `json:"username"`
	PublicKey string         `json:"public_key"`
	IsAdmin   bool           `json:"is_admin"`
	ApiKey    sql.NullString `json:"api_key"`
	CreatedAt sql.NullTime   `json:"created_at"`
	UpdatedAt sql.NullTime   `json:"updated_at"`
}

type UserThemePreference struct {
	ID        int64        `json:"id"`
	UserID    int64        `json:"user_id"`
	ThemeID   int64        `json:"theme_id"`
	AppliedAt sql.NullTime `json:"applied_at"`
}

type Webhook struct {
	ID             int64          `json:"id"`
	Name           string         `json:"name"`
	Url            string         `json:"url"`
	Secret         sql.NullString `json:"secret"`
	Enabled        sql.NullBool   `json:"enabled"`
	Events         string         `json:"events"`
	Headers        sql.NullString `json:"headers"`
	TimeoutSeconds sql.NullInt64  `json:"timeout_seconds"`
	RetryAttempts  sql.NullInt64  `json:"retry_attempts"`
	CreatedBy      int64          `json:"created_by"`
	CreatedAt      sql.NullTime   `json:"created_at"`
	UpdatedAt      sql.NullTime   `json:"updated_at"`
}

type WebhookDelivery struct {
	ID              int64          `json:"id"`
	WebhookID       int64          `json:"webhook_id"`
	EventType       string         `json:"event_type"`
	Payload         string         `json:"payload"`
	Status          string         `json:"status"`
	HttpStatusCode  sql.NullInt64  `json:"http_status_code"`
	ResponseBody    sql.NullString `json:"response_body"`
	ResponseHeaders sql.NullString `json:"response_headers"`
	ErrorMessage    sql.NullString `json:"error_message"`
	AttemptCount    sql.NullInt64  `json:"attempt_count"`
	LastAttemptAt   sql.NullTime   `json:"last_attempt_at"`
	NextRetryAt     sql.NullTime   `json:"next_retry_at"`
	DeliveredAt     sql.NullTime   `json:"delivered_at"`
	CreatedAt       sql.NullTime   `json:"created_at"`
}
