// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: models.sql

package queries

import (
	"context"
	"database/sql"
)

const createModel = `-- name: CreateModel :one
INSERT INTO models (
    provider_id, model_id, name, context_size, max_tokens, supports_tools, input_cost, output_cost, enabled
) VALUES (
    ?, ?, ?, ?, ?, ?, ?, ?, ?
) RETURNING id, provider_id, model_id, name, context_size, max_tokens, supports_tools, input_cost, output_cost, enabled, created_at, updated_at
`

type CreateModelParams struct {
	ProviderID    int64           `json:"provider_id"`
	ModelID       string          `json:"model_id"`
	Name          string          `json:"name"`
	ContextSize   int64           `json:"context_size"`
	MaxTokens     int64           `json:"max_tokens"`
	SupportsTools sql.NullBool    `json:"supports_tools"`
	InputCost     sql.NullFloat64 `json:"input_cost"`
	OutputCost    sql.NullFloat64 `json:"output_cost"`
	Enabled       sql.NullBool    `json:"enabled"`
}

func (q *Queries) CreateModel(ctx context.Context, arg CreateModelParams) (Model, error) {
	row := q.db.QueryRowContext(ctx, createModel,
		arg.ProviderID,
		arg.ModelID,
		arg.Name,
		arg.ContextSize,
		arg.MaxTokens,
		arg.SupportsTools,
		arg.InputCost,
		arg.OutputCost,
		arg.Enabled,
	)
	var i Model
	err := row.Scan(
		&i.ID,
		&i.ProviderID,
		&i.ModelID,
		&i.Name,
		&i.ContextSize,
		&i.MaxTokens,
		&i.SupportsTools,
		&i.InputCost,
		&i.OutputCost,
		&i.Enabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteModel = `-- name: DeleteModel :exec
DELETE FROM models WHERE id = ?
`

func (q *Queries) DeleteModel(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteModel, id)
	return err
}

const deleteModelsByProvider = `-- name: DeleteModelsByProvider :exec
DELETE FROM models WHERE provider_id = ?
`

func (q *Queries) DeleteModelsByProvider(ctx context.Context, providerID int64) error {
	_, err := q.db.ExecContext(ctx, deleteModelsByProvider, providerID)
	return err
}

const getModel = `-- name: GetModel :one
SELECT id, provider_id, model_id, name, context_size, max_tokens, supports_tools, input_cost, output_cost, enabled, created_at, updated_at FROM models WHERE id = ?
`

func (q *Queries) GetModel(ctx context.Context, id int64) (Model, error) {
	row := q.db.QueryRowContext(ctx, getModel, id)
	var i Model
	err := row.Scan(
		&i.ID,
		&i.ProviderID,
		&i.ModelID,
		&i.Name,
		&i.ContextSize,
		&i.MaxTokens,
		&i.SupportsTools,
		&i.InputCost,
		&i.OutputCost,
		&i.Enabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getModelByProviderAndModelID = `-- name: GetModelByProviderAndModelID :one
SELECT id, provider_id, model_id, name, context_size, max_tokens, supports_tools, input_cost, output_cost, enabled, created_at, updated_at FROM models WHERE provider_id = ? AND model_id = ?
`

type GetModelByProviderAndModelIDParams struct {
	ProviderID int64  `json:"provider_id"`
	ModelID    string `json:"model_id"`
}

func (q *Queries) GetModelByProviderAndModelID(ctx context.Context, arg GetModelByProviderAndModelIDParams) (Model, error) {
	row := q.db.QueryRowContext(ctx, getModelByProviderAndModelID, arg.ProviderID, arg.ModelID)
	var i Model
	err := row.Scan(
		&i.ID,
		&i.ProviderID,
		&i.ModelID,
		&i.Name,
		&i.ContextSize,
		&i.MaxTokens,
		&i.SupportsTools,
		&i.InputCost,
		&i.OutputCost,
		&i.Enabled,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const listEnabledModels = `-- name: ListEnabledModels :many
SELECT m.id, m.provider_id, m.model_id, m.name, m.context_size, m.max_tokens, m.supports_tools, m.input_cost, m.output_cost, m.enabled, m.created_at, m.updated_at, mp.name as provider_name, mp.display_name as provider_display_name
FROM models m
JOIN model_providers mp ON m.provider_id = mp.id
WHERE m.enabled = true AND mp.enabled = true
ORDER BY mp.name, m.name
`

type ListEnabledModelsRow struct {
	ID                  int64           `json:"id"`
	ProviderID          int64           `json:"provider_id"`
	ModelID             string          `json:"model_id"`
	Name                string          `json:"name"`
	ContextSize         int64           `json:"context_size"`
	MaxTokens           int64           `json:"max_tokens"`
	SupportsTools       sql.NullBool    `json:"supports_tools"`
	InputCost           sql.NullFloat64 `json:"input_cost"`
	OutputCost          sql.NullFloat64 `json:"output_cost"`
	Enabled             sql.NullBool    `json:"enabled"`
	CreatedAt           sql.NullTime    `json:"created_at"`
	UpdatedAt           sql.NullTime    `json:"updated_at"`
	ProviderName        string          `json:"provider_name"`
	ProviderDisplayName string          `json:"provider_display_name"`
}

func (q *Queries) ListEnabledModels(ctx context.Context) ([]ListEnabledModelsRow, error) {
	rows, err := q.db.QueryContext(ctx, listEnabledModels)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListEnabledModelsRow
	for rows.Next() {
		var i ListEnabledModelsRow
		if err := rows.Scan(
			&i.ID,
			&i.ProviderID,
			&i.ModelID,
			&i.Name,
			&i.ContextSize,
			&i.MaxTokens,
			&i.SupportsTools,
			&i.InputCost,
			&i.OutputCost,
			&i.Enabled,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.ProviderName,
			&i.ProviderDisplayName,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listModels = `-- name: ListModels :many
SELECT m.id, m.provider_id, m.model_id, m.name, m.context_size, m.max_tokens, m.supports_tools, m.input_cost, m.output_cost, m.enabled, m.created_at, m.updated_at, mp.name as provider_name, mp.display_name as provider_display_name
FROM models m
JOIN model_providers mp ON m.provider_id = mp.id
ORDER BY mp.name, m.name
`

type ListModelsRow struct {
	ID                  int64           `json:"id"`
	ProviderID          int64           `json:"provider_id"`
	ModelID             string          `json:"model_id"`
	Name                string          `json:"name"`
	ContextSize         int64           `json:"context_size"`
	MaxTokens           int64           `json:"max_tokens"`
	SupportsTools       sql.NullBool    `json:"supports_tools"`
	InputCost           sql.NullFloat64 `json:"input_cost"`
	OutputCost          sql.NullFloat64 `json:"output_cost"`
	Enabled             sql.NullBool    `json:"enabled"`
	CreatedAt           sql.NullTime    `json:"created_at"`
	UpdatedAt           sql.NullTime    `json:"updated_at"`
	ProviderName        string          `json:"provider_name"`
	ProviderDisplayName string          `json:"provider_display_name"`
}

func (q *Queries) ListModels(ctx context.Context) ([]ListModelsRow, error) {
	rows, err := q.db.QueryContext(ctx, listModels)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListModelsRow
	for rows.Next() {
		var i ListModelsRow
		if err := rows.Scan(
			&i.ID,
			&i.ProviderID,
			&i.ModelID,
			&i.Name,
			&i.ContextSize,
			&i.MaxTokens,
			&i.SupportsTools,
			&i.InputCost,
			&i.OutputCost,
			&i.Enabled,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.ProviderName,
			&i.ProviderDisplayName,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listModelsByProvider = `-- name: ListModelsByProvider :many
SELECT id, provider_id, model_id, name, context_size, max_tokens, supports_tools, input_cost, output_cost, enabled, created_at, updated_at FROM models WHERE provider_id = ? ORDER BY name
`

func (q *Queries) ListModelsByProvider(ctx context.Context, providerID int64) ([]Model, error) {
	rows, err := q.db.QueryContext(ctx, listModelsByProvider, providerID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Model
	for rows.Next() {
		var i Model
		if err := rows.Scan(
			&i.ID,
			&i.ProviderID,
			&i.ModelID,
			&i.Name,
			&i.ContextSize,
			&i.MaxTokens,
			&i.SupportsTools,
			&i.InputCost,
			&i.OutputCost,
			&i.Enabled,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listToolSupportingModels = `-- name: ListToolSupportingModels :many
SELECT m.id, m.provider_id, m.model_id, m.name, m.context_size, m.max_tokens, m.supports_tools, m.input_cost, m.output_cost, m.enabled, m.created_at, m.updated_at, mp.name as provider_name, mp.display_name as provider_display_name
FROM models m
JOIN model_providers mp ON m.provider_id = mp.id
WHERE m.supports_tools = true AND m.enabled = true AND mp.enabled = true
ORDER BY mp.name, m.name
`

type ListToolSupportingModelsRow struct {
	ID                  int64           `json:"id"`
	ProviderID          int64           `json:"provider_id"`
	ModelID             string          `json:"model_id"`
	Name                string          `json:"name"`
	ContextSize         int64           `json:"context_size"`
	MaxTokens           int64           `json:"max_tokens"`
	SupportsTools       sql.NullBool    `json:"supports_tools"`
	InputCost           sql.NullFloat64 `json:"input_cost"`
	OutputCost          sql.NullFloat64 `json:"output_cost"`
	Enabled             sql.NullBool    `json:"enabled"`
	CreatedAt           sql.NullTime    `json:"created_at"`
	UpdatedAt           sql.NullTime    `json:"updated_at"`
	ProviderName        string          `json:"provider_name"`
	ProviderDisplayName string          `json:"provider_display_name"`
}

func (q *Queries) ListToolSupportingModels(ctx context.Context) ([]ListToolSupportingModelsRow, error) {
	rows, err := q.db.QueryContext(ctx, listToolSupportingModels)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ListToolSupportingModelsRow
	for rows.Next() {
		var i ListToolSupportingModelsRow
		if err := rows.Scan(
			&i.ID,
			&i.ProviderID,
			&i.ModelID,
			&i.Name,
			&i.ContextSize,
			&i.MaxTokens,
			&i.SupportsTools,
			&i.InputCost,
			&i.OutputCost,
			&i.Enabled,
			&i.CreatedAt,
			&i.UpdatedAt,
			&i.ProviderName,
			&i.ProviderDisplayName,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateModel = `-- name: UpdateModel :exec
UPDATE models 
SET name = ?, context_size = ?, max_tokens = ?, supports_tools = ?, input_cost = ?, output_cost = ?, enabled = ?, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
`

type UpdateModelParams struct {
	Name          string          `json:"name"`
	ContextSize   int64           `json:"context_size"`
	MaxTokens     int64           `json:"max_tokens"`
	SupportsTools sql.NullBool    `json:"supports_tools"`
	InputCost     sql.NullFloat64 `json:"input_cost"`
	OutputCost    sql.NullFloat64 `json:"output_cost"`
	Enabled       sql.NullBool    `json:"enabled"`
	ID            int64           `json:"id"`
}

func (q *Queries) UpdateModel(ctx context.Context, arg UpdateModelParams) error {
	_, err := q.db.ExecContext(ctx, updateModel,
		arg.Name,
		arg.ContextSize,
		arg.MaxTokens,
		arg.SupportsTools,
		arg.InputCost,
		arg.OutputCost,
		arg.Enabled,
		arg.ID,
	)
	return err
}
