// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: settings.sql

package queries

import (
	"context"
	"database/sql"
)

const deleteSetting = `-- name: DeleteSetting :exec
DELETE FROM settings WHERE key = ?
`

func (q *Queries) DeleteSetting(ctx context.Context, key string) error {
	_, err := q.db.ExecContext(ctx, deleteSetting, key)
	return err
}

const getAllSettings = `-- name: GetAllSettings :many
SELECT id, "key", value, description, created_at, updated_at FROM settings ORDER BY key
`

func (q *Queries) GetAllSettings(ctx context.Context) ([]Setting, error) {
	rows, err := q.db.QueryContext(ctx, getAllSettings)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Setting
	for rows.Next() {
		var i Setting
		if err := rows.Scan(
			&i.ID,
			&i.Key,
			&i.Value,
			&i.Description,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getSetting = `-- name: GetSetting :one

SELECT id, "key", value, description, created_at, updated_at FROM settings WHERE key = ?
`

// Settings queries
func (q *Queries) GetSetting(ctx context.Context, key string) (Setting, error) {
	row := q.db.QueryRowContext(ctx, getSetting, key)
	var i Setting
	err := row.Scan(
		&i.ID,
		&i.Key,
		&i.Value,
		&i.Description,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const setSetting = `-- name: SetSetting :exec
INSERT INTO settings (key, value, description) 
VALUES (?, ?, ?)
ON CONFLICT(key) DO UPDATE SET
    value = excluded.value,
    updated_at = CURRENT_TIMESTAMP
`

type SetSettingParams struct {
	Key         string         `json:"key"`
	Value       string         `json:"value"`
	Description sql.NullString `json:"description"`
}

func (q *Queries) SetSetting(ctx context.Context, arg SetSettingParams) error {
	_, err := q.db.ExecContext(ctx, setSetting, arg.Key, arg.Value, arg.Description)
	return err
}
