// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: themes.sql

package queries

import (
	"context"
	"database/sql"
)

const createTheme = `-- name: CreateTheme :one
INSERT INTO themes (name, display_name, description, is_built_in, is_default, created_by)
VALUES (?, ?, ?, ?, ?, ?)
RETURNING id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at
`

type CreateThemeParams struct {
	Name        string         `json:"name"`
	DisplayName string         `json:"display_name"`
	Description sql.NullString `json:"description"`
	IsBuiltIn   sql.NullBool   `json:"is_built_in"`
	IsDefault   sql.NullBool   `json:"is_default"`
	CreatedBy   sql.NullInt64  `json:"created_by"`
}

func (q *Queries) CreateTheme(ctx context.Context, arg CreateThemeParams) (Theme, error) {
	row := q.db.QueryRowContext(ctx, createTheme,
		arg.Name,
		arg.DisplayName,
		arg.Description,
		arg.IsBuiltIn,
		arg.IsDefault,
		arg.CreatedBy,
	)
	var i Theme
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.Description,
		&i.IsBuiltIn,
		&i.IsDefault,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const createThemeColor = `-- name: CreateThemeColor :one
INSERT INTO theme_colors (theme_id, color_key, color_value, description)
VALUES (?, ?, ?, ?)
RETURNING id, theme_id, color_key, color_value, description
`

type CreateThemeColorParams struct {
	ThemeID     int64          `json:"theme_id"`
	ColorKey    string         `json:"color_key"`
	ColorValue  string         `json:"color_value"`
	Description sql.NullString `json:"description"`
}

func (q *Queries) CreateThemeColor(ctx context.Context, arg CreateThemeColorParams) (ThemeColor, error) {
	row := q.db.QueryRowContext(ctx, createThemeColor,
		arg.ThemeID,
		arg.ColorKey,
		arg.ColorValue,
		arg.Description,
	)
	var i ThemeColor
	err := row.Scan(
		&i.ID,
		&i.ThemeID,
		&i.ColorKey,
		&i.ColorValue,
		&i.Description,
	)
	return i, err
}

const deleteAllThemeColors = `-- name: DeleteAllThemeColors :exec
DELETE FROM theme_colors WHERE theme_id = ?
`

func (q *Queries) DeleteAllThemeColors(ctx context.Context, themeID int64) error {
	_, err := q.db.ExecContext(ctx, deleteAllThemeColors, themeID)
	return err
}

const deleteTheme = `-- name: DeleteTheme :exec
DELETE FROM themes WHERE id = ? AND is_built_in = FALSE
`

func (q *Queries) DeleteTheme(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteTheme, id)
	return err
}

const deleteThemeColor = `-- name: DeleteThemeColor :exec
DELETE FROM theme_colors WHERE theme_id = ? AND color_key = ?
`

type DeleteThemeColorParams struct {
	ThemeID  int64  `json:"theme_id"`
	ColorKey string `json:"color_key"`
}

func (q *Queries) DeleteThemeColor(ctx context.Context, arg DeleteThemeColorParams) error {
	_, err := q.db.ExecContext(ctx, deleteThemeColor, arg.ThemeID, arg.ColorKey)
	return err
}

const getDefaultTheme = `-- name: GetDefaultTheme :one
SELECT id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at FROM themes WHERE is_default = TRUE LIMIT 1
`

func (q *Queries) GetDefaultTheme(ctx context.Context) (Theme, error) {
	row := q.db.QueryRowContext(ctx, getDefaultTheme)
	var i Theme
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.Description,
		&i.IsBuiltIn,
		&i.IsDefault,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getDefaultThemeWithColors = `-- name: GetDefaultThemeWithColors :many
SELECT 
    t.id as theme_id,
    t.name as theme_name,
    t.display_name,
    t.description as theme_description,
    t.is_built_in,
    t.is_default,
    tc.color_key,
    tc.color_value,
    tc.description as color_description
FROM themes t
LEFT JOIN theme_colors tc ON t.id = tc.theme_id
WHERE t.is_default = TRUE
ORDER BY tc.color_key
`

type GetDefaultThemeWithColorsRow struct {
	ThemeID          int64          `json:"theme_id"`
	ThemeName        string         `json:"theme_name"`
	DisplayName      string         `json:"display_name"`
	ThemeDescription sql.NullString `json:"theme_description"`
	IsBuiltIn        sql.NullBool   `json:"is_built_in"`
	IsDefault        sql.NullBool   `json:"is_default"`
	ColorKey         sql.NullString `json:"color_key"`
	ColorValue       sql.NullString `json:"color_value"`
	ColorDescription sql.NullString `json:"color_description"`
}

func (q *Queries) GetDefaultThemeWithColors(ctx context.Context) ([]GetDefaultThemeWithColorsRow, error) {
	rows, err := q.db.QueryContext(ctx, getDefaultThemeWithColors)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetDefaultThemeWithColorsRow
	for rows.Next() {
		var i GetDefaultThemeWithColorsRow
		if err := rows.Scan(
			&i.ThemeID,
			&i.ThemeName,
			&i.DisplayName,
			&i.ThemeDescription,
			&i.IsBuiltIn,
			&i.IsDefault,
			&i.ColorKey,
			&i.ColorValue,
			&i.ColorDescription,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getTheme = `-- name: GetTheme :one
SELECT id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at FROM themes WHERE id = ?
`

func (q *Queries) GetTheme(ctx context.Context, id int64) (Theme, error) {
	row := q.db.QueryRowContext(ctx, getTheme, id)
	var i Theme
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.Description,
		&i.IsBuiltIn,
		&i.IsDefault,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getThemeByName = `-- name: GetThemeByName :one
SELECT id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at FROM themes WHERE name = ?
`

func (q *Queries) GetThemeByName(ctx context.Context, name string) (Theme, error) {
	row := q.db.QueryRowContext(ctx, getThemeByName, name)
	var i Theme
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.Description,
		&i.IsBuiltIn,
		&i.IsDefault,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getThemeColor = `-- name: GetThemeColor :one
SELECT id, theme_id, color_key, color_value, description FROM theme_colors WHERE theme_id = ? AND color_key = ?
`

type GetThemeColorParams struct {
	ThemeID  int64  `json:"theme_id"`
	ColorKey string `json:"color_key"`
}

func (q *Queries) GetThemeColor(ctx context.Context, arg GetThemeColorParams) (ThemeColor, error) {
	row := q.db.QueryRowContext(ctx, getThemeColor, arg.ThemeID, arg.ColorKey)
	var i ThemeColor
	err := row.Scan(
		&i.ID,
		&i.ThemeID,
		&i.ColorKey,
		&i.ColorValue,
		&i.Description,
	)
	return i, err
}

const getThemeColors = `-- name: GetThemeColors :many
SELECT id, theme_id, color_key, color_value, description FROM theme_colors WHERE theme_id = ? ORDER BY color_key
`

func (q *Queries) GetThemeColors(ctx context.Context, themeID int64) ([]ThemeColor, error) {
	rows, err := q.db.QueryContext(ctx, getThemeColors, themeID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []ThemeColor
	for rows.Next() {
		var i ThemeColor
		if err := rows.Scan(
			&i.ID,
			&i.ThemeID,
			&i.ColorKey,
			&i.ColorValue,
			&i.Description,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getUserTheme = `-- name: GetUserTheme :one
SELECT t.id, t.name, t.display_name, t.description, t.is_built_in, t.is_default, t.created_by, t.created_at, t.updated_at, utp.applied_at
FROM themes t
JOIN user_theme_preferences utp ON t.id = utp.theme_id
WHERE utp.user_id = ?
`

type GetUserThemeRow struct {
	ID          int64          `json:"id"`
	Name        string         `json:"name"`
	DisplayName string         `json:"display_name"`
	Description sql.NullString `json:"description"`
	IsBuiltIn   sql.NullBool   `json:"is_built_in"`
	IsDefault   sql.NullBool   `json:"is_default"`
	CreatedBy   sql.NullInt64  `json:"created_by"`
	CreatedAt   sql.NullTime   `json:"created_at"`
	UpdatedAt   sql.NullTime   `json:"updated_at"`
	AppliedAt   sql.NullTime   `json:"applied_at"`
}

func (q *Queries) GetUserTheme(ctx context.Context, userID int64) (GetUserThemeRow, error) {
	row := q.db.QueryRowContext(ctx, getUserTheme, userID)
	var i GetUserThemeRow
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.Description,
		&i.IsBuiltIn,
		&i.IsDefault,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
		&i.AppliedAt,
	)
	return i, err
}

const getUserThemeWithColors = `-- name: GetUserThemeWithColors :many
SELECT 
    t.id as theme_id,
    t.name as theme_name,
    t.display_name,
    t.description as theme_description,
    t.is_built_in,
    t.is_default,
    tc.color_key,
    tc.color_value,
    tc.description as color_description,
    utp.applied_at
FROM themes t
JOIN user_theme_preferences utp ON t.id = utp.theme_id
LEFT JOIN theme_colors tc ON t.id = tc.theme_id
WHERE utp.user_id = ?
ORDER BY tc.color_key
`

type GetUserThemeWithColorsRow struct {
	ThemeID          int64          `json:"theme_id"`
	ThemeName        string         `json:"theme_name"`
	DisplayName      string         `json:"display_name"`
	ThemeDescription sql.NullString `json:"theme_description"`
	IsBuiltIn        sql.NullBool   `json:"is_built_in"`
	IsDefault        sql.NullBool   `json:"is_default"`
	ColorKey         sql.NullString `json:"color_key"`
	ColorValue       sql.NullString `json:"color_value"`
	ColorDescription sql.NullString `json:"color_description"`
	AppliedAt        sql.NullTime   `json:"applied_at"`
}

func (q *Queries) GetUserThemeWithColors(ctx context.Context, userID int64) ([]GetUserThemeWithColorsRow, error) {
	rows, err := q.db.QueryContext(ctx, getUserThemeWithColors, userID)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetUserThemeWithColorsRow
	for rows.Next() {
		var i GetUserThemeWithColorsRow
		if err := rows.Scan(
			&i.ThemeID,
			&i.ThemeName,
			&i.DisplayName,
			&i.ThemeDescription,
			&i.IsBuiltIn,
			&i.IsDefault,
			&i.ColorKey,
			&i.ColorValue,
			&i.ColorDescription,
			&i.AppliedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listBuiltInThemes = `-- name: ListBuiltInThemes :many
SELECT id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at FROM themes WHERE is_built_in = TRUE ORDER BY display_name
`

func (q *Queries) ListBuiltInThemes(ctx context.Context) ([]Theme, error) {
	rows, err := q.db.QueryContext(ctx, listBuiltInThemes)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Theme
	for rows.Next() {
		var i Theme
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.DisplayName,
			&i.Description,
			&i.IsBuiltIn,
			&i.IsDefault,
			&i.CreatedBy,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listThemes = `-- name: ListThemes :many
SELECT id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at FROM themes ORDER BY is_default DESC, is_built_in DESC, display_name
`

func (q *Queries) ListThemes(ctx context.Context) ([]Theme, error) {
	rows, err := q.db.QueryContext(ctx, listThemes)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Theme
	for rows.Next() {
		var i Theme
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.DisplayName,
			&i.Description,
			&i.IsBuiltIn,
			&i.IsDefault,
			&i.CreatedBy,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const setDefaultTheme = `-- name: SetDefaultTheme :exec
UPDATE themes SET is_default = (id = ?)
`

func (q *Queries) SetDefaultTheme(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, setDefaultTheme, id)
	return err
}

const setUserTheme = `-- name: SetUserTheme :one
INSERT INTO user_theme_preferences (user_id, theme_id)
VALUES (?, ?)
ON CONFLICT(user_id) DO UPDATE SET
    theme_id = excluded.theme_id,
    applied_at = CURRENT_TIMESTAMP
RETURNING id, user_id, theme_id, applied_at
`

type SetUserThemeParams struct {
	UserID  int64 `json:"user_id"`
	ThemeID int64 `json:"theme_id"`
}

func (q *Queries) SetUserTheme(ctx context.Context, arg SetUserThemeParams) (UserThemePreference, error) {
	row := q.db.QueryRowContext(ctx, setUserTheme, arg.UserID, arg.ThemeID)
	var i UserThemePreference
	err := row.Scan(
		&i.ID,
		&i.UserID,
		&i.ThemeID,
		&i.AppliedAt,
	)
	return i, err
}

const updateTheme = `-- name: UpdateTheme :one
UPDATE themes 
SET display_name = ?, description = ?, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
RETURNING id, name, display_name, description, is_built_in, is_default, created_by, created_at, updated_at
`

type UpdateThemeParams struct {
	DisplayName string         `json:"display_name"`
	Description sql.NullString `json:"description"`
	ID          int64          `json:"id"`
}

func (q *Queries) UpdateTheme(ctx context.Context, arg UpdateThemeParams) (Theme, error) {
	row := q.db.QueryRowContext(ctx, updateTheme, arg.DisplayName, arg.Description, arg.ID)
	var i Theme
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.DisplayName,
		&i.Description,
		&i.IsBuiltIn,
		&i.IsDefault,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const updateThemeColor = `-- name: UpdateThemeColor :one
UPDATE theme_colors 
SET color_value = ?, description = ?
WHERE theme_id = ? AND color_key = ?
RETURNING id, theme_id, color_key, color_value, description
`

type UpdateThemeColorParams struct {
	ColorValue  string         `json:"color_value"`
	Description sql.NullString `json:"description"`
	ThemeID     int64          `json:"theme_id"`
	ColorKey    string         `json:"color_key"`
}

func (q *Queries) UpdateThemeColor(ctx context.Context, arg UpdateThemeColorParams) (ThemeColor, error) {
	row := q.db.QueryRowContext(ctx, updateThemeColor,
		arg.ColorValue,
		arg.Description,
		arg.ThemeID,
		arg.ColorKey,
	)
	var i ThemeColor
	err := row.Scan(
		&i.ID,
		&i.ThemeID,
		&i.ColorKey,
		&i.ColorValue,
		&i.Description,
	)
	return i, err
}
