// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: users.sql

package queries

import (
	"context"
	"database/sql"
)

const createUser = `-- name: CreateUser :one
INSERT INTO users (username, public_key, is_admin, api_key)
VALUES (?, ?, ?, ?)
RETURNING id, username, public_key, is_admin, api_key, created_at, updated_at
`

type CreateUserParams struct {
	Username  string         `json:"username"`
	PublicKey string         `json:"public_key"`
	IsAdmin   bool           `json:"is_admin"`
	ApiKey    sql.NullString `json:"api_key"`
}

func (q *Queries) CreateUser(ctx context.Context, arg CreateUserParams) (User, error) {
	row := q.db.QueryRowContext(ctx, createUser,
		arg.Username,
		arg.PublicKey,
		arg.IsAdmin,
		arg.ApiKey,
	)
	var i User
	err := row.Scan(
		&i.ID,
		&i.Username,
		&i.PublicKey,
		&i.IsAdmin,
		&i.ApiKey,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteUser = `-- name: DeleteUser :exec
DELETE FROM users WHERE id = ?
`

func (q *Queries) DeleteUser(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteUser, id)
	return err
}

const getUser = `-- name: GetUser :one
SELECT id, username, public_key, is_admin, api_key, created_at, updated_at FROM users WHERE id = ?
`

func (q *Queries) GetUser(ctx context.Context, id int64) (User, error) {
	row := q.db.QueryRowContext(ctx, getUser, id)
	var i User
	err := row.Scan(
		&i.ID,
		&i.Username,
		&i.PublicKey,
		&i.IsAdmin,
		&i.ApiKey,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getUserByAPIKey = `-- name: GetUserByAPIKey :one
SELECT id, username, public_key, is_admin, api_key, created_at, updated_at FROM users WHERE api_key = ?
`

func (q *Queries) GetUserByAPIKey(ctx context.Context, apiKey sql.NullString) (User, error) {
	row := q.db.QueryRowContext(ctx, getUserByAPIKey, apiKey)
	var i User
	err := row.Scan(
		&i.ID,
		&i.Username,
		&i.PublicKey,
		&i.IsAdmin,
		&i.ApiKey,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getUserByUsername = `-- name: GetUserByUsername :one
SELECT id, username, public_key, is_admin, api_key, created_at, updated_at FROM users WHERE username = ?
`

func (q *Queries) GetUserByUsername(ctx context.Context, username string) (User, error) {
	row := q.db.QueryRowContext(ctx, getUserByUsername, username)
	var i User
	err := row.Scan(
		&i.ID,
		&i.Username,
		&i.PublicKey,
		&i.IsAdmin,
		&i.ApiKey,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const listUsers = `-- name: ListUsers :many
SELECT id, username, public_key, is_admin, api_key, created_at, updated_at FROM users ORDER BY username
`

func (q *Queries) ListUsers(ctx context.Context) ([]User, error) {
	rows, err := q.db.QueryContext(ctx, listUsers)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []User
	for rows.Next() {
		var i User
		if err := rows.Scan(
			&i.ID,
			&i.Username,
			&i.PublicKey,
			&i.IsAdmin,
			&i.ApiKey,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateUser = `-- name: UpdateUser :exec
UPDATE users SET username = ?, is_admin = ? WHERE id = ?
`

type UpdateUserParams struct {
	Username string `json:"username"`
	IsAdmin  bool   `json:"is_admin"`
	ID       int64  `json:"id"`
}

func (q *Queries) UpdateUser(ctx context.Context, arg UpdateUserParams) error {
	_, err := q.db.ExecContext(ctx, updateUser, arg.Username, arg.IsAdmin, arg.ID)
	return err
}

const updateUserAPIKey = `-- name: UpdateUserAPIKey :exec
UPDATE users SET api_key = ? WHERE id = ?
`

type UpdateUserAPIKeyParams struct {
	ApiKey sql.NullString `json:"api_key"`
	ID     int64          `json:"id"`
}

func (q *Queries) UpdateUserAPIKey(ctx context.Context, arg UpdateUserAPIKeyParams) error {
	_, err := q.db.ExecContext(ctx, updateUserAPIKey, arg.ApiKey, arg.ID)
	return err
}
