// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.29.0
// source: webhooks.sql

package queries

import (
	"context"
	"database/sql"
)

const createWebhook = `-- name: CreateWebhook :one

INSERT INTO webhooks (name, url, secret, enabled, events, headers, timeout_seconds, retry_attempts, created_by)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
RETURNING id, name, url, secret, enabled, events, headers, timeout_seconds, retry_attempts, created_by, created_at, updated_at
`

type CreateWebhookParams struct {
	Name           string         `json:"name"`
	Url            string         `json:"url"`
	Secret         sql.NullString `json:"secret"`
	Enabled        sql.NullBool   `json:"enabled"`
	Events         string         `json:"events"`
	Headers        sql.NullString `json:"headers"`
	TimeoutSeconds sql.NullInt64  `json:"timeout_seconds"`
	RetryAttempts  sql.NullInt64  `json:"retry_attempts"`
	CreatedBy      int64          `json:"created_by"`
}

// Webhook queries
func (q *Queries) CreateWebhook(ctx context.Context, arg CreateWebhookParams) (Webhook, error) {
	row := q.db.QueryRowContext(ctx, createWebhook,
		arg.Name,
		arg.Url,
		arg.Secret,
		arg.Enabled,
		arg.Events,
		arg.Headers,
		arg.TimeoutSeconds,
		arg.RetryAttempts,
		arg.CreatedBy,
	)
	var i Webhook
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Url,
		&i.Secret,
		&i.Enabled,
		&i.Events,
		&i.Headers,
		&i.TimeoutSeconds,
		&i.RetryAttempts,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const deleteWebhook = `-- name: DeleteWebhook :exec
DELETE FROM webhooks WHERE id = ?
`

func (q *Queries) DeleteWebhook(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, deleteWebhook, id)
	return err
}

const disableWebhook = `-- name: DisableWebhook :exec
UPDATE webhooks SET enabled = FALSE, updated_at = CURRENT_TIMESTAMP WHERE id = ?
`

func (q *Queries) DisableWebhook(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, disableWebhook, id)
	return err
}

const enableWebhook = `-- name: EnableWebhook :exec
UPDATE webhooks SET enabled = TRUE, updated_at = CURRENT_TIMESTAMP WHERE id = ?
`

func (q *Queries) EnableWebhook(ctx context.Context, id int64) error {
	_, err := q.db.ExecContext(ctx, enableWebhook, id)
	return err
}

const getWebhook = `-- name: GetWebhook :one
SELECT id, name, url, secret, enabled, events, headers, timeout_seconds, retry_attempts, created_by, created_at, updated_at FROM webhooks WHERE id = ?
`

func (q *Queries) GetWebhook(ctx context.Context, id int64) (Webhook, error) {
	row := q.db.QueryRowContext(ctx, getWebhook, id)
	var i Webhook
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Url,
		&i.Secret,
		&i.Enabled,
		&i.Events,
		&i.Headers,
		&i.TimeoutSeconds,
		&i.RetryAttempts,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const getWebhookByName = `-- name: GetWebhookByName :one
SELECT id, name, url, secret, enabled, events, headers, timeout_seconds, retry_attempts, created_by, created_at, updated_at FROM webhooks WHERE name = ?
`

func (q *Queries) GetWebhookByName(ctx context.Context, name string) (Webhook, error) {
	row := q.db.QueryRowContext(ctx, getWebhookByName, name)
	var i Webhook
	err := row.Scan(
		&i.ID,
		&i.Name,
		&i.Url,
		&i.Secret,
		&i.Enabled,
		&i.Events,
		&i.Headers,
		&i.TimeoutSeconds,
		&i.RetryAttempts,
		&i.CreatedBy,
		&i.CreatedAt,
		&i.UpdatedAt,
	)
	return i, err
}

const listEnabledWebhooks = `-- name: ListEnabledWebhooks :many
SELECT id, name, url, secret, enabled, events, headers, timeout_seconds, retry_attempts, created_by, created_at, updated_at FROM webhooks WHERE enabled = TRUE ORDER BY created_at DESC
`

func (q *Queries) ListEnabledWebhooks(ctx context.Context) ([]Webhook, error) {
	rows, err := q.db.QueryContext(ctx, listEnabledWebhooks)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Webhook
	for rows.Next() {
		var i Webhook
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Url,
			&i.Secret,
			&i.Enabled,
			&i.Events,
			&i.Headers,
			&i.TimeoutSeconds,
			&i.RetryAttempts,
			&i.CreatedBy,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const listWebhooks = `-- name: ListWebhooks :many
SELECT id, name, url, secret, enabled, events, headers, timeout_seconds, retry_attempts, created_by, created_at, updated_at FROM webhooks ORDER BY created_at DESC
`

func (q *Queries) ListWebhooks(ctx context.Context) ([]Webhook, error) {
	rows, err := q.db.QueryContext(ctx, listWebhooks)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []Webhook
	for rows.Next() {
		var i Webhook
		if err := rows.Scan(
			&i.ID,
			&i.Name,
			&i.Url,
			&i.Secret,
			&i.Enabled,
			&i.Events,
			&i.Headers,
			&i.TimeoutSeconds,
			&i.RetryAttempts,
			&i.CreatedBy,
			&i.CreatedAt,
			&i.UpdatedAt,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Close(); err != nil {
		return nil, err
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const updateWebhook = `-- name: UpdateWebhook :exec
UPDATE webhooks 
SET name = ?, url = ?, secret = ?, enabled = ?, events = ?, headers = ?, 
    timeout_seconds = ?, retry_attempts = ?, updated_at = CURRENT_TIMESTAMP
WHERE id = ?
`

type UpdateWebhookParams struct {
	Name           string         `json:"name"`
	Url            string         `json:"url"`
	Secret         sql.NullString `json:"secret"`
	Enabled        sql.NullBool   `json:"enabled"`
	Events         string         `json:"events"`
	Headers        sql.NullString `json:"headers"`
	TimeoutSeconds sql.NullInt64  `json:"timeout_seconds"`
	RetryAttempts  sql.NullInt64  `json:"retry_attempts"`
	ID             int64          `json:"id"`
}

func (q *Queries) UpdateWebhook(ctx context.Context, arg UpdateWebhookParams) error {
	_, err := q.db.ExecContext(ctx, updateWebhook,
		arg.Name,
		arg.Url,
		arg.Secret,
		arg.Enabled,
		arg.Events,
		arg.Headers,
		arg.TimeoutSeconds,
		arg.RetryAttempts,
		arg.ID,
	)
	return err
}
