// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.12.4
// source: internal/lighthouse/proto/data_ingestion.proto

package proto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	DataIngestionService_IngestData_FullMethodName         = "/lighthouse.v1.DataIngestionService/IngestData"
	DataIngestionService_IngestBatch_FullMethodName        = "/lighthouse.v1.DataIngestionService/IngestBatch"
	DataIngestionService_IngestStream_FullMethodName       = "/lighthouse.v1.DataIngestionService/IngestStream"
	DataIngestionService_GetIngestionStatus_FullMethodName = "/lighthouse.v1.DataIngestionService/GetIngestionStatus"
)

// DataIngestionServiceClient is the client API for DataIngestionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataIngestionServiceClient interface {
	// Single record ingestion
	IngestData(ctx context.Context, in *IngestDataRequest, opts ...grpc.CallOption) (*IngestDataResponse, error)
	// Batch ingestion for high-throughput scenarios
	IngestBatch(ctx context.Context, in *IngestBatchRequest, opts ...grpc.CallOption) (*IngestBatchResponse, error)
	// Streaming ingestion for real-time data
	IngestStream(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[IngestDataRequest, IngestDataResponse], error)
	// Get ingestion status and metrics
	GetIngestionStatus(ctx context.Context, in *IngestionStatusRequest, opts ...grpc.CallOption) (*IngestionStatusResponse, error)
}

type dataIngestionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataIngestionServiceClient(cc grpc.ClientConnInterface) DataIngestionServiceClient {
	return &dataIngestionServiceClient{cc}
}

func (c *dataIngestionServiceClient) IngestData(ctx context.Context, in *IngestDataRequest, opts ...grpc.CallOption) (*IngestDataResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IngestDataResponse)
	err := c.cc.Invoke(ctx, DataIngestionService_IngestData_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataIngestionServiceClient) IngestBatch(ctx context.Context, in *IngestBatchRequest, opts ...grpc.CallOption) (*IngestBatchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IngestBatchResponse)
	err := c.cc.Invoke(ctx, DataIngestionService_IngestBatch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataIngestionServiceClient) IngestStream(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[IngestDataRequest, IngestDataResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &DataIngestionService_ServiceDesc.Streams[0], DataIngestionService_IngestStream_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[IngestDataRequest, IngestDataResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type DataIngestionService_IngestStreamClient = grpc.BidiStreamingClient[IngestDataRequest, IngestDataResponse]

func (c *dataIngestionServiceClient) GetIngestionStatus(ctx context.Context, in *IngestionStatusRequest, opts ...grpc.CallOption) (*IngestionStatusResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IngestionStatusResponse)
	err := c.cc.Invoke(ctx, DataIngestionService_GetIngestionStatus_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataIngestionServiceServer is the server API for DataIngestionService service.
// All implementations must embed UnimplementedDataIngestionServiceServer
// for forward compatibility.
type DataIngestionServiceServer interface {
	// Single record ingestion
	IngestData(context.Context, *IngestDataRequest) (*IngestDataResponse, error)
	// Batch ingestion for high-throughput scenarios
	IngestBatch(context.Context, *IngestBatchRequest) (*IngestBatchResponse, error)
	// Streaming ingestion for real-time data
	IngestStream(grpc.BidiStreamingServer[IngestDataRequest, IngestDataResponse]) error
	// Get ingestion status and metrics
	GetIngestionStatus(context.Context, *IngestionStatusRequest) (*IngestionStatusResponse, error)
	mustEmbedUnimplementedDataIngestionServiceServer()
}

// UnimplementedDataIngestionServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedDataIngestionServiceServer struct{}

func (UnimplementedDataIngestionServiceServer) IngestData(context.Context, *IngestDataRequest) (*IngestDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IngestData not implemented")
}
func (UnimplementedDataIngestionServiceServer) IngestBatch(context.Context, *IngestBatchRequest) (*IngestBatchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IngestBatch not implemented")
}
func (UnimplementedDataIngestionServiceServer) IngestStream(grpc.BidiStreamingServer[IngestDataRequest, IngestDataResponse]) error {
	return status.Errorf(codes.Unimplemented, "method IngestStream not implemented")
}
func (UnimplementedDataIngestionServiceServer) GetIngestionStatus(context.Context, *IngestionStatusRequest) (*IngestionStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIngestionStatus not implemented")
}
func (UnimplementedDataIngestionServiceServer) mustEmbedUnimplementedDataIngestionServiceServer() {}
func (UnimplementedDataIngestionServiceServer) testEmbeddedByValue()                              {}

// UnsafeDataIngestionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataIngestionServiceServer will
// result in compilation errors.
type UnsafeDataIngestionServiceServer interface {
	mustEmbedUnimplementedDataIngestionServiceServer()
}

func RegisterDataIngestionServiceServer(s grpc.ServiceRegistrar, srv DataIngestionServiceServer) {
	// If the following call pancis, it indicates UnimplementedDataIngestionServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&DataIngestionService_ServiceDesc, srv)
}

func _DataIngestionService_IngestData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataIngestionServiceServer).IngestData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataIngestionService_IngestData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataIngestionServiceServer).IngestData(ctx, req.(*IngestDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataIngestionService_IngestBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataIngestionServiceServer).IngestBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataIngestionService_IngestBatch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataIngestionServiceServer).IngestBatch(ctx, req.(*IngestBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataIngestionService_IngestStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(DataIngestionServiceServer).IngestStream(&grpc.GenericServerStream[IngestDataRequest, IngestDataResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type DataIngestionService_IngestStreamServer = grpc.BidiStreamingServer[IngestDataRequest, IngestDataResponse]

func _DataIngestionService_GetIngestionStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IngestionStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataIngestionServiceServer).GetIngestionStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataIngestionService_GetIngestionStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataIngestionServiceServer).GetIngestionStatus(ctx, req.(*IngestionStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataIngestionService_ServiceDesc is the grpc.ServiceDesc for DataIngestionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataIngestionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "lighthouse.v1.DataIngestionService",
	HandlerType: (*DataIngestionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "IngestData",
			Handler:    _DataIngestionService_IngestData_Handler,
		},
		{
			MethodName: "IngestBatch",
			Handler:    _DataIngestionService_IngestBatch_Handler,
		},
		{
			MethodName: "GetIngestionStatus",
			Handler:    _DataIngestionService_GetIngestionStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "IngestStream",
			Handler:       _DataIngestionService_IngestStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "internal/lighthouse/proto/data_ingestion.proto",
}
