# :tada: Contributing to Atom :tada:

These are just guidelines, not rules, use your best judgement and feel free
to propose changes to this document in a pull request.

## Issues
  * Include screenshots and animated GIFs whenever possible, they are immensely
    helpful.
  * Include the behavior you expected to happen and other places you've seen
    that behavior such as Emacs, vi, Xcode, etc.
  * Check the Console app for stack traces to include if reporting a crash.
  * Check the Dev tools (`alt-cmd-i`) for errors and stack traces to include.

### Package Repositories

This is the repository for the core Atom editor only. Atom comes bundled with
many packages and themes that are stored in other repos under the
[atom organization](https://github.com/atom) such as [tabs](https://github.com/atom/tabs),
[find-and-replace](https://github.com/atom/find-and-replace),
[language-javascript](https://github.com/atom/language-javascript),
and [atom-light-ui](http://github.com/atom/atom-light-ui).

If you think you know which package is causing the issue you are reporting, feel
free to open up the issue in that specific repository instead. When in doubt
just open the issue here but be aware that it may get closed here and reopened
in the proper package's repository.

## Pull Requests
  * Include screenshots and animated GIFs whenever possible.
  * Follow the [CoffeeScript](#coffeescript-styleguide),
    [JavaScript](https://github.com/styleguide/javascript),
    and [CSS](https://github.com/styleguide/css) styleguides
  * Include thoughtfully worded [Jasmine](http://pivotal.github.com/jasmine)
    specs
  * Avoid placing files in `vendor`. 3rd-party packages should be added as a
    `package.json` dependency.
  * Files end with a newline.
  * Requires should be in the following order:
    * Built in Node Modules (such as `path`)
    * Built in Atom and Atom Shell Modules (such as `atom`, `shell`)
    * Local Modules (using relative paths)
  * Class variables and methods should be in the following order:
    * Class methods (methods starting with a `@`)
    * Instance methods
  * Beware of platform differences
    * Use `require('atom').fs.getHomeDirectory()` to get the home directory.
    * Use `path.join()` to concatenate filenames.
    * Temporary directory is not `/tmp` on Windows, use `os.tmpdir()` when
      possible

## Git Commit Messages
  * Use the present tense
  * Reference issues and pull requests liberally
  * Consider starting the commit message with an applicable emoji:
    * :lipstick: when improving the format/structure of the code
    * :racehorse: when improving performance
    * :non-potable_water: when plugging memory leaks
    * :memo: when writing docs
    * :penguin: when fixing something on Linux

## CoffeeScript Styleguide

* Set parameter defaults without spaces around the equal sign
  * `clear = (count=1) ->` instead of `clear = (count = 1) ->`

## Documentation Styleguide

* Use [TomDoc](http://tomdoc.org).
* Use [Markdown](https://daringfireball.net/projects/markdown).
* Reference classes with `{ClassName}`.
* Reference instance methods with `{ClassName::methodName}`.
* Reference class methods with `{ClassName.methodName}`.
* Delegate to comments elsewhere with `{Delegates to: ClassName.methodName}`
  style notation.

### Example

```coffee
# Public: Disable the package with the given name.
#
# This method emits multiple events:
#
# * `package-will-be-disabled` - before the package is disabled.
# * `package-disabled`         - after the package is disabled.
#
# name     - The {String} name of the package to disable.
# options  - The {Object} with disable options (default: {}):
#   :trackTime - `true` to track the amount of time disabling took.
#   :ignoreErrors - `true` to catch and ignore errors thrown.
# callback - The {Function} to call after the package has been disabled.
#
# Returns `undefined`.
disablePackage: (name, options, callback) ->
```
