## Atom's View System

### SpacePen Basics

Atom's view system is built around the [SpacePen] view framework. SpacePen
view objects inherit from the jQuery prototype, and wrap DOM nodes

View objects are actually jQuery wrappers around DOM fragments, supporting all
the typical jQuery traversal and manipulation methods. In addition, view objects
have methods that are view-specific. For example, you could call both general
and view-specific on the global `atom.workspaceView` instance:

```coffeescript
atom.workspaceView.find('.editor.active') # standard jQuery method
atom.workspaceView.getActiveEditor()      # view-specific method
```

If you retrieve a jQuery wrapper for an element associated with a view, use the
`.view()` method to retrieve the element's view object:

```coffeescript
# this is a plain jQuery object; you can't call view-specific methods
editorElement = atom.workspaceView.find('.editor.active')

# get the view object by calling `.view()` to call view-specific methods
editorView = editorElement.view()
editorView.setCursorBufferPosition([1, 2])
```

Refer to the [SpacePen] documentation for more details.

### WorkspaceView

The root of Atom's view hierarchy is a global called `atom.workspaceView`, which is a
singleton instance of the `WorkspaceView` view class. The root view fills the entire
window, and contains every other view. If you open Atom's inspector with
`alt-cmd-i`, you can see the internal structure of `WorkspaceView`:

![WorkspaceView in the inspector][workspaceview-inspector]

#### Panes

The `WorkspaceView` contains `prependToBottom/Top/Left/Right` and
`appendToBottom/Top/Left/Right` methods, which are used to add Tool Panels. Tool
panels are elements that take up screen real estate not devoted to text editing.
In the example above, the `TreeView` is appended to the left, and the
`CommandPanel` is appended to the top.

```coffeescript
# place a view to the left of the panes
atom.workspaceView.appendToLeft(new MyView)

# place a view below the panes
atom.workspaceView.appendToBottom(new MyOtherView)
```

[spacepen]: http://github.com/nathansobo/space-pen
[workspaceView-inspector]: https://f.cloud.github.com/assets/1424/1091631/1932c2d6-166b-11e3-8adf-9690fe82d3b8.png
