# Getting Started

Welcome to Atom! This guide provides a quick introduction so you can be
productive as quickly as possible. There are also guides which cover
[configuring], [theming], and [extending] Atom.

## The Command Palette

If there's one key-command you remember in Atom, it should be `cmd-shift-P`. You
can always press `cmd-shift-P` to bring up a list of commands (and key bindings)
that are relevant to the currently focused interface element. This is a great
way to explore the system and learn key bindings interactively. For information
about adding or changing a key binding refer to the [customizing key
bindings][key-bindings] section.

![Command Palette]

## The Basics

### Working With Files

Atom windows are scoped to a single directory on disk. If you launch Atom from
the command line via the `atom` command and don't specify a path, Atom opens a
window for the current working directory. The current window's directory will be
visible as the root of the tree view on the left, and also serve as the context
for all file-related operations.

#### Finding Files

The fastest way to find a file is to use the fuzzy finder. Press `cmd-t` and
begin typing the name of the file you're looking for. If you are looking for a
file that is already open press `cmd-b` to bring up a searchable list of open
files. If you are using Git you can use `cmd-shift-b` to search the list of
files modified and untracked in your project's repository.

You can also use the tree view to navigate to a file. To open and focus the
the tree view, press `ctrl-0`. The tree view can be toggled open and closed with
`cmd-\`.

#### Adding, Moving, Deleting Files

You can add, move, and delete files and folders by right-clicking them in the
tree view and selecting the desired operation from the context menu. You can
also perform these operations from the keyboard by selecting a file or folder
and using `a` to add, `m` to move, and `delete` to delete.

### Searching

#### Find and Replace

To search within a buffer use `cmd-f`. To search the entire project use
`cmd-shift-f`.

#### Navigating By Symbols

To jump to a symbol such as a method definition, press `cmd-r`. This opens a
list of all symbols in the current file, which you can fuzzy filter similarly to
`cmd-t`.

To search for symbols across your project, use `cmd-shift-r`. First you'll need
to make sure you have `tags` (or `TAGS`) file generated for your project.
This can be done by installing [ctags](http://ctags.sourceforge.net/) and
running a command such as `ctags -R src/` from the command line in your
project's root directory. Using [Homebrew](http://brew.sh/)? Just run
`brew install ctags`.

You can customize how tags are generated by creating your own `.ctags` file
in your home directory (`~/.ctags`). Here is [a good example][ctags] to start
from.

### Split Panes

You can split any editor pane horizontally or vertically by using `cmd-k right`
or `cmd-k down`. Once you have a split pane, you can move focus between them
with `cmd-k cmd-right` or `cmd-k cmd-down`. To close a pane, close all its
editors with `cmd-w`, then press `cmd-w` one more time to close the pane. You
can configure panes to auto-close when empty in the Settings view.

### Folding

You can fold blocks of code by clicking the arrows that appear when you hover
your mouse cursor over the gutter. You can also fold and unfold from the
keyboard with `alt-cmd-[` and `alt-cmd-]`. To fold everything, use
`alt-cmd-shift-{` and to unfold everything use `alt-cmd-shift-}`. You can also
fold at a specific indentation level with `cmd-k cmd-N` where N is the
indentation depth.

### Soft-Wrap

If you want to toggle soft wrap, trigger the command from the command palette.
Press `cmd-shift-P` to open the palette, then type "wrap" to find the correct
command. By default, lines will wrap based on the size of the editor. If you
prefer to wrap at a specific line length, toggle "Wrap at preferred line length"
in preferences.

## Configuration

Press `cmd-,` to open the Settings view. This is the place to change settings,
install packages, and change the theme.

For more advanced configuration see the [customization guide][customization].

[configuring]: customizing-atom.md
[theming]: creating-a-theme.md
[extending]: creating-a-package.md
[customization]: customizing-atom.md
[key-bindings]: customizing-atom.md#customizing-key-bindings
[command palette]: https://f.cloud.github.com/assets/1424/1091618/ee7c3554-166a-11e3-9955-aaa61bb5509c.png
[ctags]: https://github.com/atom/symbols-view/blob/master/lib/.ctags
