---
name: Open Graph Image Generation
slug: og-image-generation
description: Compute and generate dynamic social card images with React components.
framework: Next.js
useCase: Edge Functions
css: Tailwind
deployUrl: https://vercel.com/new/clone?repository-url=https://github.com/vercel/examples/tree/main/edge-functions/vercel-og-nextjs&project-name=vercel-og-nextjs&repository-name=vercel-og-nextjs
demoUrl: https://og-image.trpc.io/api/_ref/static
relatedTemplates:
  - nextjs-boilerplate
  - aws-s3-image-upload-nextjs
  - platforms-starter-kit
  - blog-starter-kit
---

# Vercel OG + Next.js

```
pnpm dev
```

## Demo

- [tRPC dynamic OG-images](https://og-image.trpc.io)
- [Static Text](https://og-image.trpc.io/api/_ref/static)
- [Vercel Card](https://og-image.trpc.io/api/_ref/vercel)
- [Dynamic Text from URL Query](https://og-image.trpc.io/api/_ref/param)
- [Embed SVG Image](https://og-image.trpc.io/api/_ref/image-svg)
- [Dynamic PNG Image Based on URL Queries](https://og-image.trpc.io/api/_ref/dynamic-image?username=vercel)
- [Custom Font](https://og-image.trpc.io/api/_ref/custom-font)
- [Emoji](https://og-image.trpc.io/api/_ref/emoji)
- [Languages](https://og-image.trpc.io/api/_ref/language)
- [Encrypted Token](https://og-image.trpc.io/encrypted/a)
- [Tailwind](https://og-image.trpc.io/api/_ref/tailwind)

## How to Use

```
pnpm dev dev
```

Files in `pages/api/`, previews rendered on `pages/index`.
