# Rtts-Assert

A run-time type assertion library for JavaScript.
Designed to be used with [Traceur](https://github.com/google/traceur-compiler).

All sources are in ES6 format and have the suffix `.es6`. They don't depend on any runtime
and can be used by any modern ES6 -> ES5 transpiler.

As a convenience, we provide you with `es5build.js`, a script to transpile the sources into es5
using [Google Traceur](https://github.com/google/traceur-compiler/).

License: Apache MIT 2.0

## API

```
// Asserting APIs:
// - generated by Traceur (based on type annotations)
// - can be also used in tests for instance
assert.type(something, Type);
assert.returnType(returnValue, Type);
assert.argumentTypes(firstArg, Type, secondArg, Type);

// this can be used anywhere in the code
// (useful inside test, when we don't wanna define an interface)
assert(value).is(...)


// Custom type assert:
// - i have a custom type
// - adding an assert methos
assert.define(MyUser, function(value) {
  assert(value).is(Type, Type2); // or
  assert(value, 'name').is(assert.string);
  assert(value, 'contact').is(assert.structure({
    email: assert.string,
    cell: assert.string
  }));
  assert(value, 'contacts').is(assert.arrayOf(assert.structure({email: assert.string})));
});


// Define interface (an empty type with assert method)
// - returns an empty class with assert method
var Email = assert.define('IEmail', function(value) {
  assert(value).is(String);

  if (value.indexOf('@') !== -1) {
    assert.fail('has to contain "@"');
  }
});


// Predefined types
assert.string
assert.number
assert.boolean
assert.arrayOf(...types)
assert.structure(object)
```