use crate::{prelude::*, shared::erc20::ERC20};

pub struct HighCallDataTxGenerator {
    pub(crate) recipient_keys: KeyPool,
    pub(crate) tx_per_sender: usize,
    pub(crate) gas_limit: u64,
}

impl Generator for HighCallDataTxGenerator {
    fn handle_acct_group(
        &mut self,
        accts: &mut [SimpleAccount],
        ctx: &GenCtx,
    ) -> Vec<(TxEnvelope, Address)> {
        let mut txs = Vec::with_capacity(accts.len());

        for sender in accts {
            for _ in 0..self.tx_per_sender {
                let to = self.recipient_keys.next_addr();

                let tx = ERC20::deploy_tx_with_gas_limit(
                    sender.nonce,
                    &sender.key,
                    ctx.base_fee * 2,
                    ctx.chain_id,
                    self.gas_limit,
                );
                sender.nonce += 1;

                txs.push((tx, to));
            }
        }

        txs
    }
}
