//! This module contains low-level bindings to the monad execution client event types.

pub(crate) use self::bindings::{
    g_monad_exec_event_metadata_hash, MONAD_EXEC_ACCOUNT_ACCESS,
    MONAD_EXEC_ACCOUNT_ACCESS_LIST_HEADER, MONAD_EXEC_BLOCK_END, MONAD_EXEC_BLOCK_FINALIZED,
    MONAD_EXEC_BLOCK_PERF_EVM_ENTER, MONAD_EXEC_BLOCK_PERF_EVM_EXIT, MONAD_EXEC_BLOCK_QC,
    MONAD_EXEC_BLOCK_REJECT, MONAD_EXEC_BLOCK_START, MONAD_EXEC_BLOCK_VERIFIED,
    MONAD_EXEC_EVM_ERROR, MONAD_EXEC_NONE, MONAD_EXEC_STORAGE_ACCESS, MONAD_EXEC_TXN_CALL_FRAME,
    MONAD_EXEC_TXN_END, MONAD_EXEC_TXN_EVM_OUTPUT, MONAD_EXEC_TXN_LOG,
    MONAD_EXEC_TXN_PERF_EVM_ENTER, MONAD_EXEC_TXN_PERF_EVM_EXIT, MONAD_EXEC_TXN_REJECT,
    MONAD_EXEC_TXN_START, MONAD_FLOW_ACCOUNT_INDEX, MONAD_FLOW_BLOCK_SEQNO, MONAD_FLOW_TXN_ID,
};
pub use self::bindings::{
    monad_c_address, monad_c_bytes32, monad_c_eth_txn_header, monad_c_eth_txn_receipt,
    monad_exec_account_access, monad_exec_account_access_list_header, monad_exec_block_end,
    monad_exec_block_finalized, monad_exec_block_qc, monad_exec_block_reject,
    monad_exec_block_start, monad_exec_block_tag, monad_exec_block_verified, monad_exec_evm_error,
    monad_exec_storage_access, monad_exec_txn_call_frame, monad_exec_txn_evm_output,
    monad_exec_txn_log, monad_exec_txn_reject, monad_exec_txn_start, MONAD_TXN_EIP1559,
    MONAD_TXN_EIP2930, MONAD_TXN_LEGACY,
};

#[allow(dead_code, missing_docs, non_camel_case_types, non_upper_case_globals)]
mod bindings {
    include!(concat!(env!("OUT_DIR"), "/bindings.rs"));
}
