# Microsoft.Win32.SafeHandles

``` diff
+namespace Microsoft.Win32.SafeHandles {
+    public sealed class SafeAccessTokenHandle : SafeHandle {
+        public SafeAccessTokenHandle(IntPtr handle);
+        public static SafeAccessTokenHandle InvalidHandle { get; }
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public sealed class SafeFileHandle : SafeHandle {
+        public SafeFileHandle(IntPtr preexistingHandle, bool ownsHandle);
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public abstract class SafeHandleZeroOrMinusOneIsInvalid : SafeHandle {
+        public override bool IsInvalid { get; }
+    }
+    public sealed class SafeMemoryMappedFileHandle : SafeHandle {
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public sealed class SafeMemoryMappedViewHandle : SafeBuffer {
+        protected override bool ReleaseHandle();
+    }
+    public abstract class SafeNCryptHandle : SafeHandle {
+        protected SafeNCryptHandle();
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+        protected abstract bool ReleaseNativeHandle();
+    }
+    public sealed class SafeNCryptKeyHandle : SafeNCryptHandle {
+        public SafeNCryptKeyHandle();
+        protected override bool ReleaseNativeHandle();
+    }
+    public sealed class SafeNCryptProviderHandle : SafeNCryptHandle {
+        public SafeNCryptProviderHandle();
+        protected override bool ReleaseNativeHandle();
+    }
+    public sealed class SafeNCryptSecretHandle : SafeNCryptHandle {
+        public SafeNCryptSecretHandle();
+        protected override bool ReleaseNativeHandle();
+    }
+    public sealed class SafePipeHandle : SafeHandle {
+        public SafePipeHandle(IntPtr preexistingHandle, bool ownsHandle);
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public sealed class SafeProcessHandle : SafeHandle {
+        public SafeProcessHandle(IntPtr existingHandle, bool ownsHandle);
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public sealed class SafeRegistryHandle : SafeHandle {
+        public SafeRegistryHandle(IntPtr preexistingHandle, bool ownsHandle);
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public sealed class SafeWaitHandle : SafeHandle {
+        public SafeWaitHandle(IntPtr existingHandle, bool ownsHandle);
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+    public sealed class SafeX509ChainHandle : SafeHandle {
+        public override bool IsInvalid { get; }
+        protected override bool ReleaseHandle();
+    }
+}
```

