# .NET Core 1.0.14

.NET Core 1.0.14 comprises:

* .NET Core Runtime 1.0.14
* .NET Core SDK 1.1.12

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/1.0/1.0.14/1.0.14.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| Debian 8  | - | [x64][dotnet-dev-debian-x64.tar.gz] | - | [x64][dotnet-debian-x64.tar.gz]  | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz] | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz]  | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.12
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.0.14
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/1.0/1.0.14.md

[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49f8157c-f170-4e0e-88ab-20170f9f5354/3fe0e777d5953e2919e7ca0a78c08737/dotnet-centos-x64.1.0.14.tar.gz
[dotnet-debian-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf9005e0-2e04-45c5-95fb-617cd1cf23d2/7638479ba289bc6e78e7c4736216f106/dotnet-debian-x64.1.0.14.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/81e6d8a5-5329-40d9-adee-f2bdf518eab3/c02dd3e5bce79a6bc0cc05b600df49fb/dotnet-osx-x64.1.0.14.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b1ca4664-75db-447f-822d-8241076afd6d/38bfc95677b84ddf89b88076bc02e568/dotnet-osx-x64.1.0.14.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3f6427da-e6b8-4c94-a055-b20e8ace6015/d97b5a626b8f03c02006627409dddd42/dotnet-rhel-x64.1.0.14.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1282329b-86c2-46d9-82aa-eeb6f5fdd135/e761a40a16f208c081467249c6a43a5b/dotnet-ubuntu-x64.1.0.14.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c94db830-8ea2-4807-aca6-1fe9d24bdf5d/423d41f788a1ec4cc1d6fbbf1cde1cbf/dotnet-ubuntu.16.04-x64.1.0.14.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4d661b32-a0a0-4e41-a084-022bd1f4fa40/8c654372bf17758cdef09d0e456dad82/dotnet-win-x64.1.0.14.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/69253d46-3c91-4da3-baaf-8d73aecbc9b4/c19486707ad2f64cc54c547dcec1f665/dotnet-win-x64.1.0.14.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a8ba98bb-6f0e-4d5c-b8b7-693eeecf6682/6c5fb7ca98b20822d37cb7a7f8245563/dotnet-win-x86.1.0.14.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/07df6429-653d-40b6-8ca9-1ac057cb18f0/ece705a63186bf9178e2d558f98a1173/dotnet-win-x86.1.0.14.zip
[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/0cb4f123-a55d-4263-afe2-e54e5fdc1f0e/b9df261ef59d400872dd54107478f2b0/dotnetcore.1.0.14_1.1.11-windowshosting.exe
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7194a455-9b52-457a-8a59-15df325dd314/035a9b190cffb76b0447f4c0851b4501/dotnet-dev-centos-x64.1.1.12.tar.gz
[dotnet-dev-debian-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4f3687c-3f20-4280-9357-ffb18a607533/b41921e085d9f2c4cc6304b66d4497f7/dotnet-dev-debian-x64.1.1.12.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/51e5eb61-3058-4ab6-922d-e8e969def390/04dabb03b79b2aaf3382354dc503b381/dotnet-dev-fedora.27-x64.1.1.12.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4778b8e2-1433-4390-8498-d675b3b9b70f/173314e067b2d5b3c18855ccb7070376/dotnet-dev-fedora.28-x64.1.1.12.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3036d822-044e-4d0f-ad05-9ead0b5c8bd6/ce93aeae9417b0e1889333b9e74e5986/dotnet-dev-opensuse.42.3-x64.1.1.12.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7ebc7c42-4045-4519-8caa-2eee0b588408/29deb085fd7fce6ba40d49b6222c7373/dotnet-dev-osx-x64.1.1.12.pkg
[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e10916f-fee4-48af-9092-6b615c33fcb1/90d2ac564a9438263403a6d5f6591604/dotnet-dev-osx-x64.1.1.12.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0fc0ea1c-96d1-4f40-abc5-aa64d37d5cae/a2d14e0e163f467577d4ce2053390699/dotnet-dev-rhel-x64.1.1.12.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa54b546-688e-48d3-a768-d91bfec434c8/f7e2dfb770983cbd673e0ab461de779b/dotnet-dev-ubuntu-x64.1.1.12.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02e1b6f8-1fac-45b7-a23c-498a67b9a943/829bb9debbc78ccda8dbc2298ec2c942/dotnet-dev-ubuntu.16.04-x64.1.1.12.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8af1ce14-5e8a-4de3-b869-270bb76b31b4/8fe202de84b40a57bf7d4bd3f8e02de9/dotnet-dev-ubuntu.18.04-x64.1.1.12.tar.gz
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/483b1e47-f5e0-43c0-9a4b-6e5c6ec4f47c/e7c2bbc5d9ffbd2a1e2f0c572f2fbb57/dotnet-dev-win-x64.1.1.12.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cdb1d5fc-5bfb-466e-8339-226d57b3d111/3d29a36420acfd92990f5caec5371395/dotnet-dev-win-x64.1.1.12.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/483fb810-35ab-46eb-8e35-e841116de0a6/ceb9f9755897d735ee4e930b4198657b/dotnet-dev-win-x86.1.1.12.exe
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e9ac1c13-44b9-48ff-a607-ae7b888ad3b8/49bea32eca4b5d897bfc763f2176a3a9/dotnet-dev-win-x86.1.1.12.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/2d88de27-d102-41d7-aa7f-fb69bb6a078a/b91dfcdac292fb8104e454ca4e378699/core-setup-1.0.14-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/00d621df-0419-492c-bdf1-93942c76e756/d67f977b90c4ae4963f58b2feeee77c6/coreclr-1.0.14-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0f67d331-cfa9-4422-8a2a-a0ae18a521e4/ae9bdb6e9a0c8248d8aa2cae2269972c/corefx-1.0.14-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.0.14-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.12-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/dotnet-core/1.0
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
