# .NET Core 1.1.11

.NET Core 1.1.11 comprises:

* .NET Core Runtime 1.1.11
* .NET Core SDK 1.1.12

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/1.1/1.1.11/1.1.11.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                                   | SDK Binaries<sup>1</sup>                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-dev-win-x86.exe] \| [x64][dotnet-dev-win-x64.exe] | [x86][dotnet-dev-win-x86.zip] \| [x64][dotnet-dev-win-x64.zip] | [x86][dotnet-win-x86.exe] \| [x64][dotnet-win-x64.exe] | [x86][dotnet-win-x86.zip] \| [x64][dotnet-win-x64.zip] | [Hosting Bundle][DotNetCore-WindowsHosting.exe]<sup>1</sup> |
| macOS     | [x64][dotnet-dev-osx-x64.pkg]  | [x64][dotnet-dev-osx-x64.tar.gz]     | [x64][dotnet-osx-x64.pkg] | [x64][dotnet-osx-x64.tar.gz] | - |
| CentOS 7  | - | [x64][dotnet-dev-centos-x64.tar.gz] | - | [x64][dotnet-centos-x64.tar.gz]  | - |
| Debian 9  | - | [x64][dotnet-dev-debian.9-x64.tar.gz] | - | [x64][dotnet-debian.9-x64.tar.gz]  | - |
| Fedora 27   | -                                                | [x64][dotnet-dev-fedora.27-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.27-x64.tar.gz] | - |
| Fedora 28   | -                                                | [x64][dotnet-dev-fedora.28-x64.tar.gz] | -                                                        | [x64][dotnet-fedora.28-x64.tar.gz] | - |
| RHEL 7    | -                                                | [x64][dotnet-dev-rhel-x64.tar.gz]                    | -                                                        | [x64][dotnet-rhel-x64.tar.gz] | - |
| Ubuntu 14.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu-x64.tar.gz]       | - | [x64][dotnet-ubuntu-x64.tar.gz] | - |
| Ubuntu 16.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.16.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.16.04-x64.tar.gz] | - |
| Ubuntu 18.04 | [See installations steps below](#installing-net-core-on-linux)   | [x64][dotnet-dev-ubuntu.18.04-x64.tar.gz] | - | [x64][dotnet-ubuntu.18.04-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | - |

1. Includes the .NET Core and ASP.NET Core runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

In your command prompt, run the following commands:

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install apt-transport-https
sudo apt-get update
sudo apt-get install dotnet-dev-1.1.12
```

### Run applications

If you only need to run existing applications, run the following command.

```bash
# Ubuntu 14.04, 16,04 and 18.04
sudo apt-get install dotnet-sharedframework-microsoft.netcore.app-1.1.11
```

## Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/1.1/1.1.11.md

[dotnet-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e31e3367-6b98-4d1b-9862-a9a63e1c7dc7/88a96cb53c7f01e39e8d3f6d7542921a/dotnet-debian.9-x64.1.1.11.tar.gz
[dotnet-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad22fcf6-8e22-4a4a-9dc1-8b62196190b3/2a6cb070de5831a13cdff5ec43ceaade/dotnet-ubuntu.18.04-x64.1.1.11.tar.gz
[dotnet-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dff4449f-59c0-47c3-9fbd-fee92af25363/c9732b96c6c81cc66e3aacd782a7eafb/dotnet-centos-x64.1.1.11.tar.gz
[dotnet-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4597de53-759b-4acd-8620-7696bf3907be/f9db799e66151d0b5cd1e27d2d2259f4/dotnet-fedora.27-x64.1.1.11.tar.gz
[dotnet-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c8dd0e9-3869-46c6-a92d-d96c1f4e8abf/b9c4110cb9670d3993ce314db2e16659/dotnet-fedora.28-x64.1.1.11.tar.gz
[dotnet-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e44ca1a-f3f9-4b75-88df-c9227203af0f/eebc0332b07e58b85e14f6834b934f61/dotnet-opensuse.42.3-x64.1.1.11.tar.gz
[dotnet-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2191ed67-c279-4f29-ac0a-5864b2566c10/be632d6dda5f1c6f26ab7c434538ecb6/dotnet-osx-x64.1.1.11.pkg
[dotnet-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3418849-3fac-4c6d-a170-2f6e8b0a4639/91ba64ea0e4b003903d1240fd51a40f9/dotnet-osx-x64.1.1.11.tar.gz
[dotnet-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb2e3c21-9ae0-4e4b-a214-5e1cb1508cfa/30168f9f93fbc59d5a52242cb53253c3/dotnet-rhel-x64.1.1.11.tar.gz
[dotnet-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8dc8c129-0fff-4f6e-9794-dace60b4d0ca/171b94583982ddbb5db52c4c101be0de/dotnet-ubuntu-x64.1.1.11.tar.gz
[dotnet-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fea9884d-7f74-4b23-98c5-0c57b9ed7e92/c909109068c645e62b1218f2e8f90180/dotnet-ubuntu.16.04-x64.1.1.11.tar.gz
[dotnet-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dd13fbf3-66c4-4255-b8da-ad75027b74eb/eced2eb2d3a3ccdd71a11a9099d7428d/dotnet-win-x64.1.1.11.exe
[dotnet-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0f63342c-d030-4ff4-a0ed-e2dda4a76606/0453cb61560044a4e250da5f8e9e012f/dotnet-win-x64.1.1.11.zip
[dotnet-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/17a28d45-1fcf-4429-a58f-5d25cfb0438d/5be192dd06279223d08b6367a5215aad/dotnet-win-x86.1.1.11.exe
[dotnet-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c5a635f3-2234-4fb3-a7e4-1e2831898f1c/b210573eaa206aa8c4460c18d8e7b549/dotnet-win-x86.1.1.11.zip
[DotNetCore-WindowsHosting.exe]: https://download.visualstudio.microsoft.com/download/pr/3c1eea43-d933-414e-97bd-3b382f57a78c/7bad96a7fbee33cd15e210090e5413cc/dotnetcore.1.0.14_1.1.11-windowshosting.exe
[dotnet-dev-debian.9-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d16f339b-a10e-40ea-9cb7-506cc3f3ffd8/f9d8fadd4959752ac9f6a07d842ba079/dotnet-dev-debian.9-x64.1.1.12.tar.gz
[dotnet-dev-centos-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/09aedb07-8a94-46ff-a918-c6473515bf55/ca71af8d4eb09739a3c9a857a07a759c/dotnet-dev-centos-x64.1.1.12.tar.gz
[dotnet-dev-fedora.27-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39252331-fe25-4a60-93bf-ce539e845486/4460d21b02eb3192227ebf380fbf02c1/dotnet-dev-fedora.27-x64.1.1.12.tar.gz
[dotnet-dev-fedora.28-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bcf335f2-42de-4838-bf14-e0332c071133/e065915283c0c4e7d37f2f63c4db6d20/dotnet-dev-fedora.28-x64.1.1.12.tar.gz
[dotnet-dev-opensuse.42.3-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fe9b139b-e498-4166-b338-46eadcccd750/6908d39118b5345a44f5a9e9136cbc41/dotnet-dev-opensuse.42.3-x64.1.1.12.tar.gz
[dotnet-dev-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/88dddec3-3f0d-4ee9-acdd-0b63953662ec/4f20e4ddf864a685b7bea02ad83b5a0d/dotnet-dev-osx-x64.1.1.12.pkg
[dotnet-dev-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29ae1d6c-7fa5-4c1d-8422-296d3a2caf78/46279fdc51ebd3b2ece9ef2af52e0a2a/dotnet-dev-osx-x64.1.1.12.tar.gz
[dotnet-dev-rhel-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b22b80de-2ff5-4f5a-8e20-0065a06ee77f/e8efffdf356501f6523c77661acb17c1/dotnet-dev-rhel-x64.1.1.12.tar.gz
[dotnet-dev-ubuntu-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf80af6a-4d6f-42c0-963b-4b121168617a/b47616e8578d4add910c6f8a612ae2b3/dotnet-dev-ubuntu-x64.1.1.12.tar.gz
[dotnet-dev-ubuntu.16.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83fa051b-10fb-482c-9fc8-c010eebfb4be/477b619412116db67e9e74284ba6dee3/dotnet-dev-ubuntu.16.04-x64.1.1.12.tar.gz
[dotnet-dev-ubuntu.18.04-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9154931b-2255-488f-8b06-a1d501dfc413/81cb4c1af6f42e0d2da959b70502a057/dotnet-dev-ubuntu.18.04-x64.1.1.12.tar.gz
[dotnet-dev-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2b8cbc07-4204-407d-ad2f-a59003467bdb/b7629786a40ad753bd0851c5707100f0/dotnet-dev-win-x64.1.1.12.exe
[dotnet-dev-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8d6e2375-2ba7-4126-b5b7-3228004b7f41/b8894d02f002d2b77f72e6abb899c02e/dotnet-dev-win-x64.1.1.12.zip
[dotnet-dev-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/44629511-68f9-4524-9714-bc8f078522d0/bf4ebced2c77278af84c11949b5baa96/dotnet-dev-win-x86.1.1.12.exe
[dotnet-dev-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/38e6233f-10ce-4607-9220-74e2fa8b07f5/247a2c16a3cb8d2aa8a110b17ebf6be3/dotnet-dev-win-x86.1.1.12.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9f240884-b588-40f6-831d-520ea6aa30f7/79fe8d1fad809d2f5279e8be29e99dad/core-setup-1.1.11-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/4b263964-eb05-47a0-b06d-a317f24b1761/666a816963eb785311a2d167526c106b/coreclr-1.1.11-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/fea552c2-723e-4214-afba-39c9416bbc22/d4b83089232f6d2e26b556d87ff2cc0b/corefx-1.1.11-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.11-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/1.1.12-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/dotnet-core/1.1
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
