# .NET Core 2.1.10 Update - April 09, 2019

.NET Core 2.1.10 is available for [download](2.1.10-download.md) and usage in your environment. This release includes .NET Core 2.1.10, ASP.NET Core 2.1.10 and the .NET Core SDK.

**NOTE:** If you are a Visual Studio user, there are MSBuild version requirements so use only the .NET Core SDK supported for each Visual Studio version. If you use other development environments, we recommend using the latest SDK release.

| VS Version | .NET Core SDK |
| :-- | :--: |
| Visual Studio 2017 (Windows) | [2.1.506](#downloads) |
| Visual Studio 2019 (Windows) | [2.1.603](../2.1.603-SDK/2.1.603-SDK-download.md) |
| Visual Studio for Mac | https://docs.microsoft.com/en-us/visualstudio/mac/net-core-support |

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2110)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #2555](https://github.com/dotnet/core/issues/2555) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

### Azure AppServices

* .NET Core 2.1.10 is being deployed to Azure App Services and the deployment is expected to complete in a couple of days.

## .NET Core Lifecycle News

There are no changes this month in OS version support status.

.NET Core 1.0 and 1.1, which entered "Maintenance" support status when 2.1 was declared LTS, will be end-of-life June 27, 2019. Updates for the 1.0 and 1.1 channels will no longer be offered after that date. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.1.10

.NET Core 2.1.10 release carries both security and non-security fixes.

### Microsoft Security Advisory CVE-2019-0815: ASP.NET Core denial of service vulnerability

#### Executive Summary

Microsoft is releasing this security advisory to provide information about a vulnerability in public ASP.NET Core 2.2. This advisory also provides guidance on what developers can do to update their applications correctly.
Microsoft is aware of a security vulnerability in all public versions of ASP.NET Core where, if an application is hosted on Internet Information Server (IIS) a remote unauthenticated attacker can use a specially crafted request can cause a Denial of Service. The security update addresses the vulnerability by ensuring the IIS worker process does not crash in response to specially crafted requests.

#### Discussion

Discussion for this issue can be found at https://github.com/aspnet/AspNetCore/issues/9205

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.10+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.10+label%3Aservicing-approved)
* [ASP.NETCore](https://github.com/aspnet/AspNetCore/issues?utf8=%E2%9C%93&q=milestone%3A2.1.10+label%3Aservicing-approved)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.10
microsoft.aspnetcore.app | 2.1.10
microsoft.extensions.configuration.binder | 2.1.10
microsoft.netcore.platforms | 2.1.4
system.net.http.winhttphandler | 4.5.3
microsoft.netcore.app | 2.1.10
microsoft.netcore.dotnetapphost | 2.1.10
microsoft.netcore.dotnethost | 2.1.10
microsoft.netcore.dotnethostpolicy | 2.1.10
microsoft.netcore.dotnethostresolver | 2.1.10
runtime.linux-arm.microsoft.netcore.app | 2.1.10
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.10
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.10
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.linux-arm64.microsoft.netcore.app | 2.1.10
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.10
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.10
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.10
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.linux-x64.microsoft.netcore.app | 2.1.10
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.10
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.osx-x64.microsoft.netcore.app | 2.1.10
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.10
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.10
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.10
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.win-arm.microsoft.netcore.app | 2.1.10
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.10
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.10
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.win-arm64.microsoft.netcore.app | 2.1.10
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.10
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.win-x64.microsoft.netcore.app | 2.1.10
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.10
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.10
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.10
runtime.win-x86.microsoft.netcore.app | 2.1.10
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.10
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.10
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.10
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.10

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.10/2.1.10.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3a0363f-4ea6-43c1-b5bf-f15e1b88b428/eda34aff06bd3bfd53cf156427ccd3a3/dotnet-runtime-2.1.10-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23bde323-de7b-4176-b120-6b5d242b49dd/a7a88339ce8c9708b7654f373f484910/dotnet-runtime-2.1.10-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bab3baa2-18fb-435d-b3bb-40a79972b76b/21ac0c23db93d574645415cd800c2027/dotnet-runtime-2.1.10-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16289d7b-669d-451f-972a-46cba94e1cb8/c649d18001435d1f47825df4c040724e/dotnet-runtime-2.1.10-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f6383eb6-ecdb-44aa-8541-429f78b21a8d/3f9d1f07ea241f61bedb60c60af7152e/dotnet-runtime-2.1.10-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6324e69e-c2c7-4e5c-beaa-9452b0a4d123/28b21b4c329033aad66b314864f50d7b/dotnet-runtime-2.1.10-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70eb7301-7077-4851-939b-38aba0634b5f/14da19cba597573eca809857dac80989/dotnet-runtime-2.1.10-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/fa9caec1-196a-438b-9bd3-fd2cb416a2b1/a6b576fd333b938c62ec4bf6b37040d1/dotnet-runtime-2.1.10-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/caaf63d6-4929-4094-a9d4-38d8bd566cb3/12bbfd1272b0f935c3742e8c97257a82/dotnet-runtime-2.1.10-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/abe669cc-b824-41d4-89c0-3c27d4511800/765d9236495bb6a2196389ec8221c4f8/dotnet-runtime-2.1.10-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a1ffeacd-05ad-4160-9b73-4a977a7ac281/564b6b8c718dba050578ab528f214cec/dotnet-runtime-2.1.10-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e9454a64-bb31-493a-af84-df61be9b4309/da99a3ba615bfd65a92d258a1132acaf/dotnet-runtime-2.1.10-win-x86.zip

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b17fd8f4-589a-46cf-bd8a-cc16f8621712/a643c1adb6f62b3943d0c486e1124238/aspnetcore-runtime-2.1.10-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/329e1249-d55a-458a-ae3e-fbd8d5e5c403/a2d9860c68c9f0e681b85b1acd16d20b/aspnetcore-runtime-2.1.10-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5967af9f-21d4-4b2f-a166-52af457d02aa/713e9a0f3753cf79171594bbdb92ad89/aspnetcore-runtime-2.1.10-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0bc7d09-e1f4-4d2f-a6e9-c49ec2b803b8/c169d13b0be8f2eb7fd4cf90f7080b8d/aspnetcore-runtime-2.1.10-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f67fda48-1e9a-4cfb-9c63-435273064b4b/1b980428cbc2c0abc4c4a3907bd16ac3/aspnetcore-runtime-2.1.10-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ecb1e954-94a2-401b-9162-06314d84e369/768d0460a1fd21a326f4ce4017c4a9df/aspnetcore-runtime-2.1.10-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a0d98a3a-4a80-4619-801e-83c7d13892a6/5c5339e223780ddbe0a08a467c653ca6/aspnetcore-runtime-2.1.10-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/af0cf37a-4199-4c60-bc6c-336f81461e58/c20dd8d99727e9818156bea0af9be8fe/aspnetcore-runtime-2.1.10-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/34ad5a08-c67b-4c6f-a65f-47cb5a83747a/02d897904bd52e8681412e353660ac66/dotnet-hosting-2.1.10-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1634db77-54c5-41c0-ab6d-e1d5cf117d8d/5d7c32161328438ecd782adb65ef03fc/dotnet-sdk-2.1.506-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e837d1e-9e1a-4ab2-97d1-261fa45cc29a/7bf4e69e8a6be642410dc249e5bebad7/dotnet-sdk-2.1.506-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/16ff849d-77ce-4caa-a3a5-faea8a5c8734/15671043dc1beaa9faa7ade2e7cace03/dotnet-sdk-2.1.506-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa1aac0d-8357-4d91-9ee8-fb89372f42a8/b8659e132dee3621df4f18c6fbc04c63/dotnet-sdk-2.1.506-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/2ca9e042-b012-4f5b-91dc-e0bc73a6ae4e/f6236d430f2c5a2442701486f6bbaa2c/dotnet-sdk-2.1.506-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7de684d2-7d79-42a6-8389-3f6ab6944a36/626fa84eb138b7094be18f14fa516bbc/dotnet-sdk-2.1.506-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c6aabdd7-f2e4-4803-99f2-db97c610a794/addca7298bbbf6fb42ce9b995c83045a/dotnet-sdk-2.1.506-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/800a2df7-3139-4331-9521-13a717dd9929/c28b96c5a5169ca7cf934dc8e0f76261/dotnet-sdk-2.1.506-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c1af7ca-17ff-4e40-a9e2-ff77e37ab6da/1807a6d4fad51225bdf8116129677361/dotnet-sdk-2.1.506-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aa5d5dd8-6d59-48cb-b733-bd842071382b/9b63ed52ce387e63447d75265a6984ce/dotnet-sdk-2.1.506-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f6a1a446-dbad-441f-9f13-8f5727f54a19/0f0753b9248058db5b623089f0ff733a/dotnet-sdk-2.1.506-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/fce4e98e-1be3-4603-89a5-0ba98d11ceb0/c207cbf61146b4a4cdb490732c722191/aspnet-2.1.10-symbols.zip
[aspnet-extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/e49f73d2-9746-45c3-8b08-5e628c13c94e/580ef81d0ff9a73f36de39ff0bb4209f/aspnet-extensions-2.1.10-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/da4719b1-20a3-490e-a81f-46cfaedad2f1/e1e51fdcd30ea26293678dc2cae553df/cli-2.1.10-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/1a5b28d3-1d71-43fb-b3be-8e166e736889/1cf3af996cb9b26fc2d5578a3a0b4b39/core-setup-2.1.10-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/72c448bc-052c-43d8-bf77-d66b5f6e2372/e2089ffebb26b5f3726c91a48eb288dc/coreclr-2.1.10-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/2ce8b163-45e8-4834-8c28-4e845f06da2e/77ef403106f2ad9113efb3fe925d1972/corefx-2.1.10-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/8bc18ae0-6616-4218-a35b-c49360ffb0da/0f022b73024bb8d9f2e8d39c4ca4395a/dotnet-sdk-2.1.10-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.10-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.506-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-april-2019/
