# .NET Core 2.1.12 Update - July 09, 2019

.NET Core 2.1.12 is available for [download](2.1.12-download.md) and usage in your environment. This release includes .NET Core 2.1.12, ASP.NET Core 2.1.12 and the .NET Core SDK.

The July Update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download. Otherwise, the best version to download is [.NET Core SDK 2.1.801](2.1.801-sdk-download.md). 

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Any supported | Command line and/or Visual Studio Code | [2.1.801](2.1.801-sdk-download.md) |
| Windows | Visual Studio 2019 version 16.2 | [2.1.801](2.1.801-sdk-download.md) |
| Windows | Visual Studio 2019 version 16.1 | [2.1.701](2.1.701-sdk-download.md) |
| Windows | Visual Studio 2019 version 16.0 | [2.1.605](2.1.605-sdk-download.md) |
| Windows | Visual Studio 2017 | [2.1.508](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/en-us/visualstudio/mac/net-core-support) |

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2112)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #3007](https://github.com/dotnet/core/issues/3007) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli215xx-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

The images are expected to be available later today.

### Azure AppServices

* .NET Core 2.1.12 is being deployed to Azure App Services and the deployment is expected to complete later in July 2019.

## .NET Core Lifecycle News

.NET Core 1.0 and 1.1 reached end of support lifecycle on June 27, 2019 and will no longer receive updates going forward. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

Debian 10 GA finally released and we expect .NET Core availability on it later this month. 

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.1.12

.NET Core 2.1.12 release carries both security and non-security fixes.

* [CVE-2019-1075: ASP.NET Core Spoofing Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-1075)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a spoofing vulnerability that exists in ASP.NET Core that could lead to an open redirect. An attacker who successfully exploited the vulnerability could redirect a targeted user to a malicious website.

To exploit the vulnerability, an attacker could send a link that has a specially crafted URL and convince the user to click the link.

The update addresses the vulnerability by correcting how ASP.NET Core parses URLs.

**Affected Package and Binary updates**
    
Package name | Vulnerable versions | Secure versions
------------ | ------------------- | -------------------------
Microsoft.AspNetCore.Server.HttpSys | 2.1.0, 2.1.1<br/>2.2.0 | 2.1.12<br/>2.2.6
Microsoft.AspNetCore.Server.IIS  | 2.2.0, 2.2.1, 2.2.2 | 2.2.6
Microsoft.AspNetCore.All | 2.1.0 - 2.1.11<br/>2.2.0 - 2.2.5 | 2.1.12<br/>2.2.6
Microsoft.AspNetCore.App | 2.1.0 - 2.1.11<br/>2.2.0 - 2.2.5 | 2.1.12<br/>2.2.6

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.12+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.12+label%3Aservicing-approved)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:2.1.12+label:servicing-approved)
* [ASP.NETCore](https://github.com/search?q=user:aspnet+is:pr+label:Servicing-approved+milestone:2.1.12)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.AspNetCore.All|2.1.12
Microsoft.AspNetCore.App|2.1.12
Microsoft.AspNetCore.Server.HttpSys|2.1.12
Microsoft.NETCore.Platforms|2.1.5
System.Threading.Tasks.Extensions|4.5.3
Microsoft.NETCore.App|2.1.12
Microsoft.NETCore.DotNetAppHost|2.1.12
Microsoft.NETCore.DotNetHost|2.1.12
Microsoft.NETCore.DotNetHostPolicy|2.1.12
Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.linux-arm.Microsoft.NETCore.App|2.1.12
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.linux-arm.Microsoft.NETCore.DotNetHost|2.1.12
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.linux-arm64.Microsoft.NETCore.App|2.1.12
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.linux-musl-x64.Microsoft.NETCore.App|2.1.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.linux-x64.Microsoft.NETCore.App|2.1.12
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.linux-x64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.osx-x64.Microsoft.NETCore.App|2.1.12
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.osx-x64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.rhel.6-x64.Microsoft.NETCore.App|2.1.12
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.win-arm.Microsoft.NETCore.App|2.1.12
runtime.win-arm.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.win-arm.Microsoft.NETCore.DotNetHost|2.1.12
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.win-arm64.Microsoft.NETCore.App|2.1.12
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.win-arm64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.win-x64.Microsoft.NETCore.App|2.1.12
runtime.win-x64.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.win-x64.Microsoft.NETCore.DotNetHost|2.1.12
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver|2.1.12
runtime.win-x86.Microsoft.NETCore.App|2.1.12
runtime.win-x86.Microsoft.NETCore.DotNetAppHost|2.1.12
runtime.win-x86.Microsoft.NETCore.DotNetHost|2.1.12
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy|2.1.12
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver|2.1.12

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.12/2.1.12.md

[//]: # ( Runtime 2.1.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f759670e-1f8d-4f1a-8eb7-58b95f94c68c/69eca04ca138dc6c3caa160bd1b891d1/dotnet-runtime-2.1.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6ac0d5e-513c-416e-acf2-124a51551a1b/a34dea8d2abb62d29d4bf76a10b9dc30/dotnet-runtime-2.1.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/467a6d37-d1a9-4640-8517-93a638e574a8/32c24faccb0d5460089dafc9babe0251/dotnet-runtime-2.1.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c78594a-dd2c-488e-b201-b7fd9b78ab00/5f2169b20fc704e069c336114ec653c5/dotnet-runtime-2.1.12-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f25e0161-ec20-46a7-87a7-881dbb6a04a1/a1d22440ce211d4e2e13203561c7d770/dotnet-runtime-2.1.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/63ca131a-270d-427f-a85f-d328b160ef85/7ed226a80fedae75c6ef2a7f3090904b/dotnet-runtime-2.1.12-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8716e3ad-f2b4-4d87-9133-61ded394a42f/89820fd294fa07616e8423534eced0cc/dotnet-runtime-2.1.12-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/db199ce9-e39d-4115-8d24-a42e440c4930/b3a30d1d6855f8b4c42844c31b373333/dotnet-runtime-2.1.12-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ddd9d981-872f-4b62-b942-cfbf9c7e0e60/cbfc51fb841d7398a5ad9acb50d4f8ee/dotnet-runtime-2.1.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/dcf8c839-2ffd-4677-9b29-4af9c44e170e/59de767034f66051fe6eab61fa757be1/dotnet-runtime-2.1.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0fd34b03-08ed-44ec-9761-308717c7fd27/7556f134a19420dbe781b44a13c4d666/dotnet-runtime-2.1.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3c85a8f2-2d5c-4a42-811b-2e89f04151a8/7583d56dcd286c7112781125c9fca215/dotnet-runtime-2.1.12-win-x86.zip

[//]: # ( ASP 2.1.12)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66039441-8e90-47e9-ac2e-74ad0e8d2174/c26b37f6d82e2a96751c85ff48727d6f/aspnetcore-runtime-2.1.12-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc2bad3f-7ebc-4579-990a-52e16dff204b/260ce8c864f201717dfe75f4146c3b40/aspnetcore-runtime-2.1.12-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1b620fe-7d8e-4685-b6ae-82b444dbc7a7/3d5610f0607da49ee014c61c6cd4e9af/aspnetcore-runtime-2.1.12-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90ed1613-140d-4daf-9edd-7037bea2116c/cbc63e0e394727de0460ddddd3dcf58a/aspnetcore-runtime-2.1.12-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/de023b91-4177-4e0b-9941-40f2e44d5408/ea7705ae5993202807ad98dcf7b8ddf7/aspnetcore-runtime-2.1.12-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3e6c7d2d-3ca9-49ff-8168-bd85c88e4138/eeca26ac5189c66f044c3a0a462e1409/aspnetcore-runtime-2.1.12-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d8b36b96-890f-4207-9418-565fa6e7b64f/775b6912b82886fdb7be25b63a47bc57/aspnetcore-runtime-2.1.12-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dbd566a6-3629-45bf-804f-79e86d6c6a93/ed8a595e8db40013264f8f304423ed6a/aspnetcore-runtime-2.1.12-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/eebd54bc-c3a2-4580-bb29-b35c1c5ffa92/22ffe5649861167d3d5728d3cb4b10a1/dotnet-hosting-2.1.12-win.exe

[//]: # ( SDK 2.1.508 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bf9e4894-8be5-4489-a7f8-a63b5b1b94e1/4c835afa300c2f88d9ce9b1930810a7f/dotnet-sdk-2.1.508-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4efacca7-6aa7-4d17-914a-8640a13d48ec/643d927e12256aad75296a98e727a9c9/dotnet-sdk-2.1.508-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/549be9ab-72d0-406f-9e0e-bb23ba747613/5fa6214ad1245e79d724fe36b5279f46/dotnet-sdk-2.1.508-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0349bef8-8dfe-431e-80ff-ca6e1b986bea/5d0831e58173722f28422efeea889e81/dotnet-sdk-2.1.508-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/37b50bfe-0525-45a9-9dd0-fe3f1e802df4/149dc3ed72873908e0675656bcb30b9c/dotnet-sdk-2.1.508-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd1fcfe3-d67c-4533-8d1c-4ff5eaf781ae/6ac777895421e1ac8153cd94f2feb372/dotnet-sdk-2.1.508-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4d92f34-8432-43ac-9954-a3e229359a9e/1c88d923d55dc19ce576269c254ba7ed/dotnet-sdk-2.1.508-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2f2d03ef-b000-46a2-abf5-8b863e438568/cddce0caa2526db658e0d21937f89b28/dotnet-sdk-2.1.508-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bac2ecc8-9115-4414-987a-638d40153e03/df7bc8e7128208b814ea1c38d7241a34/dotnet-sdk-2.1.508-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/28487a49-8109-4434-8668-eeebf7ed60fc/5cb465e10451e3e34bd2c75c7333e69f/dotnet-sdk-2.1.508-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c9f03bfe-e856-4f0b-b90e-207029944a19/9aabccba702eb23e9f3044f2391dfa6b/dotnet-sdk-2.1.508-win-x86.zip

[//]: # ( Symbols )
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9b6a0892-903d-4b68-aaf0-8b9479c27ea3/a2431f48b4080c8110a266acbff1b875/aspnet-2.1.12-symbols.zip
[cli215xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b2827643-f988-4be5-9fab-e138abfeb943/61396a618cf18e01c265f76b0163e4ef/cli215xx-2.1.12-symbols.zip
[cli216xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6efc74cb-8901-4cf5-825e-67b7e90fc41f/c03c4bb19edc4dea072c5b8b0b6b1bd4/cli216xx-2.1.12-symbols.zip
[cli217xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/97244428-1e08-444e-930a-f9b6ccc08863/e80424a203118e63b5b4033df48396dd/cli217xx-2.1.12-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b992d510-45cc-4d55-8bd6-9cd67b5d5dde/b719f8b5e4a497b9a1448008cf9a2631/core-setup-2.1.12-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/e5ab8e45-a8ee-4445-bb67-ef489bb5f67d/c3b1272e7d2e7048900e9b1b9d0bd8e9/coreclr-2.1.12-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d288a4e6-535e-4166-b366-255432094f24/7305738b4ca3aa8de98e35357fa36636/corefx-2.1.12-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/895223a7-e490-44ab-b7b0-46c510ccb51b/1438cae050d6fabcfdf08caf346500bf/dotnet-sdk-2.1.12-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.12-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.701-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-july-2019/
