# .NET Core 2.1.8

.NET Core 2.1.8 comprises:

* .NET Core Runtime 2.1.8
* ASP.NET Core 2.1.8
* .NET Core SDK 2.1.504

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.8/2.1.8.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distrobutions which are not directly supported by .NET Core can use Snaps to install. See the [list of distrobutions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

### Run applications
If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linx systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.8-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.1/2.1.8/2.1.8.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a36af597-586b-474b-8f91-9a1491b1b826/c56fac62f1ccc855afdd22bf2e9f7051/dotnet-runtime-2.1.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/46389bf1-b9e6-4a5e-9a99-2553f97abf4d/95d179c200d11593b363848d771e6be7/dotnet-runtime-2.1.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eeacc181-7b17-49a7-9664-cecdc8d2ab40/30222417a9866c9512bb96290770c73c/dotnet-runtime-2.1.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eae50d35-ec30-4416-829a-36e8b5158f22/52d8370bea6e696cee4280bec0eda4bc/dotnet-runtime-2.1.8-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/492b8744-10e1-47da-8bb3-6878dc3eed3e/b830851d9937aa83525b2a6088f91db6/dotnet-runtime-2.1.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0a8df2f2-bc67-455a-8df1-0f2395158eb2/0b42613ec436997900bda0696dabc54c/dotnet-runtime-2.1.8-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/713b711d-7f14-4dc5-959f-972392f7cd74/72187ac69f815e2f01a0c7a628e09f24/dotnet-runtime-2.1.8-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8e05da2e-4300-41e7-bbc1-474db3aa9166/d2e0d4c9290067eed76b2c5d8677d524/dotnet-runtime-2.1.8-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/1ed7bac3-d0a1-4ef3-8b67-2f55b7d4bf0f/e524f264a6384c7f005818353e4b8703/dotnet-runtime-2.1.8-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c551fea4-c065-4142-9556-4d78fb949284/efe7c2ef2d51331bd0fced6ea0eadf08/dotnet-runtime-2.1.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9b5aa463-d86c-4f8c-8dbb-26e323021246/3b75b083359c97b79da538cf40b041a0/dotnet-runtime-2.1.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1f94a87b-7a17-430c-a860-c18d4989ee5c/c1f4b946d3ae9bbd95413636d334d0ab/dotnet-runtime-2.1.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/80cf31e3-1835-4ad1-965d-4971589fe501/7c4bf547ee314069b2482b22dbc778e8/dotnet-runtime-2.1.8-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43b1eaf3-f6dd-425c-80d1-137d28081f78/9dd9acff1aeac4f4ac994df2b05578ab/aspnetcore-runtime-2.1.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c39af076-0ec1-4880-958e-6a50f9e18ee6/610247ccb388f86e9706f2f86d0e6874/aspnetcore-runtime-2.1.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/927cbf41-157f-488b-ac7d-32034defebc3/41b011418f795d5a76bf930ad57a055b/aspnetcore-runtime-2.1.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dba15b05-0c93-4d8b-89a1-c24eb1c71412/90354379b88f50f6bf17634e9260905f/aspnetcore-runtime-2.1.8-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/22dccc6e-d3d9-4d1f-8a60-de7fed0bcc77/58c9a9101a49605f4b62ed3139492408/aspnetcore-runtime-2.1.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/874e6430-08dc-45bf-ba49-9c8871a3f53e/cac4601c6e16af65dacae363b0bd3559/aspnetcore-runtime-2.1.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9ab30138-4a37-455c-bb62-a357862919b2/2e61c5254b1fa0e3118cf4f253d54f6b/aspnetcore-runtime-2.1.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/776197cf-38e6-45e0-a10a-d2c30619346a/6e42301fd0d075076484f7c6e99ef58e/aspnetcore-runtime-2.1.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c2b2968d-022d-4889-afd0-b02010813c94/bd315e931f55eecfdaea258cf3dee48e/dotnet-hosting-2.1.8-win.exe
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48d0a1d0-78a7-4bf9-a349-306d317a349f/5f28d7ce059d8d65dbe367821f40a16e/dotnet-sdk-2.1.504-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5912b468-1221-48dc-9339-79506418e22f/2fd380bf8aa123ec8ea8c3046ad142e9/dotnet-sdk-2.1.504-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/074db8c2-0e35-442a-81e4-10c8e23d5301/8a214d199985584c3d7be3c079b57e63/dotnet-sdk-2.1.504-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b35cf035-09d9-444a-8f62-c972fd6f2be0/4068a391164715232bbf4477b349643f/dotnet-sdk-2.1.504-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/01e846dd-d59f-456d-8c14-36343ca2084b/65f68ebb4342adfb8bce337411d8aecc/dotnet-sdk-2.1.504-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68152d1c-8ed5-4fc1-9894-8956c33fe4c8/73425e378edcfce4c8537c37a5ec7649/dotnet-sdk-2.1.504-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b7526d13-c0af-4c0d-bc74-66f5b09cd915/688e38a1bbba5a67d9e4d0b6f6056756/dotnet-sdk-2.1.504-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1dcd5e24-25da-40dc-9996-4db675c1c22d/e154ee2beeb1eec4e9b049a8d3740c80/dotnet-sdk-2.1.504-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/88364f95-160b-4820-9a5b-1d00b619dee7/5021f130569e524eacc2e3a8e6933e62/dotnet-sdk-2.1.504-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/3cf20226-fe88-4879-be05-f662f99c4a3a/65602cb8ae7a87a532dd25c11237cf6a/dotnet-sdk-2.1.504-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/52f4576e-d2d2-4b57-a5cd-6a8561b86b5f/ef765a8e9a2fa3ab55449e09eb5f513f/dotnet-sdk-2.1.504-win-x86.zip
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/284653cf-d4b8-459b-b956-084a7ceb604b/1da506036feb060c4a8cd15890c1b250/aspnet-2.1.8-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/8a82d06e-3d16-497a-b461-58848d7add64/c3427c0a5dc1dff0498ff0af92d77bd3/cli-2.1.8-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ec4c3a49-2864-42f3-bd76-006e000746b8/9e70f83ab9016f136ddd5107239dbbd5/core-setup-2.1.8-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/613d85ee-19be-46be-b454-a41497faf9d7/26945496c0862c63783c088618d26566/coreclr-2.1.8-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d358c132-d850-4d4f-be7a-6e01dfe7d47c/fdd803392b44e577eb8b221d4f6ffb4f/corefx-2.1.8-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/3bde9854-d226-4dc8-b702-5b7dd6fa687b/a5cdfb1edefb834c8413709f0016d63f/dotnet-sdk-2.1.8-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.8-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.504-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/
