# .NET Core 2.2.4

.NET Core 2.2.4 comprises:

* .NET Core Runtime 2.2.4
* ASP.NET Core 2.2.4
* .NET Core SDK 2.2.106

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.4/2.2.4.md) for details about what is included in this update.

**Note:** If you are a Visual Studio user, there are MSBuild version requirements so use only the .NET Core SDK supported for each Visual Studio version. If you use other development environments, we recommend using the latest SDK release.

| VS Version | .NET Core SDK |
| :-- | :--: |
| Visual Studio 2017 (Windows) | [2.2.106](#downloads) |
| Visual Studio 2019 (Windows) | [2.2.203](../2.2.203-SDK/2.2.203-SDK-download.md) |
| Visual Studio for Mac | https://docs.microsoft.com/en-us/visualstudio/mac/net-core-support |

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.2
```

### Run applications
If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.2
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.2` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.2` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.2.4-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.4/2.2.4.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c52648c-bedd-44b0-9442-95cd830fdada/d6ba4c50a6b2afddc4ae3d313349f3ac/dotnet-runtime-2.2.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9e06922d-3a96-4f0d-9eb0-94f2cf94458f/93dfe5f0ad50c0eb347e98d7f81b34ec/dotnet-runtime-2.2.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98598e18-82bb-4e15-a9dc-49da98d67b57/7e44b7da6e7058d6f29b2ab5772455f4/dotnet-runtime-2.2.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/853048a3-764a-4b4d-a608-c6144a84f257/99c5cb1ea145f9dc3c2bbd093c682c9b/dotnet-runtime-2.2.4-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7691df75-3dcf-4378-b058-a54533c68c56/de1258843b7005711bf03e926de51d45/dotnet-runtime-2.2.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20c176c0-117e-46a1-8f84-0e8aef75e6bd/65758f170f310cc4679b6f9e348d7713/dotnet-runtime-2.2.4-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6c78606-9ae5-47df-b25c-83f612c545dd/cc7a7c185419a903dddb04ceeeab6075/dotnet-runtime-2.2.4-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/1c93d069-5e85-47c8-a360-d5a472409713/38a91e49c416afc31c3a5084d675fedf/dotnet-runtime-2.2.4-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/65aecaf4-6011-4882-831d-c9b90cd5033c/55c3561e8ee2629a5298a0ac828fdf0a/dotnet-runtime-2.2.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ef97690d-a1d0-469a-9290-07487e23dd2e/54a466cf8d8bcd0d96dc92cfce80c667/dotnet-runtime-2.2.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/d3881497-8f9d-42e8-b66d-9e16b6c01c98/cb289bca8c5dd581f580dcd01a9cbfb1/dotnet-runtime-2.2.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b1873e1d-0376-49be-be5e-d8b7e53d9558/0fc2c42e652ff1519382f87d1a4d4038/dotnet-runtime-2.2.4-win-x86.zip

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c130118-be9f-4e5b-89c3-97ffcfa2f45e/e156161f472b57159868c7b6225679f8/aspnetcore-runtime-2.2.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/599e8af1-a6a9-4d05-aa69-0840fba4c1df/09653596c62ab003bf33559e42e08e11/aspnetcore-runtime-2.2.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/61a33dc2-fc56-4bbe-b564-d232172eb210/d8006a719a3bcc65d2937a909623afcb/aspnetcore-runtime-2.2.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50cdc81d-d339-4143-9a75-8e756f12e657/75552906fd53c001467bc2a1b3c155b4/aspnetcore-runtime-2.2.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2ab5397f-92e1-4cc7-b1f8-4d46140a7794/b7cc3abf1719ce6542834ebd703f9564/aspnetcore-runtime-2.2.4-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5a959d12-59b3-4665-a902-1d39ac7c1c94/ae83a33b4d43b7f9d0b66adf34de2c16/aspnetcore-runtime-2.2.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4a4064e7-a156-4107-869d-2a347ea84005/1d752833bfc965af99cf0eea2e229cf3/aspnetcore-runtime-2.2.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6c859865-4bba-419e-ac19-dba85c03a5c1/5c62e50e6e1b56028b29754510f4c8c8/aspnetcore-runtime-2.2.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4c82f97b-e7ab-46ef-993e-102dda3959fe/337eb6c1e66dbd4ca8a895a277c397d3/aspnetcore-runtime-2.2.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c4dcaead-1f81-49af-b824-e6a42b4dbe5a/0d292d75a11666d5e2ebeed4171d27a7/dotnet-hosting-2.2.4-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0046f2c3-95c0-4b34-ad1f-bd255a9788c9/9bd707e2feabb3ad898e815fe0e8ab89/dotnet-sdk-2.2.106-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65d53b22-7f74-4baf-ba74-074fb227b352/8d103eb471c42a91c8e92b13f352b54e/dotnet-sdk-2.2.106-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60f87d97-1f26-4b8e-8c80-63ac159ad4e8/d3fa7b7919593305e8e3389fa53c42d5/dotnet-sdk-2.2.106-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9bef40df-fd90-4693-a16f-76fd40358c89/13e2cbd999ab248e9cf5d10d98d3e5fc/dotnet-sdk-2.2.106-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4d0f3f47-4c25-4102-8df8-a6fe7b472677/d1e3684501ffb70df10879b831b2e70e/dotnet-sdk-2.2.106-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4f74ee8-c6f1-4288-bcf2-4a8515601020/10533119f42116bb4ce53eef285fc4a6/dotnet-sdk-2.2.106-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06f59158-c28c-4051-80bd-a0027eae08de/cdcea7c36d0090a99b91ce5fd8694f5f/dotnet-sdk-2.2.106-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a685f1b1-fe1c-42d3-ae6a-701bbb0d72ed/2ad2ed16f34f7b146defde9676676401/dotnet-sdk-2.2.106-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f417c16b-d043-44ac-91df-6eebf8a0adaf/2c86c96cee4a6040d7986b5487d8a232/dotnet-sdk-2.2.106-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/11bb04fb-6ede-4b63-8654-ea3d513d31ad/1c6d5afe3302155df890154028984542/dotnet-sdk-2.2.106-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c6d92d6a-8f43-4312-9c48-0209fbca2508/ae6f06dd2f4bde27b223700fc3bf45b1/dotnet-sdk-2.2.106-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fbb614f4-ea5d-43e8-aa06-0c7638b1cc78/6dd2207527f0a53a703f17c5cdd8c000/dotnet-sdk-2.2.106-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b343ad77-edd2-455f-9813-b9f3e5e743d9/1937f1a021a7d8052ce39f5a67cbf5fa/aspnet-2.2.4-symbols.zip
[aspnet-extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/01cfb96c-acde-4700-af4c-72852042769f/a3d0d4ca9de2dd279692f5a1cad75aea/aspnet-extensions-2.2.4-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/e22b6a72-eb1d-4a8f-ba40-2b55b5fa1732/27761268efdb4045ba9984b10dd8a3f5/cli-2.2.4-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b4fe8af9-3113-48db-8c6c-2845e7741631/4b2acac94e15bab914698c958f4060c9/core-setup-2.2.4-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/c73c191b-c1e7-4a42-a290-01fae122f956/456302207affcfd4a43af82c32dd3e8e/coreclr-2.2.4-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ba7202ff-a4c7-4eb3-ad5e-8448f16c7b41/8cc77f8453c8a40a6ac88c1ea3213d17/corefx-2.2.4-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9de1579e-a940-4279-9b81-3e80654e29e2/02f79685daffe061821ffde0332ebfa3/dotnet-sdk-2.2.4-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.4-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.106-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/
