# .NET Core 2.2.7

.NET Core 2.2.7 comprises:

* .NET Core Runtime 2.2.7
* ASP.NET Core 2.2.7
* .NET Core SDK 2.2.109

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.7/2.2.7.md) for details about what is included in this update.

The September Update for .NET Core 2.2 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download. Otherwise, the best version to download is [2.2.402](2.2.402-download.md).

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Any supported | Command line and/or Visual Studio Code | [2.2.402](2.2.402-download.md) |
| Windows | Visual Studio 2019 version 16.2 | [2.2.402](2.2.402-download.md) |
| Windows | Visual Studio 2019 version 16.0 | [2.2.206](2.2.206-download.md) |
| Windows | Visual Studio 2017 | [2.2.109](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/en-us/visualstudio/mac/net-core-support) |

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications
To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.2
```

### Run applications
If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.2
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.2` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.2` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.2.7-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.7/2.2.7.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.7-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/

[//]: # ( Runtime 2.2.7)
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/51c29196-43b3-47d6-a393-d0df24081ac1/8b8d720b3cd63d88a2fd69115ab713c5/dotnet-hosting-2.2.7-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6147382e-bccd-4800-ac45-19db334518ad/389c7a0554fab6994a48e546def1b636/dotnet-runtime-2.2.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/330ee296-1713-47b5-b03d-970fc92ca810/f355be326512dd2cdae5a5ae7115cb5c/dotnet-runtime-2.2.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae594623-ff74-42a2-8662-8c7364c8d497/b7b01b805df4e665c0e34d5f94ff804c/dotnet-runtime-2.2.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc8dd18d-e165-4f58-a821-d657eea08bf1/efd846172658c27dde2d9eafa7d0082e/dotnet-runtime-2.2.7-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9d500871-7711-479c-9365-acc9b07f7f11/c02dba8552cd0d9d9147891210916b86/dotnet-runtime-2.2.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d74e062f-f70c-421f-8dca-c9c80d742c17/a7d2ec01f62b38ffaf65fcd25f2fcf1c/dotnet-runtime-2.2.7-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e45dd28b-ec55-4e1f-86c4-876343189a21/2d892c8d2378e3e5306e7c30ae851d5d/dotnet-runtime-2.2.7-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/45d28fd9-e8c0-450b-838f-77ec6fe54c99/e65179c55b9fa9b2ba897a30fee82e11/dotnet-runtime-2.2.7-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a803822b-178b-4d21-bb7c-aaa1d209c341/e77c5ca1d0ea9963346655e2ec2733f2/dotnet-runtime-2.2.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/511058f3-87d6-4fa2-9be1-bfa1b4867d7b/fc629b13c0c1a55557bf699de0197ccd/dotnet-runtime-2.2.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2b9e6f98-53ba-412d-8a4e-cb4092d8a293/602c597f378f5c5d527e91e1fa1ebb55/dotnet-runtime-2.2.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c5f8a2ef-c12c-4fd2-b54c-e96ff475aa0c/9564dd351b06bd259cd637157819dada/dotnet-runtime-2.2.7-win-x86.zip

[//]: # ( ASP 2.2.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ea963afd-3b38-46c1-b058-c4ccbf862e48/6edc7bde8816cb981e8d0c1e5bf21718/aspnetcore-runtime-2.2.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f41f5f74-41d3-42e6-9f01-d6aa069a9fe5/0a10244daf90ed6b8a4b96a35f4140e3/aspnetcore-runtime-2.2.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0b6c052-2f5d-42b9-8ffa-870ea2a60d11/90c1d5b4a2548c1beaeacff0a39a459c/aspnetcore-runtime-2.2.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1485ff28-81f0-425c-9127-bce5921818db/e29f612db8c106e969423253d1dac691/aspnetcore-runtime-2.2.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/32fa5a05-2e47-4ccb-939f-ea4feb843d4f/736d9841c8d36385c4ec5028dba07332/aspnetcore-runtime-2.2.7-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/db9a9e04-60df-45c2-8108-cc532be2f0e4/92896677a17af8c0adcfaf45231832f2/aspnetcore-runtime-2.2.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ead2ca87-df10-4194-a216-496033367ee2/7d62804a5ba6170d9458588dbbbec8e3/aspnetcore-runtime-2.2.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bd37a7fd-b368-41c7-9695-20efd6b3be0e/bc365dafed915888b4e2cefe3c8dbc66/aspnetcore-runtime-2.2.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/deb38af9-fd79-4a3f-a8e4-0de4d781e1bd/9301efd7540caa8ad232420f2cbac118/aspnetcore-runtime-2.2.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/51c29196-43b3-47d6-a393-d0df24081ac1/8b8d720b3cd63d88a2fd69115ab713c5/dotnet-hosting-2.2.7-win.exe

[//]: # ( SDK 2.2.109 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b732756-b8dc-4611-8eec-f69d3d357256/8884e240efd4a5ebf2941fea6c2905c1/dotnet-sdk-2.2.109-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad1540d9-b2a6-456c-bb3a-320e74a6beb9/b7e0370fd095d58dfc8dfa70e3ca7bd4/dotnet-sdk-2.2.109-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cb12ddf-641e-4733-9f37-183e94095d17/1c9a255adf3724ee60f201794d2e9a02/dotnet-sdk-2.2.109-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d09cdd5-2b32-4e8b-a9a0-a8d4f0096ed0/603111ff75f5a3b6fe7d13a40c184678/dotnet-sdk-2.2.109-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0c022dcc-570d-4492-b356-a9f6f767e70c/aa2dc6b52682ec96528745fc591403b1/dotnet-sdk-2.2.109-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e70be3ce-7c70-4550-88a9-ccf060e0e287/811a6f0bda4a831d1059239674349428/dotnet-sdk-2.2.109-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23245995-5ae5-449e-9619-410e6fd25f2f/4174cfbf6e541cf67d8c31e9f60cc1b8/dotnet-sdk-2.2.109-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/95b080e0-60a7-4709-8576-e0d2839182b5/ed2b4df52ac07b3c916580afa37fcb18/dotnet-sdk-2.2.109-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f4fc2718-bc21-4a97-ac01-426aed568946/a5f6b770c7396ad1eb71355e4dc234f6/dotnet-sdk-2.2.109-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/42de37cd-5271-417d-9e02-e5a382812639/bb142cc57ff671e055aba3fe13e24f80/dotnet-sdk-2.2.109-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/de841c2f-71ca-47f9-8142-e5761bc0aa25/b9aec5fa638e4ebef836ed576ada98e1/dotnet-sdk-2.2.109-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a73b5648-813f-4bf7-843d-42c843e04932/3d65c355abee4f461d83a02bff237533/dotnet-sdk-2.2.109-win-x86.zip
