# .NET Core 2.2.7 Update - September 10, 2019

[.NET Core 2.2.7](2.2.7-download.md) is available for download and usage in your environment. This release includes .NET Core 2.2.7, ASP.NET Core 2.2.7 and updates to the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Lifecycle News](#net-core-lifecycle-news)
* [Downloads](#downloads)
* [Visual Studio Compatibility](#visual-studio-compatibility)
* [Changes in this release](#changes-in-227)
* [Known Issues](../2.2-known-issues.md)

We've created an issue at [dotnet/core #3345](https://github.com/dotnet/core/issues/3345) for your questions and comments.

## Lifecycle News

.NET Core 1.0 and 1.1 reached end of support lifecycle on June 27, 2019 and will no longer receive updates going forward. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

See [.NET Core Supported OS Lifecycle Policy](https://github.com/dotnet/core/blob/master/os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core, ASP.NET Core Runtimes and the SDK compatible with Visual Studio 2017 (2.2.109).
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Visual Studio Compatibility

The September Update for .NET Core 2.2 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download. Otherwise, the best version to download is [2.2.402](2.2.402-download.md).

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Any supported | Command line and/or Visual Studio Code | [2.2.402](2.2.402-download.md) |
| Windows | Visual Studio 2019 version 16.2 | [2.2.402](2.2.402-download.md) |
| Windows | Visual Studio 2019 version 16.0 | [2.2.206](2.2.206-download.md) |
| Windows | Visual Studio 2017 | [2.2.109](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/en-us/visualstudio/mac/net-core-support) |

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://hub.docker.com/_/microsoft-dotnet-core-runtime/)
* [dotnet/core/sdk](https://hub.docker.com/_/microsoft-dotnet-core-sdk/)
* and others

The images are expected to be available later today.

### Azure AppServices

* .NET Core 2.2.7 is being deployed to Azure App Services and the deployment is expected to complete later in Sept 2019.

## Changes in 2.2.7

.NET Core 2.2.7 release carries both security and non-security fixes.

### [CVE-2019-1302: ASP.NET Core Elevation Of Privilege Vulnerability](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-1302)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of an elevation of privilege vulnerability exists when a ASP.NET Core web application, created using vulnerable project templates, fails to properly sanitize web requests. An attacker who successfully exploited this vulnerability could perform content injection attacks and run script in the security context of the logged-on user.

To exploit the vulnerability, an attacker could send a specially crafted email, containing a malicious link, to a user. Alternatively, an attacker could use a chat client to social engineer a user into clicking the malicious link. However, in all cases to exploit this vulnerability a user must click a maliciously crafted link from an attacker.

The update addresses the vulnerability by correcting how the .NET Core web application handles content encoding and updates the application templates to depend on the corrected code libraries.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.SpaServices  | 2.1.0-2.1.2 <br> 2.2.0 | 2.1.2 <br> 2.2.1

### [CVE-2019-1301: Denial of Service Vulnerability in .NET Core](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2019-1301)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability when .NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core web application. The vulnerability can be exploited remotely, without authentication.

The update addresses the vulnerability by correcting how the .NET Core web application handles web requests.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
System.Net.Sockets | 4.3.0 | 4.3.1
Microsoft.NetCore.App | 2.1.0 - 2.1.12 <br> 2.2.0 - 2.2.6 | 2.1.13 <br> 2.2.7

###[CVE-2018-8269: Denial of Service Vulnerability in OData](https://portal.msrc.microsoft.com/en-us/security-guidance/advisory/CVE-2018-8269)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service attack in the Microsoft OData library used in ASP.NET could cause a denial of service against an OData web application. A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the OData application.

The update addresses the vulnerability by updating the version of OData ASP.NET Core uses.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.DataProtection.AzureStorage | 2.1.0 - 2.1.12 <br> 2.2.0 - 2.2.6  | 2.1.13 <br> 2.2.7
Microsoft.Data.OData.dll                         | < 5.8.4             | 5.8.5
Microsoft.AspNetCore.All                         | 2.1.0 - 2.1.12 <br> 2.2.0 - 2.2.6 | 2.1.13 <br> 2.2.7

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.2.7+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.2.7+label%3Aservicing-approved)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:2.2.7+label:servicing-approved)
* [ASP.NETCore](https://github.com/search?q=user:aspnet+is:pr+label:Servicing-approved+milestone:2.2.7)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.Data.OData.dll | 5.8.4
microsoft.aspnetcore.all | 2.2.7
microsoft.aspnetcore.app | 2.2.7
microsoft.aspnetcore.dataprotection.azurestorage | 2.2.7
microsoft.aspnetcore.hosting | 2.2.7
microsoft.aspnetcore.spaservices | 2.2.7
microsoft.dotnet.web.client.itemtemplates | 2.2.7
microsoft.dotnet.web.itemtemplates | 2.2.7
microsoft.dotnet.web.projecttemplates.2.2 | 2.2.7
microsoft.dotnet.web.spa.projecttemplates.2.2 | 2.2.7
System.Net.Sockets | 4.3.1
microsoft.netcore.platforms | 2.2.3
microsoft.netcore.app | 2.2.7
microsoft.netcore.dotnetapphost | 2.2.7
microsoft.netcore.dotnethost | 2.2.7
microsoft.netcore.dotnethostpolicy | 2.2.7
microsoft.netcore.dotnethostresolver | 2.2.7
runtime.linux-arm.microsoft.netcore.app | 2.2.7
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.2.7
runtime.linux-arm.microsoft.netcore.dotnethost | 2.2.7
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.linux-arm64.microsoft.netcore.app | 2.2.7
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.2.7
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.linux-musl-x64.microsoft.netcore.app | 2.2.7
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.2.7
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.linux-x64.microsoft.netcore.app | 2.2.7
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.linux-x64.microsoft.netcore.dotnethost | 2.2.7
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.osx-x64.microsoft.netcore.app | 2.2.7
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.osx-x64.microsoft.netcore.dotnethost | 2.2.7
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.rhel.6-x64.microsoft.netcore.app | 2.2.7
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.2.7
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.win-arm.microsoft.netcore.app | 2.2.7
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.2.7
runtime.win-arm.microsoft.netcore.dotnethost | 2.2.7
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.win-arm64.microsoft.netcore.app | 2.2.7
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.win-arm64.microsoft.netcore.dotnethost | 2.2.7
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.win-x64.microsoft.netcore.app | 2.2.7
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.2.7
runtime.win-x64.microsoft.netcore.dotnethost | 2.2.7
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.2.7
runtime.win-x86.microsoft.netcore.app | 2.2.7
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.2.7
runtime.win-x86.microsoft.netcore.dotnethost | 2.2.7
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.2.7
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.2.7

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.2/2.2.7/2.2.7.md

[//]: # ( Runtime 2.2.7)
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/51c29196-43b3-47d6-a393-d0df24081ac1/8b8d720b3cd63d88a2fd69115ab713c5/dotnet-hosting-2.2.7-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6147382e-bccd-4800-ac45-19db334518ad/389c7a0554fab6994a48e546def1b636/dotnet-runtime-2.2.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/330ee296-1713-47b5-b03d-970fc92ca810/f355be326512dd2cdae5a5ae7115cb5c/dotnet-runtime-2.2.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ae594623-ff74-42a2-8662-8c7364c8d497/b7b01b805df4e665c0e34d5f94ff804c/dotnet-runtime-2.2.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc8dd18d-e165-4f58-a821-d657eea08bf1/efd846172658c27dde2d9eafa7d0082e/dotnet-runtime-2.2.7-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9d500871-7711-479c-9365-acc9b07f7f11/c02dba8552cd0d9d9147891210916b86/dotnet-runtime-2.2.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d74e062f-f70c-421f-8dca-c9c80d742c17/a7d2ec01f62b38ffaf65fcd25f2fcf1c/dotnet-runtime-2.2.7-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e45dd28b-ec55-4e1f-86c4-876343189a21/2d892c8d2378e3e5306e7c30ae851d5d/dotnet-runtime-2.2.7-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/45d28fd9-e8c0-450b-838f-77ec6fe54c99/e65179c55b9fa9b2ba897a30fee82e11/dotnet-runtime-2.2.7-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a803822b-178b-4d21-bb7c-aaa1d209c341/e77c5ca1d0ea9963346655e2ec2733f2/dotnet-runtime-2.2.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/511058f3-87d6-4fa2-9be1-bfa1b4867d7b/fc629b13c0c1a55557bf699de0197ccd/dotnet-runtime-2.2.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2b9e6f98-53ba-412d-8a4e-cb4092d8a293/602c597f378f5c5d527e91e1fa1ebb55/dotnet-runtime-2.2.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c5f8a2ef-c12c-4fd2-b54c-e96ff475aa0c/9564dd351b06bd259cd637157819dada/dotnet-runtime-2.2.7-win-x86.zip

[//]: # ( ASP 2.2.7)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ea963afd-3b38-46c1-b058-c4ccbf862e48/6edc7bde8816cb981e8d0c1e5bf21718/aspnetcore-runtime-2.2.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f41f5f74-41d3-42e6-9f01-d6aa069a9fe5/0a10244daf90ed6b8a4b96a35f4140e3/aspnetcore-runtime-2.2.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f0b6c052-2f5d-42b9-8ffa-870ea2a60d11/90c1d5b4a2548c1beaeacff0a39a459c/aspnetcore-runtime-2.2.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1485ff28-81f0-425c-9127-bce5921818db/e29f612db8c106e969423253d1dac691/aspnetcore-runtime-2.2.7-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/32fa5a05-2e47-4ccb-939f-ea4feb843d4f/736d9841c8d36385c4ec5028dba07332/aspnetcore-runtime-2.2.7-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/db9a9e04-60df-45c2-8108-cc532be2f0e4/92896677a17af8c0adcfaf45231832f2/aspnetcore-runtime-2.2.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ead2ca87-df10-4194-a216-496033367ee2/7d62804a5ba6170d9458588dbbbec8e3/aspnetcore-runtime-2.2.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/bd37a7fd-b368-41c7-9695-20efd6b3be0e/bc365dafed915888b4e2cefe3c8dbc66/aspnetcore-runtime-2.2.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/deb38af9-fd79-4a3f-a8e4-0de4d781e1bd/9301efd7540caa8ad232420f2cbac118/aspnetcore-runtime-2.2.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/51c29196-43b3-47d6-a393-d0df24081ac1/8b8d720b3cd63d88a2fd69115ab713c5/dotnet-hosting-2.2.7-win.exe

[//]: # ( SDK 2.2.109 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b732756-b8dc-4611-8eec-f69d3d357256/8884e240efd4a5ebf2941fea6c2905c1/dotnet-sdk-2.2.109-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ad1540d9-b2a6-456c-bb3a-320e74a6beb9/b7e0370fd095d58dfc8dfa70e3ca7bd4/dotnet-sdk-2.2.109-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cb12ddf-641e-4733-9f37-183e94095d17/1c9a255adf3724ee60f201794d2e9a02/dotnet-sdk-2.2.109-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d09cdd5-2b32-4e8b-a9a0-a8d4f0096ed0/603111ff75f5a3b6fe7d13a40c184678/dotnet-sdk-2.2.109-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0c022dcc-570d-4492-b356-a9f6f767e70c/aa2dc6b52682ec96528745fc591403b1/dotnet-sdk-2.2.109-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e70be3ce-7c70-4550-88a9-ccf060e0e287/811a6f0bda4a831d1059239674349428/dotnet-sdk-2.2.109-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/23245995-5ae5-449e-9619-410e6fd25f2f/4174cfbf6e541cf67d8c31e9f60cc1b8/dotnet-sdk-2.2.109-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/95b080e0-60a7-4709-8576-e0d2839182b5/ed2b4df52ac07b3c916580afa37fcb18/dotnet-sdk-2.2.109-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f4fc2718-bc21-4a97-ac01-426aed568946/a5f6b770c7396ad1eb71355e4dc234f6/dotnet-sdk-2.2.109-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/42de37cd-5271-417d-9e02-e5a382812639/bb142cc57ff671e055aba3fe13e24f80/dotnet-sdk-2.2.109-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/de841c2f-71ca-47f9-8142-e5761bc0aa25/b9aec5fa638e4ebef836ed576ada98e1/dotnet-sdk-2.2.109-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a73b5648-813f-4bf7-843d-42c843e04932/3d65c355abee4f461d83a02bff237533/dotnet-sdk-2.2.109-win-x86.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.7-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.7-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-september-2019/
