# .NET Core SDK 2.2.200 Preview

.NET Core SDK 2.2.200-preview comprises:

* .NET Core Runtime 2.2.0
* ASP.NET Core 2.2.0
* .NET Core SDK 2.2.200-preview-009648

See the [Release Notes][release-notes] for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically incude package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications

Note: Installers for Preview versions are not made available on the package repository. To use a Preview version, see the [Installation from a binary archive](#installation-from-a-binary-archive) below.

### Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.2
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.2` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.2` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.2.0-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/2.2/Preview/2.2.200-preview.md

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/860e937d-aa99-4047-b957-63b4cba047de/da5ed8a5e7c1ac3b4f3d59469789adac/aspnetcore-runtime-2.2.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60655cf9-5d19-4146-ac65-7ce8a23b5a4b/4393f9d9c5ebe85a2e27d83f500a6562/aspnetcore-runtime-2.2.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/69ee3993-54fe-4687-9388-25b1e0c888fb/df2ba0637e68f6e8ee212a38756a4002/aspnetcore-runtime-2.2.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/569b6c23-1b22-458f-91d0-b7b45ad4efcd/daafc07506cf1e42d62b6df0c1843515/aspnetcore-runtime-2.2.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/7f19b834-339a-41b2-8709-0f29dcb27ce8/e062f2bc065c89ae80d3f5a118534664/aspnetcore-runtime-2.2.0-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4d87102c-31b3-46a0-bf94-698a12481366/a1c3cdf6cc5a5029b58329954430129b/aspnetcore-runtime-2.2.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8073bb2c-6e05-4486-81eb-f37cb714a1b6/03ffd5e3934f6143cdfc87e04ccc3797/aspnetcore-runtime-2.2.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/70800ed3-22cd-4111-9e00-e9fc3535d5c6/f7b76341e582f3a8952b7fdec06e0646/aspnetcore-runtime-2.2.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3974a408-f437-44e7-8bf2-8ccf7f6ef73e/bcc8807e64d3b24c8cfd43e9f47521e5/aspnetcore-runtime-2.2.0-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/48adfc75-bce7-4621-ae7a-5f3c4cf4fc1f/9a8e07173697581a6ada4bf04c845a05/dotnet-hosting-2.2.0-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3f3e38e-246a-4eab-8da3-63f9cd1b1c13/c2e795a9bb03bc75d3cfa767f3f77310/dotnet-runtime-2.2.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8931cb99-76f8-4d62-82be-881b79b03aac/9b31f0cbd0caac6d1639cece76d414a8/dotnet-runtime-2.2.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6bb6c059-a9fe-44ad-9f9e-12027c858253/2742ebd7660077902e4a5f3f85d156c7/dotnet-runtime-2.2.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1057e14e-16cc-410b-80a4-5c2420c8359c/004dc3ce8255475d4723de9a011ac513/dotnet-runtime-2.2.0-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/953c69dc-2b70-4237-89e8-d0675d8e89b7/4ccde130c14f69659da5826c0b2fbe95/dotnet-runtime-2.2.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1d8682c5-f211-4724-9f6b-0d44eb1593d4/32d8ff5607122a05e2200fe0961cfc40/dotnet-runtime-2.2.0-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/279664c2-a29a-423b-967d-d58bc7abe14c/a40e0f1065c062b6dc91cf4523111513/dotnet-runtime-2.2.0-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/42443f24-e035-42c2-a998-57f58a7573ea/d885e17a85793394ad12b804999cfc32/dotnet-runtime-2.2.0-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/be1aa948-6b3a-418c-bb85-5bb8ca4be04c/8aa70e41272cbaf2b619b4cd4824974b/dotnet-runtime-2.2.0-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/03b9322b-c24d-4219-a092-baf7d6e4d124/83a706f62a41c466805dedc23429427b/dotnet-runtime-2.2.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/62711024-fa98-4919-9fe0-466744b20941/4cdef0431350a441b45e11784f657b09/dotnet-runtime-2.2.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2ed3aa9d-dd33-4a00-bb51-814de2b92d0c/0624fc37ff340d2b38c95a1f667de99c/dotnet-runtime-2.2.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ab4bbec2-ace5-487b-85fd-4ac897440040/23e50fbfc65d3b54aec21107eeb0a66d/dotnet-runtime-2.2.0-win-x86.zip

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d11e6fa7-15b3-403d-b1ba-1323b68eb373/b215c2a4c824da07d4ce88aa6fbc5df9/dotnet-sdk-2.2.200-preview-009648-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/afadab69-62e9-46da-ab2a-5fdf366f845a/4ea5a406c72a5337e4538a428ff5da8b/dotnet-sdk-2.2.200-preview-009648-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a073581b-7bad-4e17-9b87-289e1d5842f1/d25a9bd2fc81518a72adbd198d7ab853/dotnet-sdk-2.2.200-preview-009648-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a468e998-a2cc-45bb-a945-1f40ca0a900d/e55dd2721e208b7b75890872303dbc9a/dotnet-sdk-2.2.200-preview-009648-linux-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a468e998-a2cc-45bb-a945-1f40ca0a900d/e55dd2721e208b7b75890872303dbc9a/dotnet-sdk-2.2.200-preview-009648-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3abc8bb6-1363-4474-b15e-a1adee8ca025/3dea0f3bf25595abb2b1245ea0f8245e/dotnet-sdk-2.2.200-preview-009648-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8da9ecec-dbbe-4a8c-af89-2fd750149176/aed92edd168b873df57df5893b50eb6d/dotnet-sdk-2.2.200-preview-009648-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e1d58f6-5270-4142-9931-19b05d4a2a01/615ca51732a296d2d19fb2d877ae3caa/dotnet-sdk-2.2.200-preview-009648-rhel.6-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e1d58f6-5270-4142-9931-19b05d4a2a01/615ca51732a296d2d19fb2d877ae3caa/dotnet-sdk-2.2.200-preview-009648-rhel.6-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e1d58f6-5270-4142-9931-19b05d4a2a01/615ca51732a296d2d19fb2d877ae3caa/dotnet-sdk-2.2.200-preview-009648-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8145cebd-ea45-4b3d-b13a-9f37c7be0588/00b4a7ed7952412edcaee68e181d72c4/dotnet-sdk-2.2.200-preview-009648-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/607bb33c-e356-449c-a957-ef72c80eeac2/7c2dab909c9a5c6698720c9e5a145701/dotnet-sdk-2.2.200-preview-009648-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9182f8b1-0b48-45da-ba29-ff2e06ad07ce/2c4a3dc1958867a54b1abe1a73ccbcac/dotnet-sdk-2.2.200-preview-009648-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9e523b8c-4721-47f4-93a9-fb2d6b0f788a/0e18b3e6524cbf6cd7c6a21ffd72827a/dotnet-sdk-2.2.200-preview-009648-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/e0c8c95e-4e4c-4cc3-9b5c-7c6740feba1f/3cae4aeb08ededcc4b6d0986eee3fb80/aspnet-2.2.0-symbols.zip
[aspnet-extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/81c09839-3d1f-42d8-8a14-a52cba70c8a4/04280557d2b96f0840cbf4c4ea59937c/aspnet-extensions-2.2.0-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/53b39749-d31a-4272-a280-8d3cd1974922/da1c0fb161ecdc0c09810b98bb115ffb/core-setup-2.2.0-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/a6a3fcc6-e72c-4d56-a002-c1ea2ebf491b/b00ec1d7aeee16b002579e7855d8574a/coreclr-2.2.0-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6576cf85-ad10-49c7-ab3f-f26c2ba1e518/621fc14558560a3c585697ee5e77993a/corefx-2.2.0-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/4b233b85-7b9b-4e7b-a2ed-62fd6017b65e/91ed01dbe66f087e9d7b5f0a7c97f289/dotnet-sdk-2.2.0-symbols.zip
[templating-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/52249021-0c7f-477a-b961-72b64694fb47/22b0006ce020a668309a2c254f2996f4/templating-2.2.0-symbols.zip
[websdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0ecfbde4-d827-4e2a-b2ae-b67f1e72495b/8a5e533a4b846d6877be4420a42664fd/websdk-2.2.0-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6819ef7a-d432-4900-a242-78ee5e6b80e9/297807fa4167c35f4090eb6f39698df2/sdk-symbols-2.2.200-preview-009648-symbols.zip
[sdk-symbols-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6819ef7a-d432-4900-a242-78ee5e6b80e9/297807fa4167c35f4090eb6f39698df2/sdk-symbols-2.2.200-preview-009648-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.0-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.200-preview-009648-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/
