# System.ComponentModel.Composition.Registration

``` diff
+namespace System.ComponentModel.Composition.Registration {
+    public sealed class ExportBuilder {
+        public ExportBuilder();
+        public ExportBuilder AddMetadata(string name, Func<Type, object> itemFunc);
+        public ExportBuilder AddMetadata(string name, object value);
+        public ExportBuilder AsContractName(string contractName);
+        public ExportBuilder AsContractType(Type type);
+        public ExportBuilder AsContractType<T>();
+        public ExportBuilder Inherited();
+    }
+    public sealed class ImportBuilder {
+        public ImportBuilder();
+        public ImportBuilder AllowDefault();
+        public ImportBuilder AllowRecomposition();
+        public ImportBuilder AsContractName(string contractName);
+        public ImportBuilder AsContractType(Type type);
+        public ImportBuilder AsContractType<T>();
+        public ImportBuilder AsMany(bool isMany = true);
+        public ImportBuilder RequiredCreationPolicy(CreationPolicy requiredCreationPolicy);
+        public ImportBuilder Source(ImportSource source);
+    }
+    public class ParameterImportBuilder {
+        public ParameterImportBuilder();
+        public T Import<T>();
+        public T Import<T>(Action<ImportBuilder> configure);
+    }
+    public class PartBuilder {
+        public PartBuilder AddMetadata(string name, Func<Type, object> itemFunc);
+        public PartBuilder AddMetadata(string name, object value);
+        public PartBuilder Export();
+        public PartBuilder Export(Action<ExportBuilder> exportConfiguration);
+        public PartBuilder Export<T>();
+        public PartBuilder Export<T>(Action<ExportBuilder> exportConfiguration);
+        public PartBuilder ExportInterfaces();
+        public PartBuilder ExportInterfaces(Predicate<Type> interfaceFilter);
+        public PartBuilder ExportInterfaces(Predicate<Type> interfaceFilter, Action<Type, ExportBuilder> exportConfiguration);
+        public PartBuilder ExportProperties(Predicate<PropertyInfo> propertyFilter);
+        public PartBuilder ExportProperties(Predicate<PropertyInfo> propertyFilter, Action<PropertyInfo, ExportBuilder> exportConfiguration);
+        public PartBuilder ExportProperties<T>(Predicate<PropertyInfo> propertyFilter);
+        public PartBuilder ExportProperties<T>(Predicate<PropertyInfo> propertyFilter, Action<PropertyInfo, ExportBuilder> exportConfiguration);
+        public PartBuilder ImportProperties(Predicate<PropertyInfo> propertyFilter);
+        public PartBuilder ImportProperties(Predicate<PropertyInfo> propertyFilter, Action<PropertyInfo, ImportBuilder> importConfiguration);
+        public PartBuilder ImportProperties<T>(Predicate<PropertyInfo> propertyFilter);
+        public PartBuilder ImportProperties<T>(Predicate<PropertyInfo> propertyFilter, Action<PropertyInfo, ImportBuilder> importConfiguration);
+        public PartBuilder SelectConstructor(Func<ConstructorInfo[], ConstructorInfo> constructorFilter);
+        public PartBuilder SelectConstructor(Func<ConstructorInfo[], ConstructorInfo> constructorFilter, Action<ParameterInfo, ImportBuilder> importConfiguration);
+        public PartBuilder SetCreationPolicy(CreationPolicy creationPolicy);
+    }
+    public class PartBuilder<T> : PartBuilder {
+        public PartBuilder<T> ExportProperty(Expression<Func<T, object>> propertyFilter);
+        public PartBuilder<T> ExportProperty(Expression<Func<T, object>> propertyFilter, Action<ExportBuilder> exportConfiguration);
+        public PartBuilder<T> ExportProperty<TContract>(Expression<Func<T, object>> propertyFilter);
+        public PartBuilder<T> ExportProperty<TContract>(Expression<Func<T, object>> propertyFilter, Action<ExportBuilder> exportConfiguration);
+        public PartBuilder<T> ImportProperty(Expression<Func<T, object>> propertyFilter);
+        public PartBuilder<T> ImportProperty(Expression<Func<T, object>> propertyFilter, Action<ImportBuilder> importConfiguration);
+        public PartBuilder<T> ImportProperty<TContract>(Expression<Func<T, object>> propertyFilter);
+        public PartBuilder<T> ImportProperty<TContract>(Expression<Func<T, object>> propertyFilter, Action<ImportBuilder> importConfiguration);
+        public PartBuilder<T> SelectConstructor(Expression<Func<ParameterImportBuilder, T>> constructorFilter);
+    }
+    public class RegistrationBuilder : CustomReflectionContext {
+        public RegistrationBuilder();
+        public PartBuilder ForType(Type type);
+        public PartBuilder<T> ForType<T>();
+        public PartBuilder ForTypesDerivedFrom(Type type);
+        public PartBuilder<T> ForTypesDerivedFrom<T>();
+        public PartBuilder ForTypesMatching(Predicate<Type> typeFilter);
+        public PartBuilder<T> ForTypesMatching<T>(Predicate<Type> typeFilter);
+        protected override IEnumerable<object> GetCustomAttributes(MemberInfo member, IEnumerable<object> declaredAttributes);
+        protected override IEnumerable<object> GetCustomAttributes(ParameterInfo parameter, IEnumerable<object> declaredAttributes);
+    }
+}
```

