# System.Security.Permissions

``` diff
 namespace System.Security.Permissions {
+    public sealed class DataProtectionPermission : CodeAccessPermission, IUnrestrictedPermission {
+        public DataProtectionPermission(DataProtectionPermissionFlags flag);
+        public DataProtectionPermission(PermissionState state);
+        public DataProtectionPermissionFlags Flags { get; set; }
+        public override IPermission Copy();
+        public override void FromXml(SecurityElement securityElement);
+        public override IPermission Intersect(IPermission target);
+        public override bool IsSubsetOf(IPermission target);
+        public bool IsUnrestricted();
+        public override SecurityElement ToXml();
+        public override IPermission Union(IPermission target);
+    }
+    public sealed class DataProtectionPermissionAttribute : CodeAccessSecurityAttribute {
+        public DataProtectionPermissionAttribute(SecurityAction action);
+        public DataProtectionPermissionFlags Flags { get; set; }
+        public bool ProtectData { get; set; }
+        public bool ProtectMemory { get; set; }
+        public bool UnprotectData { get; set; }
+        public bool UnprotectMemory { get; set; }
+        public override IPermission CreatePermission();
+    }
+    public enum DataProtectionPermissionFlags {
+        AllFlags = 15,
+        NoFlags = 0,
+        ProtectData = 1,
+        ProtectMemory = 4,
+        UnprotectData = 2,
+        UnprotectMemory = 8,
+    }
+    public sealed class MediaPermission : CodeAccessPermission, IUnrestrictedPermission {
+        public MediaPermission();
+        public MediaPermission(MediaPermissionAudio permissionAudio);
+        public MediaPermission(MediaPermissionAudio permissionAudio, MediaPermissionVideo permissionVideo, MediaPermissionImage permissionImage);
+        public MediaPermission(MediaPermissionImage permissionImage);
+        public MediaPermission(MediaPermissionVideo permissionVideo);
+        public MediaPermission(PermissionState state);
+        public MediaPermissionAudio Audio { get; }
+        public MediaPermissionImage Image { get; }
+        public MediaPermissionVideo Video { get; }
+        public override IPermission Copy();
+        public override void FromXml(SecurityElement securityElement);
+        public override IPermission Intersect(IPermission target);
+        public override bool IsSubsetOf(IPermission target);
+        public bool IsUnrestricted();
+        public override SecurityElement ToXml();
+        public override IPermission Union(IPermission target);
+    }
+    public sealed class MediaPermissionAttribute : CodeAccessSecurityAttribute {
+        public MediaPermissionAttribute(SecurityAction action);
+        public MediaPermissionAudio Audio { get; set; }
+        public MediaPermissionImage Image { get; set; }
+        public MediaPermissionVideo Video { get; set; }
+        public override IPermission CreatePermission();
+    }
+    public enum MediaPermissionAudio {
+        AllAudio = 3,
+        NoAudio = 0,
+        SafeAudio = 2,
+        SiteOfOriginAudio = 1,
+    }
+    public enum MediaPermissionImage {
+        AllImage = 3,
+        NoImage = 0,
+        SafeImage = 2,
+        SiteOfOriginImage = 1,
+    }
+    public enum MediaPermissionVideo {
+        AllVideo = 3,
+        NoVideo = 0,
+        SafeVideo = 2,
+        SiteOfOriginVideo = 1,
+    }
+    public sealed class WebBrowserPermission : CodeAccessPermission, IUnrestrictedPermission {
+        public WebBrowserPermission();
+        public WebBrowserPermission(PermissionState state);
+        public WebBrowserPermission(WebBrowserPermissionLevel webBrowserPermissionLevel);
+        public WebBrowserPermissionLevel Level { get; set; }
+        public override IPermission Copy();
+        public override void FromXml(SecurityElement securityElement);
+        public override IPermission Intersect(IPermission target);
+        public override bool IsSubsetOf(IPermission target);
+        public bool IsUnrestricted();
+        public override SecurityElement ToXml();
+        public override IPermission Union(IPermission target);
+    }
+    public sealed class WebBrowserPermissionAttribute : CodeAccessSecurityAttribute {
+        public WebBrowserPermissionAttribute(SecurityAction action);
+        public WebBrowserPermissionLevel Level { get; set; }
+        public override IPermission CreatePermission();
+    }
+    public enum WebBrowserPermissionLevel {
+        None = 0,
+        Safe = 1,
+        Unrestricted = 2,
+    }
 }
```

