# Microsoft.AspNetCore.Http.Connections.Client

``` diff
 {
     namespace Microsoft.AspNetCore.Http.Connections.Client {
         public class HttpConnection : ConnectionContext, IConnectionInherentKeepAliveFeature {
-            public Task DisposeAsync();

+            public override ValueTask DisposeAsync();
         }
+        public class HttpConnectionFactory : IConnectionFactory {
+            public HttpConnectionFactory(IOptions<HttpConnectionOptions> options, ILoggerFactory loggerFactory);
+            public ValueTask<ConnectionContext> ConnectAsync(EndPoint endPoint, CancellationToken cancellationToken = default(CancellationToken));
+        }
         public class HttpConnectionOptions {
+            public TransferFormat DefaultTransferFormat { get; set; }
         }
+        public class NoTransportSupportedException : Exception {
+            public NoTransportSupportedException(string message);
+        }
+        public class TransportFailedException : Exception {
+            public TransportFailedException(string transportType, string message, Exception innerException = null);
+            public string TransportType { get; }
+        }
     }
-    namespace Microsoft.AspNetCore.Http.Connections.Client.Internal {
 {
-        public interface ITransport : IDuplexPipe {
 {
-            Task StartAsync(Uri url, TransferFormat transferFormat);

-            Task StopAsync();

-        }
-        public interface ITransportFactory {
 {
-            ITransport CreateTransport(HttpTransportType availableServerTransports);

-        }
-        public class LongPollingTransport : IDuplexPipe, ITransport {
 {
-            public LongPollingTransport(HttpClient httpClient);

-            public LongPollingTransport(HttpClient httpClient, ILoggerFactory loggerFactory);

-            public PipeReader Input { get; }

-            public PipeWriter Output { get; }

-            public Task StartAsync(Uri url, TransferFormat transferFormat);

-            public Task StopAsync();

-        }
-        public class ServerSentEventsTransport : IDuplexPipe, ITransport {
 {
-            public ServerSentEventsTransport(HttpClient httpClient);

-            public ServerSentEventsTransport(HttpClient httpClient, ILoggerFactory loggerFactory);

-            public PipeReader Input { get; }

-            public PipeWriter Output { get; }

-            public Task StartAsync(Uri url, TransferFormat transferFormat);

-            public Task StopAsync();

-        }
-        public class WebSocketsTransport : IDuplexPipe, ITransport {
 {
-            public WebSocketsTransport(HttpConnectionOptions httpConnectionOptions, ILoggerFactory loggerFactory, Func<Task<string>> accessTokenProvider);

-            public PipeReader Input { get; }

-            public PipeWriter Output { get; }

-            public Task StartAsync(Uri url, TransferFormat transferFormat);

-            public Task StopAsync();

-        }
-    }
 }
```

