# Microsoft.Extensions.Configuration

``` diff
 {
     namespace Microsoft.Extensions.Configuration {
         public static class ChainedBuilderExtensions {
+            public static IConfigurationBuilder AddConfiguration(this IConfigurationBuilder configurationBuilder, IConfiguration config, bool shouldDisposeConfiguration);
         }
-        public class ChainedConfigurationProvider : IConfigurationProvider {
+        public class ChainedConfigurationProvider : IConfigurationProvider, IDisposable {
+            public void Dispose();
         }
         public class ChainedConfigurationSource : IConfigurationSource {
+            public bool ShouldDisposeConfiguration { get; set; }
         }
         public abstract class ConfigurationProvider : IConfigurationProvider {
+            public override string ToString();
         }
-        public class ConfigurationRoot : IConfiguration, IConfigurationRoot {
+        public class ConfigurationRoot : IConfiguration, IConfigurationRoot, IDisposable {
+            public void Dispose();
         }
         public class ConfigurationSection : IConfiguration, IConfigurationSection {
-            public ConfigurationSection(ConfigurationRoot root, string path);

+            public ConfigurationSection(IConfigurationRoot root, string path);
         }
+        public abstract class StreamConfigurationProvider : ConfigurationProvider {
+            public StreamConfigurationProvider(StreamConfigurationSource source);
+            public StreamConfigurationSource Source { get; }
+            public override void Load();
+            public abstract void Load(Stream stream);
+        }
+        public abstract class StreamConfigurationSource : IConfigurationSource {
+            protected StreamConfigurationSource();
+            public Stream Stream { get; set; }
+            public abstract IConfigurationProvider Build(IConfigurationBuilder builder);
+        }
     }
 }
```

