# .NET Core 3.0.0 Preview 7

.NET Core 3.0.0 Preview 7 comprises:

* .NET Core Runtime 3.0.0-preview7-27912-14
* ASP.NET Core 3.0.0-preview7.19365.7
* .NET Core SDK 3.0.100-preview7-012821

See the [Release Notes][release-notes] for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz] \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Because of the isolated environment, using Snap is the preferred way to install and try .NET Core Previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel=beta --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for a possible resolution.

### Install using deb/rpm packages

Preview release installers are not available from the Microsoft package repositories but you can download them and install manually or, set up a local package repository. Setting up a local package repository will result in a typical package manager installation experience. Consult your distros documentation to understand this option.

A manual installatoin requires the use of your distro's package installer to install each of the files *in the order presented below.* If you attempt to install them out of order, dependency checks will not succeed and the installation will fail. Download the correct System Dependencies Installer along with the `host, hostfxr, runtime, aspnetcore-runtime` and `sdk` installers.

Please see the [3.0 Supported OS](https://github.com/dotnet/core/blob/master/release-notes/3.0/3.0-supported-os.md) document for specific distro version support status.

| **System Dependencies Installer** |
| :-- |
| [Centos 7][dotnet-runtime-deps-centos.7-x64.rpm] |
| [Fedora][dotnet-runtime-deps-fedora.27-x64.rpm] |
| [OpenSUSE][dotnet-runtime-deps-opensuse.42-x64.rpm] |
| [Oracle Linux 7][dotnet-runtime-deps-oraclelinux.7-x64.rpm] |
| [RHEL 7][dotnet-runtime-deps-rhel.7-x64.rpm] |
| [SLES 12][dotnet-runtime-deps-sles.12-x64.rpm] |
| [Debian-based systems][dotnet-runtime-deps-x64.deb] |

| **Component** | **Package Type** |
| :--- | :---: |
| dotnet-host | [deb][dotnet-host-x64.deb] \| [rpm][dotnet-host-x64.rpm] |
| dotnet-hostfxr | [deb][dotnet-hostfxr-x64.deb] \| [rpm][dotnet-hostfxr-x64.rpm] |
| dotnet-runtime | [deb][dotnet-runtime-x64.deb] \| [rpm][dotnet-runtime-x64.rpm] |
| aspnetcore-runtime | [deb][aspnetcore-runtime-x64.deb] \| [rpm][aspnetcore-runtime-x64.rpm] |
| dotnet-targeting-pack | [deb][dotnet-targeting-pack-x64.deb] \| [rpm][dotnet-targeting-pack-x64.rpm] |
| dotnet-apphost-targeting-pack | [deb][dotnet-apphost-pack-x64.deb] \| [rpm][dotnet-apphost-pack-x64.rpm] |
| aspnetcore-targeting-pack | [deb][aspnetcore-targeting-pack.deb] \| [rpm][aspnetcore-targeting-pack.rpm] |
| netstandard-targeting-pack | [deb][netstandard-targeting-pack-x64.deb] \| [rpm][netstandard-targeting-pack-x64.rpm] |
| dotnet-sdk | [deb][dotnet-sdk-x64.deb] \| [rpm][dotnet-sdk-x64.rpm] |

After downloading the files, run your package utility to install the files in the following order.

1. dotnet-runtime-deps (System Dependencies Installer)
2. dotnet-host
3. dotnet-hostfxr
4. dotnet-runtime
5. aspnetcore-runtime
6. dotnet-targeting-pack
7. dotnet-apphost-targeting-pack
8. aspnetcore-targeting-pack
9. netstandard-targeting-pack
10. dotnet-sdk

**CentOS, Fedora, OpenSUSE, Oracle Linux, RHEL and SLES** 
`sudo rpm -ivh [package name]`

**Debian and Ubuntu** 
`sudo dpkg -i [package name]`

Here is a simple example script for Fedora to download and install the packages as described above. 

``` bash
cd $HOME/Downloads
mkdir preview7
cd preview7

wget -c https://download.visualstudio.microsoft.com/download/pr/21c1edcc-4296-45fe-9e09-b5f0b992ec04/4119552e4774c7d2289cdac1b41d005d/dotnet-host-3.0.0-preview7-27912-14-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/e1d79e2c-7d95-46be-a394-7ada4821fdb9/3a36e07e3d8db39db289123fa0c339eb/dotnet-hostfxr-3.0.0-preview7-27912-14-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/db43af51-c07c-4ce2-8ac9-ea3ef2c6ab9a/9fe1680c15cb421765e18a010fe8d4e8/dotnet-runtime-3.0.0-preview7-27912-14-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/72b648e4-3f67-4311-86a6-5a7ccb29905a/d7252cc35caaab93516eb3acef41fcce/dotnet-runtime-deps-3.0.0-preview7-27912-14-fedora.27-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/9da0987c-e44a-4e20-b6d7-7fe8710af24f/c8398b1c24181cb401481bfda1d91951/aspnetcore-runtime-3.0.0-preview7.19365.7-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/e0762c9a-6e37-410d-9b32-254f3f19106a/bc7f3d5980afb56aae800f91388cba9d/dotnet-sdk-3.0.100-preview7-012821-x64.rpm

wget -c https://download.visualstudio.microsoft.com/download/pr/43e76dc3-cfd3-42e0-b94e-9c0f9beb2fb1/14a7ca8b7ead99847fc5b4c0ca695a59/dotnet-apphost-pack-3.0.0-preview7-27912-14-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/6b849cd7-8bc4-4825-9896-1a4dad65a0a0/deb315e5aa6514ca2cec7609612dca79/dotnet-targeting-pack-3.0.0-preview7-27912-14-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/6540efb8-9920-4055-99d2-fb4c43553490/6d40a70c3b6402e5aa6fa10e5de74850/netstandard-targeting-pack-2.1.0-preview7-27912-14-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/219d6a6b-1d89-4568-b948-59fe9e641f74/d2538df6dceb35a292a2f87a494d6b1b/aspnetcore-targeting-pack-3.0.0-preview7.19365.7.rpm

sudo rpm -ivh dotnet-runtime-deps-3.0.0-preview7-27912-14-fedora.27-x64.rpm
sudo rpm -ivh dotnet-host-3.0.0-preview7-27912-14-x64.rpm
sudo rpm -ivh dotnet-hostfxr-3.0.0-preview7-27912-14-x64.rpm
sudo rpm -ivh dotnet-runtime-3.0.0-preview7-27912-14-x64.rpm
sudo rpm -ivh aspnetcore-runtime-3.0.0-preview7.19365.7-x64.rpm
sudo rpm -ivh dotnet-apphost-pack-3.0.0-preview7-27912-14-x64.rpm
sudo rpm -ivh dotnet-targeting-pack-3.0.0-preview7-27912-14-x64.rpm
sudo rpm -ivh netstandard-targeting-pack-2.1.0-preview7-27912-14-x64.rpm
sudo rpm -ivh aspnetcore-targeting-pack-3.0.0-preview7.19365.7.rpm
sudo rpm -ivh dotnet-sdk-3.0.100-preview7-012821-x64.rpm
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.0` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.0` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.0.0-preview7.19365.7-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/3.0/preview/3.0.0-preview7.md

[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/75df8900-3c7c-4c83-a142-ac464aba5424/2b9621b80f3e6777d436f6aabaaced27/dotnet-host-3.0.0-preview7-27912-14-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/21c1edcc-4296-45fe-9e09-b5f0b992ec04/4119552e4774c7d2289cdac1b41d005d/dotnet-host-3.0.0-preview7-27912-14-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/14afe93a-0608-455f-835d-21bad58b79c5/0bdf5dea07ed8b2724a4a9b4f2e291c5/dotnet-hostfxr-3.0.0-preview7-27912-14-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/e1d79e2c-7d95-46be-a394-7ada4821fdb9/3a36e07e3d8db39db289123fa0c339eb/dotnet-hostfxr-3.0.0-preview7-27912-14-x64.rpm

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02a60af9-15e0-4635-9f50-7394c181cecd/e19f0798e496e6625811f9779df939fc/dotnet-runtime-3.0.0-preview7-27912-14-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d9095852-56f2-421a-a322-b254c9f5d106/dc71dc5bc53c81e868d40221316c9a09/dotnet-runtime-3.0.0-preview7-27912-14-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/523c8c81-e023-482c-83a5-1723ea48e104/2032044c9402893bcec6c6fb32d9c0ba/dotnet-runtime-3.0.0-preview7-27912-14-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ac39a59-0f01-4f2d-8a3b-41b7b6d01f21/e2db10c3498c7344aa6847721a8cb832/dotnet-runtime-3.0.0-preview7-27912-14-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/519eb30b-5850-4b5e-a874-82df9bab07fb/0fc500b49aee8b59e6b8eac668f818e4/dotnet-runtime-3.0.0-preview7-27912-14-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/38d85975-b7e9-4eb9-ab6a-cae6d09e5ef0/2763b3065f1e2bf6951e26557282bb82/dotnet-runtime-3.0.0-preview7-27912-14-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9a403fa2-5072-456e-8312-746d1b846f7a/65301afee6825496555e30cedddc67c8/dotnet-runtime-3.0.0-preview7-27912-14-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/413e4397-a862-485f-ae54-9ba2f01ee6a1/722c79fd7b8ee394e4d38fb0093d2ead/dotnet-runtime-3.0.0-preview7-27912-14-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9ef148e5-e1e2-46a5-a0bf-c556cc999204/d0e0882b1fb57b7fcf850e80ada3df4f/dotnet-runtime-3.0.0-preview7-27912-14-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7b03088b-2ab1-4a29-abd8-287e990946d4/498f424a6bda8e369806e4a765eb37db/dotnet-runtime-3.0.0-preview7-27912-14-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5dd5f4db-81b6-42d0-9a9d-b6457ef231b8/68800a8d75cc2dc92b0816b4acdeee33/dotnet-runtime-3.0.0-preview7-27912-14-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8832b0fc-e294-4ff4-829b-051655e09073/2b9f733971983809fa7811abc01b1881/dotnet-runtime-3.0.0-preview7-27912-14-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/e091a028-ba39-4fa7-b67e-ea94cc17c796/486715c7f03753721d3e36eb2802b78a/dotnet-runtime-3.0.0-preview7-27912-14-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/db43af51-c07c-4ce2-8ac9-ea3ef2c6ab9a/9fe1680c15cb421765e18a010fe8d4e8/dotnet-runtime-3.0.0-preview7-27912-14-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/422a9ec8-ea7b-4c9a-a4f4-5c2fe97c5d03/4223ae36afed5b281c5ae67a641e6a16/dotnet-runtime-deps-3.0.0-preview7-27912-14-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/72b648e4-3f67-4311-86a6-5a7ccb29905a/d7252cc35caaab93516eb3acef41fcce/dotnet-runtime-deps-3.0.0-preview7-27912-14-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/faa95feb-79e1-4a15-ab9b-f09d7ba95c23/c9effc067e18a3a72db36c16683dd00a/dotnet-runtime-deps-3.0.0-preview7-27912-14-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6aaffc73-62d5-4642-8877-2605c3be5781/0be97744d82d73f6e1db842d0dfd2185/dotnet-runtime-deps-3.0.0-preview7-27912-14-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/cb7bdfbc-6535-4197-8b91-daed8438d43d/6a2f3f1b55458426587da52e2d29e387/dotnet-runtime-deps-3.0.0-preview7-27912-14-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/598d1ea4-6d87-4612-876a-d7f505473fd8/cf2a4f643df307ff5f3a124f82eed8ae/dotnet-runtime-deps-3.0.0-preview7-27912-14-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/d2aa2c7e-d7f5-4868-9217-63f8b5a9cc2e/d25435ba6ff71c8959c89eb3ab8dcd21/dotnet-runtime-deps-3.0.0-preview7-27912-14-x64.deb

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4aec681-f869-494b-84b7-8891ed57f14c/44748bf22dec06c9a8c24b2c4b1dc343/aspnetcore-runtime-3.0.0-preview7.19365.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8c05daa0-f842-4f54-857d-94f066aec7bd/6206defbf72869fbc17a717edb0e5aec/aspnetcore-runtime-3.0.0-preview7.19365.7-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e95772a9-f0e5-45f4-b06d-3b53b75ccb28/d180b377fcc9fb805569a565ed5a9ab9/aspnetcore-runtime-3.0.0-preview7.19365.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/02241c22-f7c1-4eb9-a599-02c3b27461f0/00725bf30e6deadc0facc9a1757d0eea/aspnetcore-runtime-3.0.0-preview7.19365.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7b6c1370-8878-4203-8d4b-16ef649e9c3e/c9184449bb94f844150b04480006e3fd/aspnetcore-runtime-3.0.0-preview7.19365.7-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/2fa0a3dc-5e14-4916-82a3-f11fff13e8c1/71bddc4ecefc2992ea2f20fa4c3cda75/aspnetcore-runtime-3.0.0-preview7.19365.7-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/02804c86-4380-4f12-a2a7-e5a1503582a3/ea1083125d4fcd1457001ad9de239922/aspnetcore-runtime-3.0.0-preview7.19365.7-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3e73f590-8f63-4971-b382-1845e0f165d2/d3383b1cda46753f0ff351d702d5e416/aspnetcore-runtime-3.0.0-preview7.19365.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d7198b9e-fd9b-41ca-b6ab-910aaf9fe430/63fa5f438935ded6f56fa676cfac126b/aspnetcore-runtime-3.0.0-preview7.19365.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0fc46441-25dd-4058-b4e7-b1d16ae95382/5cfb6abe90b1d003dea5e295c6d2e4c2/aspnetcore-runtime-3.0.0-preview7.19365.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8aac48a1-f2ec-4592-8cb8-e037e8439eaf/7469a9bde5afb34d37a9d9a42e9ba281/aspnetcore-runtime-3.0.0-preview7.19365.7-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/24905020-03ea-4cfc-9362-c48067865fb1/9bf81548b0121de0e92565d99b2680c0/aspnetcore-runtime-3.0.0-preview7.19365.7-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/9da0987c-e44a-4e20-b6d7-7fe8710af24f/c8398b1c24181cb401481bfda1d91951/aspnetcore-runtime-3.0.0-preview7.19365.7-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/ab736c3a-7d76-4e4f-bb38-276a8461f136/e52cd442cf11475581d648c70e9a0fe9/aspnetcore-targeting-pack-3.0.0-preview7.19365.7.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/219d6a6b-1d89-4568-b948-59fe9e641f74/d2538df6dceb35a292a2f87a494d6b1b/aspnetcore-targeting-pack-3.0.0-preview7.19365.7.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bf79e503-defd-4034-a5d4-a5c055f5d589/7383e4dac92dc0cc7f1075321d6394c6/dotnet-hosting-3.0.0-preview7.19365.7-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/11d6ec80-4d7f-4100-8a54-809ed30b203e/1c0267225b22437aca9fdfe04160d1d5/dotnet-sdk-3.0.100-preview7-012821-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfc59591-60a7-47e4-80ac-c345c70daf71/38efa2e4d9a70e35e85145e7da88aa54/dotnet-sdk-3.0.100-preview7-012821-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39a668ec-feee-4655-bae9-7d2d276e3158/7df1b578dccaba181527f60d5390955a/dotnet-sdk-3.0.100-preview7-012821-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c624c5d6-0e9c-4dd9-9506-6b197ef44dc8/ad61b332f3abcc7dec3a49434e4766e1/dotnet-sdk-3.0.100-preview7-012821-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/64cb8405-ee15-4a9a-bf25-1201531f4519/b619596c137a08b204fc79a213bb9763/dotnet-sdk-3.0.100-preview7-012821-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8359b463-1d6f-4be0-b6bf-41c163e22573/9f1ad6cb14b8c622642c96933e274211/dotnet-sdk-3.0.100-preview7-012821-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b879894-41f9-4a9c-9458-40424d419336/7cf6f9883cb04b13e3a8f9a9a373399e/dotnet-sdk-3.0.100-preview7-012821-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a57b91a2-e194-47be-855c-50a301b6a6d0/6ff599db0542abbeae5ab2ce44240c37/dotnet-sdk-3.0.100-preview7-012821-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a65e3536-ad76-4808-9920-83702aeed082/3c6ab9eaa0bc99df442be91e7b7950ff/dotnet-sdk-3.0.100-preview7-012821-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/41e4c58f-3ac9-43f6-84b6-f57d2135331a/3691b61f15f1f5f844d687e542c4dc72/dotnet-sdk-3.0.100-preview7-012821-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e7e10509-f1ec-4d5c-9fe9-33a2d5a8fac0/dcf905cdac05719a5a5fa1ee1c365c4e/dotnet-sdk-3.0.100-preview7-012821-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/32653590-afde-4109-8592-f19220d5ed2e/4128a2693ad0521f4c321290496113ac/dotnet-sdk-3.0.100-preview7-012821-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/e9a2527e-e38f-4bec-9b63-2ba4dedfd748/358830b14b2a7d2ae5cf8260c041e898/dotnet-sdk-3.0.100-preview7-012821-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/e0762c9a-6e37-410d-9b32-254f3f19106a/bc7f3d5980afb56aae800f91388cba9d/dotnet-sdk-3.0.100-preview7-012821-x64.rpm

[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/e28b12ba-1e42-4749-aae1-1b3c5ed38794/202211c1e6c32569eec3e0d52638a1d6/dotnet-apphost-pack-3.0.0-preview7-27912-14-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/43e76dc3-cfd3-42e0-b94e-9c0f9beb2fb1/14a7ca8b7ead99847fc5b4c0ca695a59/dotnet-apphost-pack-3.0.0-preview7-27912-14-x64.rpm
[netstandard-targeting-pack-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/83e43735-491d-4116-bcf6-8b8627139db3/6de70e3c1d8e593f825241a6a8328df2/netstandard-targeting-pack-2.1.0-preview7-27912-14-osx-x64.pkg
[netstandard-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/5bfdb390-e660-4db9-9425-bea30457ddbc/0f2019c4665003bc5f7ea832c17ae606/netstandard-targeting-pack-2.1.0-preview7-27912-14-x64.deb
[netstandard-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6540efb8-9920-4055-99d2-fb4c43553490/6d40a70c3b6402e5aa6fa10e5de74850/netstandard-targeting-pack-2.1.0-preview7-27912-14-x64.rpm
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/0262539c-3137-4a86-9df4-f82896d16317/d8756586ecd9f55097d89f45de523059/dotnet-targeting-pack-3.0.0-preview7-27912-14-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6b849cd7-8bc4-4825-9896-1a4dad65a0a0/deb315e5aa6514ca2cec7609612dca79/dotnet-targeting-pack-3.0.0-preview7-27912-14-x64.rpm

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-preview7-27912-14-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.100-preview7-012821-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0-preview-7/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-3-0-preview-7/

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0-preview7+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0-preview7+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.0+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
