# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
+    public sealed class AesCcm : IDisposable {
+        public AesCcm(byte[] key);
+        public AesCcm(ReadOnlySpan<byte> key);
+        public static KeySizes NonceByteSizes { get; }
+        public static KeySizes TagByteSizes { get; }
+        public void Decrypt(byte[] nonce, byte[] ciphertext, byte[] tag, byte[] plaintext, byte[] associatedData = null);
+        public void Decrypt(ReadOnlySpan<byte> nonce, ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> tag, Span<byte> plaintext, ReadOnlySpan<byte> associatedData = default(ReadOnlySpan<byte>));
+        public void Dispose();
+        public void Encrypt(byte[] nonce, byte[] plaintext, byte[] ciphertext, byte[] tag, byte[] associatedData = null);
+        public void Encrypt(ReadOnlySpan<byte> nonce, ReadOnlySpan<byte> plaintext, Span<byte> ciphertext, Span<byte> tag, ReadOnlySpan<byte> associatedData = default(ReadOnlySpan<byte>));
+    }
+    public sealed class AesGcm : IDisposable {
+        public AesGcm(byte[] key);
+        public AesGcm(ReadOnlySpan<byte> key);
+        public static KeySizes NonceByteSizes { get; }
+        public static KeySizes TagByteSizes { get; }
+        public void Decrypt(byte[] nonce, byte[] ciphertext, byte[] tag, byte[] plaintext, byte[] associatedData = null);
+        public void Decrypt(ReadOnlySpan<byte> nonce, ReadOnlySpan<byte> ciphertext, ReadOnlySpan<byte> tag, Span<byte> plaintext, ReadOnlySpan<byte> associatedData = default(ReadOnlySpan<byte>));
+        public void Dispose();
+        public void Encrypt(byte[] nonce, byte[] plaintext, byte[] ciphertext, byte[] tag, byte[] associatedData = null);
+        public void Encrypt(ReadOnlySpan<byte> nonce, ReadOnlySpan<byte> plaintext, Span<byte> ciphertext, Span<byte> tag, ReadOnlySpan<byte> associatedData = default(ReadOnlySpan<byte>));
+    }
     public abstract class AsymmetricAlgorithm : IDisposable {
+        public virtual byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public virtual byte[] ExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public virtual byte[] ExportPkcs8PrivateKey();
+        public virtual byte[] ExportSubjectPublicKeyInfo();
+        public virtual void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public virtual bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public virtual bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public virtual bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public class CryptoStream : Stream, IDisposable {
+        public override ValueTask DisposeAsync();
     }
     public abstract class ECDiffieHellman : AsymmetricAlgorithm {
+        public virtual byte[] ExportECPrivateKey();
+        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);
     }
     public abstract class ECDsa : AsymmetricAlgorithm {
+        public virtual byte[] ExportECPrivateKey();
+        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);
     }
     public sealed class MD5CryptoServiceProvider : MD5 {
-        protected sealed override void Dispose(bool disposing);
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
+    public enum PbeEncryptionAlgorithm {
+        Aes128Cbc = 1,
+        Aes192Cbc = 2,
+        Aes256Cbc = 3,
+        TripleDes3KeyPkcs12 = 4,
+        Unknown = 0,
+    }
+    public sealed class PbeParameters {
+        public PbeParameters(PbeEncryptionAlgorithm encryptionAlgorithm, HashAlgorithmName hashAlgorithm, int iterationCount);
+        public PbeEncryptionAlgorithm EncryptionAlgorithm { get; }
+        public HashAlgorithmName HashAlgorithm { get; }
+        public int IterationCount { get; }
+    }
     public abstract class RandomNumberGenerator : IDisposable {
+        public static int GetInt32(int toExclusive);
+        public static int GetInt32(int fromInclusive, int toExclusive);
     }
     public sealed class RNGCryptoServiceProvider : RandomNumberGenerator {
+        public override void GetBytes(byte[] data, int offset, int count);
+        public override void GetBytes(Span<byte> data);
+        public override void GetNonZeroBytes(Span<byte> data);
     }
     public abstract class RSA : AsymmetricAlgorithm {
+        public virtual byte[] ExportRSAPrivateKey();
+        public virtual byte[] ExportRSAPublicKey();
+        public virtual void ImportRSAPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual void ImportRSAPublicKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual bool TryExportRSAPrivateKey(Span<byte> destination, out int bytesWritten);
+        public virtual bool TryExportRSAPublicKey(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA1CryptoServiceProvider : SHA1 {
-        protected sealed override void Dispose(bool disposing);
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA256CryptoServiceProvider : SHA256 {
-        protected sealed override void Dispose(bool disposing);
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA384CryptoServiceProvider : SHA384 {
-        protected sealed override void Dispose(bool disposing);
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA512CryptoServiceProvider : SHA512 {
-        protected sealed override void Dispose(bool disposing);
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
 }
```

