# System

``` diff
 namespace System {
     public readonly struct Index : IEquatable<Index> {
-        public Index(int value, bool fromEnd);
+        public Index(int value, bool fromEnd = false);
+        public static Index End { get; }
-        public bool FromEnd { get; }

+        public bool IsFromEnd { get; }
+        public static Index Start { get; }
+        public static Index FromEnd(int value);
+        public static Index FromStart(int value);
+        public int GetOffset(int length);
     }
     public readonly struct Memory<T> {
+        public Memory<T> this[Range range] { get; }
+        public Memory<T> Slice(Index startIndex);
+        public Memory<T> Slice(Range range);
     }
     public static class MemoryExtensions {
+        public static ReadOnlyMemory<char> AsMemory(this string text, Index startIndex);
+        public static ReadOnlyMemory<char> AsMemory(this string text, Range range);
+        public static Memory<T> AsMemory<T>(this T[] array, Index startIndex);
+        public static Memory<T> AsMemory<T>(this T[] array, Range range);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, Index startIndex);
+        public static Span<T> AsSpan<T>(this ArraySegment<T> segment, Range range);
+        public static Span<T> AsSpan<T>(this T[] array, Index startIndex);
+        public static Span<T> AsSpan<T>(this T[] array, Range range);
     }
     public enum MidpointRounding {
+        ToNegativeInfinity = 3,
+        ToPositiveInfinity = 4,
+        ToZero = 2,
     }
     public readonly struct Range : IEquatable<Range> {
+        public Range(Index start, Index end);
+        public static Range All { get; }
-        public static Range All();

-        public static Range Create(Index start, Index end);

+        public static Range EndAt(Index end);
-        public static Range FromStart(Index start);

+        public Range.OffsetAndLength GetOffsetAndLength(int length);
+        public static Range StartAt(Index start);
-        public static Range ToEnd(Index end);

+        public readonly struct OffsetAndLength {
+            public OffsetAndLength(int offset, int length);
+            public int Length { get; }
+            public int Offset { get; }
+            public void Deconstruct(out int offset, out int length);
+        }
     }
     public readonly struct ReadOnlyMemory<T> {
+        public ReadOnlyMemory<T> this[Range range] { get; }
+        public ReadOnlyMemory<T> Slice(Index startIndex);
+        public ReadOnlyMemory<T> Slice(Range range);
     }
     public readonly ref struct ReadOnlySpan<T> {
+        public ReadOnlySpan<T> Slice(Index startIndex);
+        public ReadOnlySpan<T> Slice(Range range);
     }
     public readonly ref struct Span<T> {
+        public Span<T> Slice(Index startIndex);
+        public Span<T> Slice(Range range);
     }
     public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        [System.Runtime.CompilerServices.IndexerName("Chars")]
+        public char this[Index index] { get; }
+        [System.Runtime.CompilerServices.IndexerName("Chars")]
+        public string this[Range range] { get; }
+        public String Substring(Index startIndex);
+        public String Substring(Range range);
     }
 }
```

