# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
+    public abstract class JsonAttribute : Attribute {
+        protected JsonAttribute();
+    }
+    public sealed class JsonIgnoreAttribute : JsonAttribute {
+        public JsonIgnoreAttribute();
+    }
+    public abstract class JsonNamingPolicy {
+        protected JsonNamingPolicy();
+        public static JsonNamingPolicy CamelCase { get; }
+        public abstract string ConvertName(string name);
+    }
+    public sealed class JsonPropertyNameAttribute : JsonAttribute {
+        public JsonPropertyNameAttribute(string propertyName);
+        public string Name { get; set; }
+    }
     public sealed class JsonSerializerOptions {
+        public bool AllowTrailingCommas { get; set; }
+        public JsonNamingPolicy DictionaryKeyPolicy { get; set; }
-        public bool IgnoreNullPropertyValueOnRead { get; set; }

-        public bool IgnoreNullPropertyValueOnWrite { get; set; }

+        public bool IgnoreNullValues { get; set; }
+        public bool IgnoreReadOnlyProperties { get; set; }
+        public int MaxDepth { get; set; }
+        public bool PropertyNameCaseInsensitive { get; set; }
+        public JsonNamingPolicy PropertyNamingPolicy { get; set; }
+        public JsonCommentHandling ReadCommentHandling { get; set; }
-        public JsonReaderOptions ReaderOptions { get; set; }

+        public bool WriteIndented { get; set; }
-        public JsonWriterOptions WriterOptions { get; set; }

     }
 }
```

