# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public abstract class DSA : AsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public abstract class ECDiffieHellman : AsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public abstract class ECDsa : AsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
     public abstract class RSA : AsymmetricAlgorithm {
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
     }
 }
```

