# Microsoft.AspNetCore.Components.RenderTree

``` diff
 namespace Microsoft.AspNetCore.Components.RenderTree {
+    public readonly struct ArrayBuilderSegment<T> : IEnumerable, IEnumerable<T> {
+        public T[] Array { get; }
+        public int Count { get; }
+        public int Offset { get; }
+        public T this[int index] { get; }
+        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
-    public class RenderTreeBuilder {
+    public sealed class RenderTreeBuilder : IDisposable {
-        public const string ChildContent = "ChildContent";

+        public RenderTreeBuilder();
-        public RenderTreeBuilder(Renderer renderer);

-        public void AddAttribute(int sequence, string name, Action value);

-        public void AddAttribute(int sequence, string name, Action<UIEventArgs> value);

-        public void AddAttribute(int sequence, string name, Func<UIEventArgs, Task> value);

-        public void AddAttribute(int sequence, string name, Func<Task> value);

-        public void AddElementReferenceCapture(int sequence, Action<ElementRef> elementReferenceCaptureAction);

+        public void AddElementReferenceCapture(int sequence, Action<ElementReference> elementReferenceCaptureAction);
+        public void CloseRegion();
+        public void OpenRegion(int sequence);
+        void System.IDisposable.Dispose();
     }
     public readonly struct RenderTreeDiff {
+        public readonly ArrayBuilderSegment<RenderTreeEdit> Edits;
-        public readonly ArraySegment<RenderTreeEdit> Edits;

     }
     public readonly struct RenderTreeFrame {
-        [System.Runtime.InteropServices.FieldOffsetAttribute(24)]
-        public readonly Action<ElementRef> ElementReferenceCaptureAction;

+        [System.Runtime.InteropServices.FieldOffsetAttribute(24)]
+        public readonly Action<ElementReference> ElementReferenceCaptureAction;
     }
-    public enum RenderTreeFrameType {
+    public enum RenderTreeFrameType : short {
-        Attribute = 3,
+        Attribute = (short)3,
-        Component = 4,
+        Component = (short)4,
-        ComponentReferenceCapture = 7,
+        ComponentReferenceCapture = (short)7,
-        Element = 1,
+        Element = (short)1,
-        ElementReferenceCapture = 6,
+        ElementReferenceCapture = (short)6,
-        Markup = 8,
+        Markup = (short)8,
-        None = 0,
+        None = (short)0,
-        Region = 5,
+        Region = (short)5,
-        Text = 2,
+        Text = (short)2,
     }
 }
```

