# Microsoft.JSInterop.Infrastructure

``` diff
+namespace Microsoft.JSInterop.Infrastructure {
+    public static class DotNetDispatcher {
+        public static void BeginInvokeDotNet(JSRuntime jsRuntime, DotNetInvocationInfo invocationInfo, string argsJson);
+        public static void EndInvokeJS(JSRuntime jsRuntime, string arguments);
+        public static string Invoke(JSRuntime jsRuntime, in DotNetInvocationInfo invocationInfo, string argsJson);
+    }
+    public readonly struct DotNetInvocationInfo {
+        public DotNetInvocationInfo(string assemblyName, string methodIdentifier, long dotNetObjectId, string callId);
+        public string AssemblyName { get; }
+        public string CallId { get; }
+        public long DotNetObjectId { get; }
+        public string MethodIdentifier { get; }
+    }
+    public readonly struct DotNetInvocationResult {
+        public DotNetInvocationResult(Exception exception, string errorKind);
+        public DotNetInvocationResult(object result);
+        public string ErrorKind { get; }
+        public Exception Exception { get; }
+        public object Result { get; }
+        public bool Success { get; }
+    }
+}
```

