# .NET Core 3.1  Known Issues

This document lists known issues for **.NET Core 3.1 Preview 1 and beyond releases** which may be encountered during usage.

## .NET Core

Visual Studio 16.4 Preview 2 may uninstall .NET Core 3.0 when installed the .NET Core 3.1 SDK. We recommend you re-install or repair the [.NET Core 3.0 SDK](https://dotnet.microsoft.com/download/dotnet-core/3.0) if this happens. 

## .NET Core 3.1 SDK, all releases

## ASP.NET Core

### Preview1

* **[RESOLVED] Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation package is missing MSBuild targets to correctly enable runtime compilation**

Due to an package authoring error, the `Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation` is missing build targets that are required to for runtime compilation to work. 
Users of this package will see errors along the lines of `"System.InvalidOperationException: Cannot find reference assembly '...' file for package '...'*`

To resolve this issue, add the following contents to the your project file:

```xml
  <PropertyGroup>
    <PreserveCompilationContext>true</PreserveCompilationContext>
    <PreserveCompilationReferences>true</PreserveCompilationReferences>
    <GenerateRazorHostingAssemblyInfo>true</GenerateRazorHostingAssemblyInfo>
    <RazorUpToDateReloadFileTypes>$(RazorUpToDateReloadFileTypes.Replace('.cshtml', ''))</RazorUpToDateReloadFileTypes>
    <AddCshtmlFilesToDotNetWatchList>false</AddCshtmlFilesToDotNetWatchList>
  </PropertyGroup>
```
This issue has been resolved in 3.1 Preview 2. 



