# .NET Core 3.1.0 Preview 1

.NET Core 3.1.0 Preview 1 comprises:

* .NET Core Runtime 3.1.0-preview1-19506.1
* ASP.NET Core 3.1.0-preview1.19508.20
* .NET Core 3.1.100-preview1-014459

See the [Release Notes][release-notes] for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz] \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Because of the isolated environment, using Snap is the preferred way to install and try .NET Core Previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel=3.1/beta --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distributions require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for a possible resolution.

### Install using deb/rpm packages

Preview release installers are not available from the Microsoft package repositories but you can download them and install manually or, set up a local package repository. Setting up a local package repository will result in a typical package manager installation experience. Consult your distros documentation to understand this option.

A manual installation requires the use of your distribution's package installer to install each of the files *in the order presented below.* If you attempt to install them out of order, dependency checks will not succeed and the installation will fail. Download the correct System Dependencies Installer along with the `host, hostfxr, runtime, aspnetcore-runtime` and `sdk` installers.

Please see the [3.1 Supported OS](https://github.com/dotnet/core/blob/master/release-notes/3.1/3.1-supported-os.md) document for specific distribution version support status.

| **System Dependencies Installer** |
| :-- |
| [CentOS 7][dotnet-runtime-deps-centos.7-x64.rpm] |
| [Fedora][dotnet-runtime-deps-fedora.27-x64.rpm] |
| [OpenSUSE][dotnet-runtime-deps-opensuse.42-x64.rpm] |
| [Oracle Linux 7][dotnet-runtime-deps-oraclelinux.7-x64.rpm] |
| [RHEL 7][dotnet-runtime-deps-rhel.7-x64.rpm] |
| [SLES 12][dotnet-runtime-deps-sles.12-x64.rpm] |
| [Debian-based systems][dotnet-runtime-deps-x64.deb] |

| **Component** | **Package Type** |
| :--- | :---: |
| dotnet-host | [deb][dotnet-host-x64.deb] \| [rpm][dotnet-host-x64.rpm] |
| dotnet-hostfxr | [deb][dotnet-hostfxr-x64.deb] \| [rpm][dotnet-hostfxr-x64.rpm] |
| dotnet-runtime | [deb][dotnet-runtime-x64.deb] \| [rpm][dotnet-runtime-x64.rpm] |
| aspnetcore-runtime | [deb][aspnetcore-runtime-x64.deb] \| [rpm][aspnetcore-runtime-x64.rpm] |
| dotnet-targeting-pack | [deb][dotnet-targeting-pack-x64.deb] \| [rpm][dotnet-targeting-pack-x64.rpm] |
| dotnet-apphost-targeting-pack | [deb][dotnet-apphost-pack-x64.deb] \| [rpm][dotnet-apphost-pack-x64.rpm] |
| aspnetcore-targeting-pack | [deb][aspnetcore-targeting-pack.deb] \| [rpm][aspnetcore-targeting-pack.rpm] |
| dotnet-sdk | [deb][dotnet-sdk-x64.deb] \| [rpm][dotnet-sdk-x64.rpm] |

After downloading the files, run your package utility to install the files in the following order.

1. dotnet-runtime-deps (System Dependencies Installer)
2. dotnet-host
3. dotnet-hostfxr
4. dotnet-runtime
5. aspnetcore-runtime
7. dotnet-apphost-targeting-pack
8. aspnetcore-targeting-pack
9. dotnet-sdk

**CentOS, Fedora, OpenSUSE, Oracle Linux, RHEL and SLES**
`sudo rpm -ivh [package name]`

**Debian and Ubuntu**
`sudo dpkg -i [package name]`

Here is a simple example script for Fedora to download and install the packages as described above.

``` bash
cd $HOME/Downloads
mkdir 3.1preview.1
cd 3.1preview.1

wget -c https://download.visualstudio.microsoft.com/download/pr/1cb4dfea-3cd1-4308-9715-d445a8e90a87/b559fcff820841d269a27377f0295498/dotnet-host-3.1.0-preview1.19506.1-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/c1b73692-a4aa-46b3-b828-db061bd3c97f/7a4a3084955371f76e9d96a2319c4f18/dotnet-hostfxr-3.1.0-preview1.19506.1-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/6beda08b-6189-45d2-a20a-033407d9a5fc/c95ac69416fd81fc0882a7cadb033444/dotnet-runtime-3.1.0-preview1.19506.1-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/c321b140-ce08-4ad4-a082-1d2c75f80ed2/de026d15ace3ed93dadae71aae2abcaf/dotnet-runtime-deps-3.1.0-preview1.19506.1-fedora.27-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/afb589d2-f71c-43d1-86d6-984d811930a4/08c21031cb6c13aa41779b189789ada5/aspnetcore-runtime-3.1.0-preview1.19508.20-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/8862b83f-5364-457a-b42b-4bd0da1d122f/0043c62703d4498904d606b769ba3dff/dotnet-sdk-3.1.100-preview1-014459-x64.rpm

wget -c https://download.visualstudio.microsoft.com/download/pr/c6b55422-82d3-4408-b3fb-ff12a48cc812/38a7aa45b20c6dcdb9b911666ee6f5fc/dotnet-apphost-pack-3.1.0-preview1.19506.1-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/320c8699-452b-4856-8f32-024bf1e1b6df/e2478d5a0ea5da1c59512ac404613558/dotnet-targeting-pack-3.1.0-preview1.19506.1-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/9e6533da-9d4e-4061-8c44-77b705a27eba/effff4c0c40e59d88e60017d12152ba7/aspnetcore-targeting-pack-3.1.0-preview1.19508.20.rpm

sudo rpm -ivh dotnet-runtime-deps-3.1.0-preview1.19506.1-fedora.27-x64.rpm
sudo rpm -ivh dotnet-host-3.1.0-preview1.19506.1-x64.rpm
sudo rpm -ivh dotnet-hostfxr-3.1.0-preview1.19506.1-x64.rpm
sudo rpm -ivh dotnet-runtime-3.1.0-preview1.19506.1-x64.rpm
sudo rpm -ivh aspnetcore-runtime-3.1.0-preview1.19508.20-x64.rpm
sudo rpm -ivh dotnet-apphost-pack-3.1.0-preview1.19506.1-x64.rpm
sudo rpm -ivh dotnet-targeting-pack-3.1.0-preview1.19506.1-x64.rpm
sudo rpm -ivh aspnetcore-targeting-pack-3.1.0-preview1.19508.20.rpm
sudo rpm -ivh dotnet-sdk-3.1.100-preview1-014459-x64.rpm
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.1.0-preview1.19508.20-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/3.1/preview/3.1.0-preview1.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.0-preview1-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.0-preview1-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-1-preview-1/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-3-1-preview-1/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-3-1-preview-1-and-entity-framework-6-4-preview-1

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.1.0-preview1+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.1.0-preview1+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.1+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.1+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.1+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.1+label%3Aenhancement

[//]: # ( Runtime 3.1.0-preview1.19506.1)
[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/854fd933-67f3-482a-88f9-ce10aa0e7518/788970059c9f0fd4ccb55474af25b838/dotnet-apphost-pack-3.1.0-preview1.19506.1-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c6b55422-82d3-4408-b3fb-ff12a48cc812/38a7aa45b20c6dcdb9b911666ee6f5fc/dotnet-apphost-pack-3.1.0-preview1.19506.1-x64.rpm
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/140a8025-acbb-4d5f-86f4-1f27d4701691/d92cec3c2f77fb4baa55e5acc169d04b/dotnet-host-3.1.0-preview1.19506.1-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/1cb4dfea-3cd1-4308-9715-d445a8e90a87/b559fcff820841d269a27377f0295498/dotnet-host-3.1.0-preview1.19506.1-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/69fb2983-1487-4411-8605-0927f9daaf86/a34dcd100e38e2f9b05a3d35f3fd585e/dotnet-hostfxr-3.1.0-preview1.19506.1-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c1b73692-a4aa-46b3-b828-db061bd3c97f/7a4a3084955371f76e9d96a2319c4f18/dotnet-hostfxr-3.1.0-preview1.19506.1-x64.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/01ae3780-2579-432e-a8c2-481630062eed/6730c8e85750f19ae148d1afc0e72bad/dotnet-hosting-3.1.0-preview1.19508.20-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08f7b21d-b452-47e6-88a8-5ff7c74abed5/d6d539b6271f4f6f67546ad554c7b3d2/dotnet-runtime-3.1.0-preview1.19506.1-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/742876f3-281d-4cea-a9dc-8242983421b9/32282c7b47776829b4d7a2c4781dd30f/dotnet-runtime-3.1.0-preview1.19506.1-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/113caf13-dca3-47e9-8618-2234c3bda682/ad9bb28adc46615fe06c217dbc37dc4e/dotnet-runtime-3.1.0-preview1.19506.1-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2ceb8e42-f900-4500-9de0-9b159ed81b26/c1bc099d2bd35c76bf38e694df4a9226/dotnet-runtime-3.1.0-preview1.19506.1-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/50d73b14-9a37-4e53-a2dd-185772a7a8a1/683df9537ff2e24da62f66c624b37211/dotnet-runtime-3.1.0-preview1.19506.1-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73285ebb-04a3-458b-b214-95f86322d659/c18f8d94a6938f593a3e9b2e78634763/dotnet-runtime-3.1.0-preview1.19506.1-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c759f754-3580-433c-941a-5a037d961093/e25d1aa51e060456a145886c9051391e/dotnet-runtime-3.1.0-preview1.19506.1-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c0452a1f-84c5-4cfe-b821-26a9e6cba298/a99144a292baff6a62cb378461a82c62/dotnet-runtime-3.1.0-preview1.19506.1-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1bf0a2c1-a8b7-4a4f-a11b-ea940c01993a/1ab8d70e092a1da6fdc9ebf2a617837b/dotnet-runtime-3.1.0-preview1.19506.1-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/976ca3c2-6023-44a1-854e-f23b31b76e1c/90a8e10622407dcd0933684f6b18801d/dotnet-runtime-3.1.0-preview1.19506.1-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ed77351f-b3c4-465d-aee8-8397e9ca7cb0/c4dcbbf243bb88caa71c6df9197d8136/dotnet-runtime-3.1.0-preview1.19506.1-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/eca1e2b1-134a-4c40-bb4a-ded1589d11ca/8ae3f156fb4048c88ba45d7b2be7cd88/dotnet-runtime-3.1.0-preview1.19506.1-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/cb9fc2e4-8257-4104-a369-ca8ce543bc00/49b48fa9106a0fb283141ed81c0ca607/dotnet-runtime-3.1.0-preview1.19506.1-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6beda08b-6189-45d2-a20a-033407d9a5fc/c95ac69416fd81fc0882a7cadb033444/dotnet-runtime-3.1.0-preview1.19506.1-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/2441e0a7-22a4-4515-a7fd-f9a990e7abdd/837bf74eca65ff0932ce6763413dfad8/dotnet-runtime-deps-3.1.0-preview1.19506.1-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/c321b140-ce08-4ad4-a082-1d2c75f80ed2/de026d15ace3ed93dadae71aae2abcaf/dotnet-runtime-deps-3.1.0-preview1.19506.1-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f2a006d7-8a33-48d9-9750-ed6dbc43e790/16b18a3c276242eb73d57d69bbbf3f78/dotnet-runtime-deps-3.1.0-preview1.19506.1-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/22b5f66e-9588-4476-b75b-8b112ddb0891/8e1efaddf09670dd0c15a784024feb5d/dotnet-runtime-deps-3.1.0-preview1.19506.1-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ad7e45e5-6cdc-40e8-a39a-903c3694b522/1e661e8d38d9276922b359450ebd3583/dotnet-runtime-deps-3.1.0-preview1.19506.1-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/00399049-cb5b-4b5c-a1e5-0b0a45365675/38381ad1a904457487e63d64c9760c90/dotnet-runtime-deps-3.1.0-preview1.19506.1-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/9ebf702d-109d-4226-bdd7-f28295088d42/fa17aad9d1283c6a7647a49065470bea/dotnet-runtime-deps-3.1.0-preview1.19506.1-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/91e262b4-9cdc-4486-9537-7561050f5123/b1dc8c3e122f8c32e91d241c47a37d76/dotnet-targeting-pack-3.1.0-preview1.19506.1-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/320c8699-452b-4856-8f32-024bf1e1b6df/e2478d5a0ea5da1c59512ac404613558/dotnet-targeting-pack-3.1.0-preview1.19506.1-x64.rpm
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/54d047f4-55f1-468c-b617-046507a19b28/c939c5b29580d7baf32d64cecc5f6c60/windowsdesktop-runtime-3.1.0-preview1.19506.1-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5fbc4686-a00f-4c49-b3f8-d98cacec806e/a76394afa3ccc1c1e3000a9dc71c247d/windowsdesktop-runtime-3.1.0-preview1.19506.1-win-x86.exe

[//]: # ( ASP 3.1.0-preview1.19508.20)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f1b8563a-cf7c-4931-ba87-2a1dbd43736b/c9df5adc35dacb0a0a792daea92ee7ad/aspnetcore-runtime-3.1.0-preview1.19508.20-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7370e950-110f-4e65-b2db-021255f68098/7c29bd653e61a8bcd7e7a79121127dba/aspnetcore-runtime-3.1.0-preview1.19508.20-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e2968cc4-d134-46db-a9e6-f6a8aefd17bc/6ff72137f7119feebae68b3bc720fd5f/aspnetcore-runtime-3.1.0-preview1.19508.20-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66d6edaf-6183-4ecb-a536-7483b92b6047/6e7f38d9c03a4b786040db7b23a8fed4/aspnetcore-runtime-3.1.0-preview1.19508.20-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/93811a37-ce18-4089-8e2a-fad0de68de3d/0a00a535c5d98a59c3f2606319899cf5/aspnetcore-runtime-3.1.0-preview1.19508.20-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/cdd38fb7-5ef4-4f72-9a08-77d797a3f1bc/c7a7e96d1a8c7cc6ae64c32269061c49/aspnetcore-runtime-3.1.0-preview1.19508.20-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4e81d52d-f39c-4448-8a06-f2458550ba3e/6ddde417245072c58c1e975be17b0925/aspnetcore-runtime-3.1.0-preview1.19508.20-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/ae466224-ec18-43f3-b51a-8e78b984bc62/8ba2c2d3e28e310dbad8bfeac58b054d/aspnetcore-runtime-3.1.0-preview1.19508.20-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/de492131-8cf7-405b-bbab-5a281c355ef9/ef7dc88237ff912660702d5ddd6ae695/aspnetcore-runtime-3.1.0-preview1.19508.20-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2b13155d-362a-47d7-b6bb-ff97bfaf7843/f582d6fefc63ae5f859e483cbe266337/aspnetcore-runtime-3.1.0-preview1.19508.20-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8c7b3f62-206a-4c2a-b8af-3ac93bd2ed98/667e37391a36acb71e4bdf0eec328ae1/aspnetcore-runtime-3.1.0-preview1.19508.20-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/c5ec79fb-a627-4c87-8029-171fc167197f/db20e6a985365e89150be1e2dc70a2ee/aspnetcore-runtime-3.1.0-preview1.19508.20-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/afb589d2-f71c-43d1-86d6-984d811930a4/08c21031cb6c13aa41779b189789ada5/aspnetcore-runtime-3.1.0-preview1.19508.20-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/bbb0636d-2e45-4f22-ba2a-6e85ba4aa360/c5385eb780203707a6f6a7b3dbcf4cf3/aspnetcore-targeting-pack-3.1.0-preview1.19508.20.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/9e6533da-9d4e-4061-8c44-77b705a27eba/effff4c0c40e59d88e60017d12152ba7/aspnetcore-targeting-pack-3.1.0-preview1.19508.20.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/01ae3780-2579-432e-a8c2-481630062eed/6730c8e85750f19ae148d1afc0e72bad/dotnet-hosting-3.1.0-preview1.19508.20-win.exe

[//]: # ( SDK 3.1.100-preview1-014459 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/add0da94-569b-462d-a3d4-f29407cb9386/9570da173af00033d6b5d9aaf6603450/dotnet-sdk-3.1.100-preview1-014459-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3cf6ae0b-5933-461f-b32d-10bae9199a97/ff5251238265d20f07ff62181d3e2d1d/dotnet-sdk-3.1.100-preview1-014459-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d43b6a8-2855-4318-98ae-2515c75503e4/8ae1142fdd85385e4d1a62bc3b33b925/dotnet-sdk-3.1.100-preview1-014459-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3cc3d8a-226d-4306-a61b-a5446fdb72ef/604e029047aec0229545e8c397a14ddb/dotnet-sdk-3.1.100-preview1-014459-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/516f4938-dcb8-4e5a-aefc-0e7b11730a4b/9afc9a668d97ba280aa1962194305ba3/dotnet-sdk-3.1.100-preview1-014459-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1961368e-97df-439b-99ef-e14a6e65fa7c/73a793ceefdcf3348833843220fb2f1e/dotnet-sdk-3.1.100-preview1-014459-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/209443d9-2b6c-4eb5-950d-c9afc06ef7ce/f2ef7a20cb007976fbba8527233298ac/dotnet-sdk-3.1.100-preview1-014459-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4c981b39-2075-43d1-8a75-863b886a7744/c1ecd27ae15df9a1c75585f5d0b5aebc/dotnet-sdk-3.1.100-preview1-014459-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3c80ce15-78a4-402c-a887-58119f2546b5/4bf7731ac1f278d7c8c9e30c81629316/dotnet-sdk-3.1.100-preview1-014459-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d5f66bc0-ceaf-4ae8-979a-348fce24f500/39a33cbdc8d33e3eb477b6dfd0d61efc/dotnet-sdk-3.1.100-preview1-014459-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0f899d0e-8403-448d-b206-5bacbed34b46/5394c8fc72225aebce4a022c2469bb7b/dotnet-sdk-3.1.100-preview1-014459-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/27d2c031-1df4-42e9-8496-489e3c0eec3b/e50eba8133e81061034266227513664d/dotnet-sdk-3.1.100-preview1-014459-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/84eb3f51-bd69-4c68-b03d-4ce3a83822f1/1d35ddefa5fd2b3bd15430253cfc0521/dotnet-sdk-3.1.100-preview1-014459-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/8862b83f-5364-457a-b42b-4bd0da1d122f/0043c62703d4498904d606b769ba3dff/dotnet-sdk-3.1.100-preview1-014459-x64.rpm
